/*
 * Decompiled with CFR 0.152.
 */
package hudson.plugins.active_directory;

import java.io.IOException;
import java.net.InetAddress;
import java.net.Socket;
import java.net.UnknownHostException;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.annotation.CheckForNull;

public class SocketInfo {
    private final String host;
    private final int port;
    private static final Logger LOGGER = Logger.getLogger(SocketInfo.class.getName());

    public SocketInfo(String host, int port) {
        this.host = host;
        this.port = port;
    }

    public SocketInfo(String hostAndPort) {
        int idx = hostAndPort.lastIndexOf(58);
        if (idx < 0) {
            this.host = hostAndPort;
            this.port = 0;
        } else {
            this.host = hostAndPort.substring(0, idx);
            this.port = Integer.parseInt(hostAndPort.substring(idx + 1));
        }
    }

    public String toString() {
        return this.port == 0 ? this.host : this.host + ':' + this.port;
    }

    public String getHost() {
        return this.host;
    }

    public int getPort() {
        return this.port;
    }

    public Socket connect() throws IOException {
        return new Socket(this.host, this.port);
    }

    @CheckForNull
    public String getIpAddress() {
        try {
            InetAddress inetAddress = InetAddress.getByName(this.host);
            return inetAddress.getHostAddress();
        }
        catch (UnknownHostException e) {
            LOGGER.log(Level.FINE, String.format("The Ip address for the host %s could not be retrieved", this.host), e);
            return null;
        }
    }
}

