/*
 * Decompiled with CFR 0.152.
 */
package hudson.plugins.active_directory;

import hudson.model.UserProperty;
import hudson.tasks.Mailer;
import java.io.IOException;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.acegisecurity.GrantedAuthority;
import org.acegisecurity.userdetails.User;
import org.acegisecurity.userdetails.UserDetails;

public class ActiveDirectoryUserDetail
extends User {
    private final String displayName;
    private final String mail;
    private final String telephoneNumber;
    private String toStringValue;
    private static final long serialVersionUID = 1L;
    private static final Logger LOGGER = Logger.getLogger(ActiveDirectoryUserDetail.class.getName());

    public ActiveDirectoryUserDetail(String username, String password, boolean enabled, boolean accountNonExpired, boolean credentialsNonExpired, boolean accountNonLocked, GrantedAuthority[] authorities, String displayName, String mail, String telephoneNumber) throws IllegalArgumentException {
        super(username, password != null ? password : "PASSWORD", enabled, accountNonExpired, credentialsNonExpired, accountNonLocked, authorities);
        this.displayName = displayName;
        this.mail = mail;
        this.telephoneNumber = telephoneNumber;
    }

    public String getDisplayName() {
        return this.displayName;
    }

    public String getMail() {
        return this.mail;
    }

    public String getTelephoneNumber() {
        return this.telephoneNumber;
    }

    public String toString() {
        return this.toStringValue;
    }

    protected void setAuthorities(GrantedAuthority[] authorities) {
        super.setAuthorities(authorities);
        StringBuffer sb = new StringBuffer();
        sb.append(super.toString()).append(": ");
        sb.append("Username: ").append(this.getUsername()).append("; ");
        sb.append("Password: [PROTECTED]; ");
        sb.append("Enabled: ").append(this.isEnabled()).append("; ");
        sb.append("AccountNonExpired: ").append(this.isAccountNonExpired()).append("; ");
        sb.append("credentialsNonExpired: ").append(this.isCredentialsNonExpired()).append("; ");
        sb.append("AccountNonLocked: ").append(this.isAccountNonLocked()).append("; ");
        if (this.getAuthorities() != null) {
            sb.append("Granted Authorities: ");
            for (int i = 0; i < this.getAuthorities().length; ++i) {
                if (i > 0) {
                    sb.append(", ");
                }
                sb.append(this.getAuthorities()[i].toString());
            }
        } else {
            sb.append("Not granted any authorities");
        }
        this.toStringValue = sb.toString();
    }

    public static long getSerialVersionUID() {
        return 1L;
    }

    public hudson.model.User getJenkinsUser() {
        return hudson.model.User.get((String)this.getUsername());
    }

    public UserDetails updateUserInfo() {
        hudson.model.User u = this.getJenkinsUser();
        if (this.getDisplayName() != null && u.getId().equals(u.getFullName())) {
            u.setFullName(this.getDisplayName());
        }
        if (this.getMail() != null) {
            try {
                u.addProperty((UserProperty)new Mailer.UserProperty(this.getMail()));
            }
            catch (IOException e) {
                LOGGER.log(Level.WARNING, "Failed to associate the e-mail address", e);
            }
        }
        return this;
    }
}

