/*
 * Decompiled with CFR 0.152.
 */
package hudson.plugins.active_directory;

import com4j.COM4J;
import com4j.Com4jObject;
import com4j.ComException;
import com4j.ComObjectListener;
import com4j.Variant;
import com4j.typelibs.activeDirectory.IADs;
import com4j.typelibs.activeDirectory.IADsGroup;
import com4j.typelibs.activeDirectory.IADsOpenDSObject;
import com4j.typelibs.activeDirectory.IADsUser;
import com4j.typelibs.ado20.ClassFactory;
import com4j.typelibs.ado20._Command;
import com4j.typelibs.ado20._Connection;
import com4j.typelibs.ado20._Recordset;
import com4j.util.ComObjectCollector;
import hudson.plugins.active_directory.AbstractActiveDirectoryAuthenticationProvider;
import hudson.plugins.active_directory.ActiveDirectoryGroupDetails;
import hudson.plugins.active_directory.ActiveDirectoryUserDetail;
import hudson.plugins.active_directory.Cache;
import hudson.security.GroupDetails;
import hudson.security.SecurityRealm;
import java.util.ArrayList;
import java.util.logging.Logger;
import org.acegisecurity.AuthenticationException;
import org.acegisecurity.BadCredentialsException;
import org.acegisecurity.GrantedAuthority;
import org.acegisecurity.GrantedAuthorityImpl;
import org.acegisecurity.providers.UsernamePasswordAuthenticationToken;
import org.acegisecurity.userdetails.UserDetails;
import org.acegisecurity.userdetails.UsernameNotFoundException;

public class ActiveDirectoryAuthenticationProvider
extends AbstractActiveDirectoryAuthenticationProvider {
    private final String defaultNamingContext;
    private final _Connection con;
    private final Cache<String, ActiveDirectoryGroupDetails, UsernameNotFoundException> groupCache = new Cache<String, ActiveDirectoryGroupDetails, UsernameNotFoundException>(){

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        protected ActiveDirectoryGroupDetails compute(String groupname) {
            ComObjectCollector col = new ComObjectCollector();
            COM4J.addListener((ComObjectListener)col);
            try {
                String dn = ActiveDirectoryAuthenticationProvider.this.getDnOfUserOrGroup(groupname);
                IADsOpenDSObject dso = (IADsOpenDSObject)COM4J.getObject(IADsOpenDSObject.class, (String)"LDAP:", null);
                IADsGroup group = (IADsGroup)dso.openDSObject("LDAP://" + dn, null, null, 0).queryInterface(IADsGroup.class);
                if (group == null) {
                    ActiveDirectoryGroupDetails activeDirectoryGroupDetails = null;
                    return activeDirectoryGroupDetails;
                }
                ActiveDirectoryGroupDetails activeDirectoryGroupDetails = new ActiveDirectoryGroupDetails(groupname);
                return activeDirectoryGroupDetails;
            }
            catch (UsernameNotFoundException e) {
                ActiveDirectoryGroupDetails activeDirectoryGroupDetails = null;
                return activeDirectoryGroupDetails;
            }
            finally {
                col.disposeAll();
                COM4J.removeListener((ComObjectListener)col);
            }
        }
    };
    private static final Logger LOGGER = Logger.getLogger(ActiveDirectoryAuthenticationProvider.class.getName());

    public ActiveDirectoryAuthenticationProvider() {
        IADs rootDSE = (IADs)COM4J.getObject(IADs.class, (String)"LDAP://RootDSE", null);
        this.defaultNamingContext = (String)rootDSE.get("defaultNamingContext");
        LOGGER.info("Active Directory domain is " + this.defaultNamingContext);
        this.con = ClassFactory.createConnection();
        this.con.provider("ADsDSOObject");
        this.con.open("Active Directory Provider", "", "", -1);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected UserDetails retrieveUser(String username, UsernamePasswordAuthenticationToken authentication) throws AuthenticationException {
        String password = null;
        if (authentication != null) {
            password = (String)authentication.getCredentials();
        }
        String dn = this.getDnOfUserOrGroup(username);
        ComObjectCollector col = new ComObjectCollector();
        COM4J.addListener((ComObjectListener)col);
        try {
            IADsUser usr;
            IADsOpenDSObject dso = (IADsOpenDSObject)COM4J.getObject(IADsOpenDSObject.class, (String)"LDAP:", null);
            try {
                usr = (IADsUser)(authentication == null ? dso.openDSObject("LDAP://" + dn, null, null, 0) : dso.openDSObject("LDAP://" + dn, dn, password, 0)).queryInterface(IADsUser.class);
            }
            catch (ComException e) {
                throw new BadCredentialsException("Incorrect password for " + username);
            }
            if (usr == null) {
                throw new UsernameNotFoundException("User not found: " + username);
            }
            ArrayList<Object> groups = new ArrayList<Object>();
            for (Com4jObject g : usr.groups()) {
                IADsGroup grp = (IADsGroup)g.queryInterface(IADsGroup.class);
                groups.add(new GrantedAuthorityImpl(grp.name().substring(3)));
            }
            groups.add(SecurityRealm.AUTHENTICATED_AUTHORITY);
            UserDetails userDetails = new ActiveDirectoryUserDetail(username, password, !this.isAccountDisabled(usr), true, true, true, groups.toArray(new GrantedAuthority[groups.size()]), this.getFullName(usr), this.getEmailAddress(usr), this.getTelehoneNumber(usr)).updateUserInfo();
            return userDetails;
        }
        finally {
            col.disposeAll();
            COM4J.removeListener((ComObjectListener)col);
        }
    }

    protected boolean canRetrieveUserByName() {
        return true;
    }

    private String getTelehoneNumber(IADsUser usr) {
        try {
            Object t = usr.telephoneNumber();
            return t == null ? null : t.toString();
        }
        catch (ComException e) {
            if (e.getHRESULT() == -2147463155) {
                return null;
            }
            throw e;
        }
    }

    private String getEmailAddress(IADsUser usr) {
        try {
            return usr.emailAddress();
        }
        catch (ComException e) {
            if (e.getHRESULT() == -2147463155) {
                return null;
            }
            throw e;
        }
    }

    private String getFullName(IADsUser usr) {
        try {
            return usr.fullName();
        }
        catch (ComException e) {
            if (e.getHRESULT() == -2147463155) {
                return null;
            }
            throw e;
        }
    }

    private boolean isAccountDisabled(IADsUser usr) {
        try {
            return usr.accountDisabled();
        }
        catch (ComException e) {
            if (e.getHRESULT() == -2147463155) {
                return false;
            }
            throw e;
        }
    }

    private String getDnOfUserOrGroup(String userOrGroupname) throws UsernameNotFoundException {
        _Command cmd = ClassFactory.createCommand();
        cmd.activeConnection(this.con);
        cmd.commandText("<LDAP://" + this.defaultNamingContext + ">;(sAMAccountName=" + userOrGroupname + ");distinguishedName;subTree");
        _Recordset rs = cmd.execute(null, (Object)Variant.getMissing(), -1);
        if (rs.eof()) {
            throw new UsernameNotFoundException("No such user or group: " + userOrGroupname);
        }
        String dn = rs.fields().item((Object)"distinguishedName").value().toString();
        return dn;
    }

    public GroupDetails loadGroupByGroupname(String groupname) {
        ActiveDirectoryGroupDetails details = this.groupCache.get(groupname);
        if (details != null) {
            return details;
        }
        throw new UsernameNotFoundException("Group not found: " + groupname);
    }
}

