/*
 * Decompiled with CFR 0.152.
 */
package com.testfairy.uploader;

import com.testfairy.apk.ApkArchiveFilterVisitor;
import com.testfairy.apk.ApkArchiveReader;
import com.testfairy.apk.ApkArchiveWriter;
import com.testfairy.uploader.TestFairyException;
import com.testfairy.uploader.command.JarSignerCommand;
import com.testfairy.uploader.command.VerifyCommand;
import com.testfairy.uploader.command.ZipAlignCommand;
import hudson.EnvVars;
import java.io.DataInputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.PrintStream;
import java.io.StringWriter;
import java.io.UnsupportedEncodingException;
import java.io.Writer;
import java.util.List;
import java.util.Scanner;
import net.sf.json.JSONObject;
import org.apache.commons.io.IOUtils;
import org.apache.http.HttpEntity;
import org.apache.http.HttpHost;
import org.apache.http.HttpResponse;
import org.apache.http.auth.AuthScope;
import org.apache.http.auth.Credentials;
import org.apache.http.auth.UsernamePasswordCredentials;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.entity.mime.MultipartEntity;
import org.apache.http.entity.mime.content.ContentBody;
import org.apache.http.entity.mime.content.FileBody;
import org.apache.http.entity.mime.content.StringBody;
import org.apache.http.impl.client.DefaultHttpClient;
import org.jenkinsci.plugins.testfairy.TestFairyAndroidRecorder;
import org.jenkinsci.plugins.testfairy.TestFairyBaseRecorder;
import org.jenkinsci.plugins.testfairy.Utils;

public class Uploader {
    public static String VERSION = "0.0";
    private static String SERVER = "https://upload.testfairy.com";
    private static final String UPLOAD_URL_PATH = "/api/upload";
    private static final String UPLOAD_SIGNED_URL_PATH = "/api/upload-signed";
    public static String USER_AGENT = "TestFairy Jenkins Plugin VERSION:" + VERSION;
    public static String JENKINS_URL = "[jenkinsURL]/";
    private PrintStream logger;

    public Uploader(PrintStream logger, String version) {
        VERSION = version;
        USER_AGENT = "TestFairy Jenkins Plugin VERSION:" + VERSION;
        this.logger = logger;
    }

    private DefaultHttpClient buildHttpClient() {
        DefaultHttpClient httpClient = new DefaultHttpClient();
        String proxyHost = System.getProperty("http.proxyHost");
        if (proxyHost != null) {
            Integer proxyPort = System.getProperty("http.proxyPort") != null ? Integer.parseInt(System.getProperty("http.proxyPort")) : -1;
            HttpHost proxy = new HttpHost(proxyHost, proxyPort.intValue());
            String proxyUser = System.getProperty("http.proxyUser");
            if (proxyUser != null) {
                AuthScope authScope = new AuthScope(proxyUser, proxyPort.intValue());
                UsernamePasswordCredentials credentials = new UsernamePasswordCredentials(proxyUser, System.getProperty("http.proxyPassword"));
                httpClient.getCredentialsProvider().setCredentials(authScope, (Credentials)credentials);
            }
            httpClient.getParams().setParameter("http.route.default-proxy", (Object)proxy);
        }
        return httpClient;
    }

    private String post(String url, MultipartEntity entity) throws IOException, TestFairyException {
        DefaultHttpClient httpClient = this.buildHttpClient();
        HttpPost post = new HttpPost(url);
        post.addHeader("User-Agent", USER_AGENT);
        post.setEntity((HttpEntity)entity);
        try {
            HttpResponse response = httpClient.execute((HttpUriRequest)post);
            InputStream is = response.getEntity().getContent();
            int statusCode = response.getStatusLine().getStatusCode();
            if (statusCode != 200) {
                String responseBody = new Scanner(is).useDelimiter("\\A").next();
                throw new TestFairyException(responseBody);
            }
            StringWriter writer = new StringWriter();
            IOUtils.copy((InputStream)is, (Writer)writer, (String)"UTF-8");
            String responseString = writer.toString();
            this.logger.println("post finished " + responseString);
            JSONObject json = JSONObject.fromObject((Object)responseString);
            if (json.getString("status").equals("fail")) {
                String errorMessage = json.getString("message");
                throw new TestFairyException(errorMessage);
            }
            return responseString;
        }
        catch (Throwable t) {
            if (t instanceof TestFairyException) {
                throw new TestFairyException(t.getMessage());
            }
            throw new IOException("Post failed " + t.getMessage(), t);
        }
    }

    private void downloadFile(String url, String localFilename) throws IOException {
        DefaultHttpClient httpClient = this.buildHttpClient();
        HttpGet httpget = new HttpGet(url);
        HttpResponse response = httpClient.execute((HttpUriRequest)httpget);
        HttpEntity entity = response.getEntity();
        FileOutputStream fis = new FileOutputStream(localFilename);
        IOUtils.copy((InputStream)entity.getContent(), (OutputStream)fis);
        fis.close();
    }

    public String uploadApp(String apkFilename, String mappingFile, String changeLog, TestFairyBaseRecorder recorder, Boolean isInstrumentationOff) throws IOException, TestFairyException {
        this.logger.println("Uploading App...");
        MultipartEntity entity = this.buildEntity(recorder, apkFilename, mappingFile, changeLog, isInstrumentationOff);
        return this.post(SERVER + UPLOAD_URL_PATH, entity);
    }

    public String uploadSignedApk(String apkFilename, String mappingFile, TestFairyBaseRecorder recorder) throws IOException, TestFairyException {
        this.logger.println("Uploading SignedApk...");
        MultipartEntity entity = new MultipartEntity();
        this.addFileEntity(entity, "apk_file", apkFilename);
        this.addFileEntity(entity, "proguard_file", mappingFile);
        this.addEntity(entity, "api_key", recorder.getApiKey());
        this.addEntity(entity, "testers-groups", recorder.getTestersGroups());
        this.addEntity(entity, "notify", recorder.getNotifyTesters());
        this.addEntity(entity, "auto-update", recorder.getAutoUpdate());
        return this.post(SERVER + UPLOAD_SIGNED_URL_PATH, entity);
    }

    private MultipartEntity buildEntity(TestFairyBaseRecorder recorder, String apkFilename, String mappingFile, String changeLog, Boolean isInstrumentationOff) throws IOException {
        MultipartEntity entity = new MultipartEntity();
        this.addFileEntity(entity, "apk_file", apkFilename);
        this.addFileEntity(entity, "proguard_file", mappingFile);
        this.addEntity(entity, "api_key", recorder.getApiKey());
        this.addEntity(entity, "changelog", changeLog);
        this.addEntity(entity, "video-quality", recorder.getVideoQuality());
        this.addEntity(entity, "screenshot-interval", recorder.getScreenshotInterval());
        this.addEntity(entity, "max-duration", recorder.getMaxDuration());
        this.addEntity(entity, "testers-groups", recorder.getTestersGroups());
        this.addEntity(entity, "advanced-options", recorder.getAdvancedOptions());
        this.addEntity(entity, "data-only-wifi", recorder.getDataOnlyWifi());
        this.addEntity(entity, "record-on-background", recorder.getRecordOnBackground());
        this.addEntity(entity, "video", recorder.getIsVideoEnabled());
        if (isInstrumentationOff.booleanValue()) {
            this.addEntity(entity, "auto-update", recorder.getAutoUpdate());
            this.addEntity(entity, "notify", recorder.getNotifyTesters());
            this.addEntity(entity, "instrumentation", "off");
        }
        entity.addPart("metrics", (ContentBody)new StringBody(this.extractMetrics(recorder)));
        return entity;
    }

    private void addEntity(MultipartEntity entity, String name, String value) throws UnsupportedEncodingException {
        if (value != null && !value.isEmpty()) {
            this.logger.println("--add " + name + ": " + value.replace("\n", ""));
            entity.addPart(name, (ContentBody)new StringBody(value));
        }
    }

    private void addEntity(MultipartEntity entity, String name, Boolean value) throws UnsupportedEncodingException {
        this.logger.println("--add " + name + ": " + (value != false ? "on" : "off"));
        entity.addPart(name, (ContentBody)new StringBody(value != false ? "on" : "off"));
    }

    private void addFileEntity(MultipartEntity entity, String name, String filePath) throws UnsupportedEncodingException {
        if (filePath != null && !filePath.isEmpty()) {
            this.logger.println("--add (file) " + name + ": " + filePath);
            entity.addPart(name, (ContentBody)new FileBody(new File(filePath)));
        }
    }

    private String extractMetrics(TestFairyBaseRecorder baseRecorder) {
        StringBuilder stringBuilder = new StringBuilder();
        String metrics = "";
        if (baseRecorder.getCpu().booleanValue()) {
            stringBuilder.append(",cpu");
        }
        if (baseRecorder.getMemory().booleanValue()) {
            stringBuilder.append(",memory");
        }
        if (baseRecorder.getNetwork().booleanValue()) {
            stringBuilder.append(",network");
        }
        if (baseRecorder.getLogs().booleanValue()) {
            stringBuilder.append(",logcat");
        }
        if (baseRecorder.getPhoneSignal().booleanValue()) {
            stringBuilder.append(",phone-signal");
        }
        if (baseRecorder.getWifi().booleanValue()) {
            stringBuilder.append(",wifi");
        }
        if (baseRecorder.getGps().booleanValue()) {
            stringBuilder.append(",gps");
        }
        if (baseRecorder.getBattery().booleanValue()) {
            stringBuilder.append(",battery");
        }
        if (baseRecorder.getOpenGl().booleanValue()) {
            stringBuilder.append(",opengl");
        }
        if (stringBuilder.length() > 0) {
            metrics = stringBuilder.substring(1);
        }
        this.logger.println("Metrics: " + metrics);
        return metrics;
    }

    public String signingApk(TestFairyAndroidRecorder.AndroidBuildEnvironment environment, String apkFilename, TestFairyAndroidRecorder recorder) throws IOException, InterruptedException, TestFairyException {
        String unsignedApkPath = Utils.createEmptyFile();
        ApkArchiveWriter writer = new ApkArchiveWriter(new FileOutputStream(unsignedApkPath));
        ApkArchiveFilterVisitor filterVisitor = new ApkArchiveFilterVisitor(writer);
        filterVisitor.addFilter("META-INF" + File.separator + "*");
        ApkArchiveReader reader = new ApkArchiveReader(apkFilename);
        reader.accept(filterVisitor);
        JarSignerCommand jarSignerCommand = new JarSignerCommand(environment.jarsignerPath, recorder, unsignedApkPath);
        String out = this.exec(jarSignerCommand);
        if (out.contains("error") || out.contains("unsigned")) {
            throw new TestFairyException(out);
        }
        VerifyCommand verifyCommand = new VerifyCommand(environment.jarsignerPath, unsignedApkPath);
        this.exec(verifyCommand);
        String apkFilenameZipAlign = Utils.createEmptyFile();
        ZipAlignCommand zipAlignCommand = new ZipAlignCommand(environment.zipalignPath, unsignedApkPath, apkFilenameZipAlign);
        this.exec(zipAlignCommand);
        return apkFilenameZipAlign;
    }

    private String exec(List<String> command) throws IOException, InterruptedException, TestFairyException {
        String outputString;
        this.logger.println("exec command: " + command);
        String outputStringToReturn = "";
        ProcessBuilder pb = new ProcessBuilder(command);
        Process process = pb.start();
        process.waitFor();
        DataInputStream curlIn = new DataInputStream(process.getInputStream());
        while ((outputString = curlIn.readLine()) != null) {
            outputStringToReturn = outputStringToReturn + outputString;
        }
        this.logger.println("Output: " + outputStringToReturn);
        this.logger.println("exitValue(): " + process.exitValue());
        if (process.exitValue() > 0) {
            throw new TestFairyException(outputStringToReturn.isEmpty() ? "Error on " + command : outputStringToReturn);
        }
        return outputStringToReturn;
    }

    public static void setServer(EnvVars vars, PrintStream logger) {
        String server = vars.expand("$TESTFAIRY_UPLOADER_SERVER");
        if (server != null && !server.isEmpty() && !server.equals("$TESTFAIRY_UPLOADER_SERVER")) {
            SERVER = server;
            logger.println("The server will be  " + SERVER);
        }
    }
}

