/*
 * Decompiled with CFR 0.152.
 */
package com.testfairy.apk;

import com.testfairy.apk.ApkArchiveEntry;
import com.testfairy.apk.ApkArchiveVisitor;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import org.apache.commons.compress.archivers.zip.ZipArchiveEntry;
import org.apache.commons.compress.archivers.zip.ZipArchiveInputStream;

public class ApkArchiveReader {
    private ZipArchiveInputStream zipArchive = null;

    public ApkArchiveReader(String f) throws IOException {
        this.zipArchive = new ZipArchiveInputStream((InputStream)new FileInputStream(f));
    }

    public void accept(ApkArchiveVisitor listener) throws IOException {
        ZipArchiveEntry entry;
        listener.visit();
        while ((entry = this.zipArchive.getNextZipEntry()) != null) {
            listener.visitEntry(new VirtualEntry(entry));
        }
        listener.visitEnd();
    }

    private class VirtualEntry
    implements ApkArchiveEntry {
        private ZipArchiveEntry archiveEntry;

        public VirtualEntry(ZipArchiveEntry archiveEntry) {
            this.archiveEntry = archiveEntry;
        }

        @Override
        public String getFilename() {
            return this.archiveEntry.getName();
        }

        @Override
        public long getSize() {
            return this.archiveEntry.getSize();
        }

        @Override
        public int getMethod() {
            return this.archiveEntry.getMethod();
        }

        @Override
        public long getCompressedSize() {
            return this.archiveEntry.getCompressedSize();
        }

        @Override
        public long getCrc() {
            return this.archiveEntry.getCrc();
        }

        @Override
        public InputStream getInputStream() {
            return ApkArchiveReader.this.zipArchive;
        }
    }
}

