/*
 * Decompiled with CFR 0.152.
 */
package com.testfairy.apk;

import com.testfairy.apk.ApkArchiveEntry;
import com.testfairy.apk.ApkArchiveVisitor;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.HashMap;
import java.util.Map;
import java.util.zip.CRC32;

public class ApkArchiveAddVisitor
extends ApkArchiveVisitor {
    private Map<String, byte[]> files = new HashMap<String, byte[]>();

    public ApkArchiveAddVisitor() {
    }

    public ApkArchiveAddVisitor(ApkArchiveVisitor av) {
        super(av);
    }

    public void addFile(String filename, byte[] data) {
        this.files.put(filename, data);
    }

    @Override
    public void visitEnd() throws IOException {
        for (Map.Entry<String, byte[]> entry : this.files.entrySet()) {
            this.visitEntry(new VirtualEntry(entry.getKey(), entry.getValue()));
        }
        super.visitEnd();
    }

    private static class VirtualEntry
    implements ApkArchiveEntry {
        private String name;
        private byte[] data;

        public VirtualEntry(String name, byte[] data) {
            this.name = name;
            this.data = data;
        }

        @Override
        public String getFilename() {
            return this.name;
        }

        @Override
        public long getSize() {
            return this.data.length;
        }

        @Override
        public long getCompressedSize() {
            return this.data.length;
        }

        @Override
        public int getMethod() {
            return 8;
        }

        @Override
        public long getCrc() {
            CRC32 crc32 = new CRC32();
            crc32.update(this.data);
            return crc32.getValue();
        }

        @Override
        public InputStream getInputStream() {
            return new ByteArrayInputStream(this.data);
        }
    }
}

