/*
 * Decompiled with CFR 0.152.
 */
package org.jenkinsci.main.modules.sshd;

import java.util.logging.Logger;
import org.apache.sshd.server.ServerFactoryManager;
import org.apache.sshd.server.SshServer;
import org.kohsuke.accmod.Restricted;
import org.kohsuke.accmod.restrictions.NoExternalUse;

@Restricted(value={NoExternalUse.class})
public class IdleTimeout {
    private static final Logger LOGGER = Logger.getLogger(IdleTimeout.class.getName());
    private final Long timeoutInMilliseconds;

    IdleTimeout(Long timeoutInMilliseconds) {
        this.timeoutInMilliseconds = timeoutInMilliseconds;
    }

    public static IdleTimeout fromSystemProperty(String propertyName) {
        String propertyValue = System.getProperty(propertyName);
        if (propertyValue == null) {
            return new IdleTimeout(null);
        }
        try {
            return new IdleTimeout(Long.parseLong(propertyValue));
        }
        catch (NumberFormatException nfe) {
            LOGGER.warning("SSHD Idle Timeout configuration skipped. " + propertyName + " value (" + propertyValue + ") isn't a long.");
            return new IdleTimeout(null);
        }
    }

    public void apply(SshServer sshd) {
        if (this.timeoutInMilliseconds == null) {
            return;
        }
        sshd.getProperties().put("idle-timeout", this.timeoutInMilliseconds);
        long readTimeout = 0L;
        if (this.timeoutInMilliseconds != 0L) {
            readTimeout = ServerFactoryManager.DEFAULT_NIO2_READ_TIMEOUT - ServerFactoryManager.DEFAULT_IDLE_TIMEOUT + this.timeoutInMilliseconds;
        }
        sshd.getProperties().put("nio2-read-timeout", readTimeout);
    }
}

