/*
 * Decompiled with CFR 0.152.
 */
package hudson.remoting;

import edu.umd.cs.findbugs.annotations.CheckForNull;
import edu.umd.cs.findbugs.annotations.NonNull;
import edu.umd.cs.findbugs.annotations.Nullable;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import hudson.remoting.Asynchronous;
import hudson.remoting.AtmostOneThreadExecutor;
import hudson.remoting.Channel;
import hudson.remoting.ChannelClosedException;
import hudson.remoting.DaemonThreadFactory;
import hudson.remoting.DelegatingCallable;
import hudson.remoting.IReadResolve;
import hudson.remoting.InternalCallable;
import hudson.remoting.NamingThreadFactory;
import hudson.remoting.RemotingSystemException;
import hudson.remoting.Request;
import hudson.remoting.UnexportCommand;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.lang.ref.PhantomReference;
import java.lang.ref.Reference;
import java.lang.ref.ReferenceQueue;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Proxy;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.RejectedExecutionException;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.logging.Level;
import java.util.logging.Logger;

@SuppressFBWarnings(value={"DESERIALIZATION_GADGET"}, justification="This class has protection logic.")
final class RemoteInvocationHandler
implements InvocationHandler,
Serializable {
    private static final Logger logger = Logger.getLogger(RemoteInvocationHandler.class.getName());
    private static final Unexporter UNEXPORTER = new Unexporter();
    private final int oid;
    @CheckForNull
    private transient Channel.Ref channel;
    private final boolean userProxy;
    private final boolean autoUnexportByCaller;
    private boolean goingHome;
    @CheckForNull
    private final Throwable origin;
    private final boolean userSpace;
    private final boolean recordCreatedAt;
    private static final long serialVersionUID = 1L;
    private static final Object[] EMPTY_ARRAY = new Object[0];

    private RemoteInvocationHandler(Channel channel, int id, boolean userProxy, boolean autoUnexportByCaller, boolean userSpace, Class<?> proxyType, boolean recordCreatedAt) {
        this.channel = channel == null ? null : channel.ref();
        this.oid = id;
        this.userProxy = userProxy;
        this.origin = recordCreatedAt ? new Exception("Proxy " + this + " was created for " + proxyType) : null;
        this.autoUnexportByCaller = autoUnexportByCaller;
        this.userSpace = userSpace;
        this.recordCreatedAt = recordCreatedAt;
    }

    @NonNull
    static <T> T wrap(Channel channel, int id, Class<T> type, boolean userProxy, boolean autoUnexportByCaller, boolean userSpace, boolean recordCreatedAt) {
        ClassLoader cl = type.getClassLoader();
        if (cl == null || cl == ClassLoader.getSystemClassLoader()) {
            cl = IReadResolve.class.getClassLoader();
        }
        RemoteInvocationHandler handler = new RemoteInvocationHandler(channel, id, userProxy, autoUnexportByCaller, userSpace, type, recordCreatedAt);
        if (channel != null && !autoUnexportByCaller) {
            UNEXPORTER.watch(handler);
        }
        return type.cast(Proxy.newProxyInstance(cl, new Class[]{type, IReadResolve.class}, (InvocationHandler)handler));
    }

    static void notifyChannelTermination(Channel channel) {
        UNEXPORTER.onChannelTermination(channel);
    }

    static Class<?> getProxyClass(Class<?> type) {
        return Proxy.getProxyClass(type.getClassLoader(), type, IReadResolve.class);
    }

    @CheckForNull
    private Channel channel() {
        Channel.Ref ch = this.channel;
        return ch == null ? null : ch.channel();
    }

    @NonNull
    private Channel channelOrFail() throws IOException {
        Channel.Ref ch = this.channel;
        if (ch == null) {
            throw new IOException("Not connected to any channel");
        }
        Channel c = ch.channel();
        if (c == null) {
            throw new IOException("Backing channel '" + ch.name() + "' is disconnected.", ch.cause());
        }
        return c;
    }

    public static int unwrap(Object proxy, Channel src) {
        RemoteInvocationHandler rih;
        InvocationHandler h = Proxy.getInvocationHandler(proxy);
        if (h instanceof RemoteInvocationHandler && (rih = (RemoteInvocationHandler)h).channel() == src) {
            return rih.oid;
        }
        return -1;
    }

    @CheckForNull
    public static Channel unwrap(Object proxy) {
        InvocationHandler h = Proxy.getInvocationHandler(proxy);
        if (h instanceof RemoteInvocationHandler) {
            RemoteInvocationHandler rih = (RemoteInvocationHandler)h;
            return rih.channel();
        }
        return null;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    @Nullable
    public Object invoke(Object proxy, Method method, Object[] args) throws Throwable {
        Class<?> dc;
        if (method.getDeclaringClass() == IReadResolve.class) {
            if (!this.goingHome) return proxy;
            return Channel.currentOrFail().getExportedObject(this.oid);
        }
        if (this.channel == null) {
            throw new IllegalStateException("proxy is not connected to a channel");
        }
        if (args == null) {
            args = EMPTY_ARRAY;
        }
        if ((dc = method.getDeclaringClass()) == Object.class) {
            try {
                return method.invoke((Object)this, args);
            }
            catch (InvocationTargetException e) {
                throw e.getTargetException();
            }
        }
        boolean async = method.isAnnotationPresent(Asynchronous.class);
        RPCRequest req = this.userSpace ? new UserRPCRequest(this.oid, method, args, this.userProxy ? dc.getClassLoader() : null, this.recordCreatedAt) : new RPCRequest(this.oid, method, args, this.userProxy ? dc.getClassLoader() : null, this.recordCreatedAt);
        try {
            if (this.userProxy) {
                if (!async) return this.channelOrFail().call(req);
                this.channelOrFail().callAsync(req);
                return null;
            } else {
                if (!async) return req.call(this.channelOrFail());
                req.callAsync(this.channelOrFail());
            }
            return null;
        }
        catch (Throwable e) {
            for (Class<?> exc : method.getExceptionTypes()) {
                if (!exc.isInstance(e)) continue;
                throw e;
            }
            if (!(e instanceof RuntimeException) && !(e instanceof Error)) throw new RemotingSystemException(e);
            throw e;
        }
    }

    private void readObject(ObjectInputStream ois) throws IOException, ClassNotFoundException {
        ois.defaultReadObject();
        if (this.goingHome) {
            this.channel = null;
        } else {
            Channel channel = Channel.current();
            Channel.Ref ref = this.channel = channel == null ? null : channel.ref();
            if (channel != null && !this.autoUnexportByCaller) {
                UNEXPORTER.watch(this);
            }
        }
    }

    private void writeObject(ObjectOutputStream oos) throws IOException {
        this.goingHome = this.channel != null;
        oos.defaultWriteObject();
    }

    public boolean equals(Object o) {
        if (o != null && Proxy.isProxyClass(o.getClass())) {
            o = Proxy.getInvocationHandler(o);
        }
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        RemoteInvocationHandler that = (RemoteInvocationHandler)o;
        return this.oid == that.oid && this.channel == that.channel;
    }

    public int hashCode() {
        return this.oid;
    }

    private static class Unexporter
    implements Runnable {
        private static final long NANOSECONDS_PER_MILLISECOND = TimeUnit.MILLISECONDS.toNanos(1L);
        private static final double NANOSECONDS_PER_SECOND = TimeUnit.SECONDS.toNanos(1L);
        private static final boolean retainOrigin = Boolean.parseBoolean(System.getProperty(Unexporter.class.getName() + ".retainOrigin", "true"));
        private static final long sweepInterval = Unexporter.secSysPropAsNanos(Unexporter.class.getName() + ".sweepInterval", 0.1, 0.2, 5.0);
        private static final long measureInterval = Unexporter.secSysPropAsNanos(Unexporter.class.getName() + ".measureInterval", 5.0, 5.0, 60.0);
        private static final long reportInterval = Unexporter.secSysPropAsNanos(Unexporter.class.getName() + ".reportInterval", 30.0, 60.0, 3600.0);
        private static final int batchSize = Math.max(10, Math.min(10000, Integer.getInteger(Unexporter.class.getName() + ".batchSize", 256)));
        private static final double m1Alpha = 1.0 - Math.exp((double)(-measureInterval) * 1.0 / (double)TimeUnit.MINUTES.toNanos(1L));
        private static final double m5Alpha = 1.0 - Math.exp((double)(-measureInterval) * 1.0 / (double)TimeUnit.MINUTES.toNanos(5L));
        private static final double m15Alpha = 1.0 - Math.exp((double)(-measureInterval) * 1.0 / (double)TimeUnit.MINUTES.toNanos(15L));
        private final ExecutorService svc = new AtmostOneThreadExecutor(new NamingThreadFactory(new DaemonThreadFactory(), RemoteInvocationHandler.class.getSimpleName()));
        private final AtomicBoolean inQueue = new AtomicBoolean(false);
        private final AtomicBoolean isAlive = new AtomicBoolean(false);
        private final ReferenceQueue<? super RemoteInvocationHandler> queue = new ReferenceQueue();
        private final ConcurrentMap<Channel.Ref, List<PhantomReferenceImpl>> referenceLists = new ConcurrentHashMap<Channel.Ref, List<PhantomReferenceImpl>>();
        private double m1Avg = 0.0;
        private double m1Var = 0.0;
        private double m5Avg = 0.0;
        private double m5Var = 0.0;
        private double m15Avg = 0.0;
        private double m15Var = 0.0;
        private double tAvg = 0.0;
        private long tCount = 0L;
        private double tVarTimesCount = 0.0;
        private long countStart = System.nanoTime();
        private long count = 0L;
        private long nextMeasure = this.countStart + measureInterval;
        private long nextReport = this.countStart + reportInterval;

        private Unexporter() {
        }

        private static long secSysPropAsNanos(String name, double min, double def, double max) {
            double seconds;
            String value = System.getProperty(name);
            try {
                seconds = value == null || value.isEmpty() ? def : Double.parseDouble(value);
            }
            catch (NumberFormatException e) {
                logger.log(Level.WARNING, String.format("The system property '%s'='%s' could not be parsed", name, value), e);
                seconds = def;
            }
            return (long)(1.0E9 * Math.max(min, Math.min(max, seconds)));
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            if (!this.isAlive.compareAndSet(false, true)) {
                this.inQueue.set(false);
                return;
            }
            this.inQueue.set(false);
            try {
                long nextSweep = System.nanoTime() + sweepInterval;
                PhantomReferenceImpl[] batch = new PhantomReferenceImpl[batchSize];
                while (!this.referenceLists.isEmpty()) {
                    if (System.nanoTime() - this.nextMeasure > 0L) {
                        this.updateStats();
                    }
                    if (System.nanoTime() - this.nextReport > 0L) {
                        this.reportStats();
                    }
                    try {
                        int batchIndex = 0;
                        while (nextSweep - System.nanoTime() > 0L) {
                            Reference<? super RemoteInvocationHandler> ref;
                            long remaining;
                            while (batchIndex < batch.length && (remaining = (nextSweep - System.nanoTime()) / NANOSECONDS_PER_MILLISECOND) > 0L && (ref = this.queue.remove(remaining)) != null) {
                                if (!(ref instanceof PhantomReferenceImpl)) continue;
                                batch[batchIndex++] = (PhantomReferenceImpl)ref;
                            }
                            for (int index = 0; index < batchIndex; ++index) {
                                ++this.count;
                                Channel.Ref channelRef = batch[index].channel;
                                try {
                                    batch[index].cleanup();
                                    continue;
                                }
                                catch (ChannelClosedException referenceList) {
                                    continue;
                                }
                                catch (Error e) {
                                    logger.log(Level.SEVERE, String.format("Couldn't clean up oid=%d from %s", batch[index].oid, batch[index].origin), e);
                                    throw e;
                                }
                                catch (Throwable e) {
                                    logger.log(Level.WARNING, String.format("Couldn't clean up oid=%d from %s", batch[index].oid, batch[index].origin), e);
                                    continue;
                                }
                                finally {
                                    if (channelRef != null && (referenceList = (List)this.referenceLists.get(channelRef)) != null) {
                                        if (channelRef.channel() == null) {
                                            this.cleanList(referenceList);
                                        } else {
                                            referenceList.remove(batch[index]);
                                        }
                                    }
                                    batch[index] = null;
                                }
                            }
                        }
                    }
                    catch (InterruptedException e) {
                        logger.log(Level.FINE, "Interrupted", e);
                    }
                    if (System.nanoTime() - nextSweep <= 0L) continue;
                    nextSweep = System.nanoTime() + sweepInterval;
                    Iterator iterator = this.referenceLists.entrySet().iterator();
                    while (iterator.hasNext()) {
                        Map.Entry entry = iterator.next();
                        Channel.Ref r = (Channel.Ref)entry.getKey();
                        if (r != null && r.channel() != null) continue;
                        iterator.remove();
                        this.cleanList((List)entry.getValue());
                    }
                }
            }
            finally {
                this.isAlive.set(false);
            }
        }

        private void updateStats() {
            long measureDuration = System.nanoTime() - this.countStart;
            double instantRate = (double)this.count * NANOSECONDS_PER_SECOND / (double)measureDuration;
            this.countStart = System.nanoTime();
            this.nextMeasure = this.countStart + measureInterval;
            this.count = 0L;
            if (this.tCount == 0L) {
                this.m15Avg = this.tAvg = instantRate;
                this.m5Avg = this.tAvg;
                this.m1Avg = this.tAvg;
                this.tCount = 1L;
            } else {
                double diff = instantRate - this.m1Avg;
                double incr = m1Alpha * diff;
                this.m1Avg += incr;
                this.m1Var = (1.0 - m1Alpha) * (this.m1Var + diff * incr);
                diff = instantRate - this.m5Avg;
                incr = m5Alpha * diff;
                this.m5Avg += incr;
                this.m5Var = (1.0 - m5Alpha) * (this.m5Var + diff * incr);
                diff = instantRate - this.m15Avg;
                incr = m15Alpha * diff;
                this.m15Avg += incr;
                this.m15Var = (1.0 - m15Alpha) * (this.m15Var + diff * incr);
                diff = instantRate - this.tAvg;
                this.tAvg = (this.tAvg * (double)this.tCount + instantRate) / (double)(++this.tCount);
                this.tVarTimesCount += diff * (instantRate - this.tAvg);
            }
        }

        private void reportStats() {
            Level targetLevel;
            double tStd;
            this.nextReport = System.nanoTime() + reportInterval;
            double m1Std = this.m1Var <= 0.0 ? 0.0 : Math.sqrt(this.m1Var);
            double m5Std = this.m5Var <= 0.0 ? 0.0 : Math.sqrt(this.m5Var);
            double m15Std = this.m15Var <= 0.0 ? 0.0 : Math.sqrt(this.m15Var);
            double d = tStd = this.tCount <= 0L || this.tVarTimesCount < 0.0 ? 0.0 : Math.sqrt(this.tVarTimesCount / (double)this.tCount);
            Level level = this.m15Avg > 100.0 ? Level.INFO : (targetLevel = this.m15Avg > 50.0 ? Level.FINE : Level.FINER);
            if (logger.isLoggable(targetLevel)) {
                logger.log(targetLevel, () -> String.format("rate(1min) = %.1f\u00b1%.1f/sec; rate(5min) = %.1f\u00b1%.1f/sec; rate(15min) = %.1f\u00b1%.1f/sec; rate(total) = %.1f\u00b1%.1f/sec; N = %d", this.m1Avg, m1Std, this.m5Avg, m5Std, this.m15Avg, m15Std, this.tAvg, tStd, this.tCount));
            }
            if (this.tCount < 10L) {
                return;
            }
            if (m15Std > 1.0 && 100.0 < this.m15Avg - 2.0 * m15Std) {
                if (tStd > 1.0 && 100.0 < this.tAvg - 2.0 * tStd) {
                    logger.log(Level.SEVERE, String.format(retainOrigin ? "The all time average rate is %.1f\u00b1%.1f/sec. The 15 minute average rate is %.1f\u00b1%.1f/sec. At the 95% confidence level both are above 100.0/sec. If this message is repeated often in the logs then PLEASE seriously consider setting system property 'hudson.remoting.RemoteInvocationHandler.Unexporter.retainOrigin' to 'false' to trade debug diagnostics for reduced memory pressure." : "The all time average rate is %.1f\u00b1%.1f/sec. The 15 minute average rate is %.1f\u00b1%.1f/sec. At the 95%% confidence level both are above 100.0/sec. ", this.tAvg, tStd, this.m15Avg, m15Std));
                    return;
                }
                logger.log(Level.WARNING, String.format(retainOrigin ? "The 15 minute average rate is %.1f\u00b1%.1f/sec. At the 95% confidence level this is above 100.0/sec. If this message is repeated often in the logs then very seriously consider setting system property 'hudson.remoting.RemoteInvocationHandler.Unexporter.retainOrigin' to 'false' to trade debug diagnostics for reduced memory pressure." : "The 15 minute average rate is %.1f\u00b1%.1f/sec. At the 95%% confidence level this is above 100.0/sec. ", this.m15Avg, m15Std));
                return;
            }
            if (m5Std > 1.0 && 100.0 < this.m5Avg - 2.0 * m5Std) {
                logger.log(Level.WARNING, String.format(retainOrigin ? "The 5 minute average rate is %.1f\u00b1%.1f/sec. At the 95% confidence level this is above 100.0/sec. If this message is repeated often in the logs then seriously consider setting system property 'hudson.remoting.RemoteInvocationHandler.Unexporter.retainOrigin' to 'false' to trade debug diagnostics for reduced memory pressure." : "The 5 minute average rate is %.1f\u00b1%.1f/sec. At the 95%% confidence level this is above 100.0/sec. ", this.m5Avg, m5Std));
                return;
            }
            if (m1Std > 1.0 && 100.0 < this.m1Avg - 2.0 * m1Std) {
                logger.log(Level.INFO, String.format(retainOrigin ? "The 1 minute average rate is %.1f\u00b1%.1f/sec. At the 95% confidence level this is above 100.0/sec. If this message is repeated often in the logs then consider setting system property 'hudson.remoting.RemoteInvocationHandler.Unexporter.retainOrigin' to 'false' to trade debug diagnostics for reduced memory pressure." : "The 1 minute average rate is %.1f\u00b1%.1f/sec. At the 95%% confidence level this is above 100.0/sec. ", this.m1Avg, m1Std));
            }
        }

        private void cleanList(@CheckForNull List<PhantomReferenceImpl> referenceList) {
            if (referenceList == null) {
                return;
            }
            for (PhantomReferenceImpl phantom : referenceList) {
                if (phantom == null) continue;
                phantom.clear();
            }
            referenceList.clear();
        }

        private void watch(RemoteInvocationHandler handler) {
            List referenceList;
            Channel.Ref ref = handler.channel;
            if (ref == null || ref.channel() == null) {
                return;
            }
            while (null == (referenceList = (List)this.referenceLists.get(ref))) {
                this.referenceLists.putIfAbsent(ref, Collections.synchronizedList(new ArrayList()));
            }
            referenceList.add(new PhantomReferenceImpl(handler, this.queue));
            if (this.isAlive.get()) {
                return;
            }
            if (this.inQueue.compareAndSet(false, true)) {
                try {
                    this.svc.submit(UNEXPORTER);
                }
                catch (RejectedExecutionException rejectedExecutionException) {
                    // empty catch block
                }
            }
        }

        private void onChannelTermination(Channel channel) {
            this.cleanList((List)this.referenceLists.remove(channel.ref()));
        }
    }

    private static class UserRPCRequest
    extends RPCRequest {
        private static final long serialVersionUID = -9185841650347902580L;

        UserRPCRequest(int oid, Method m, Object[] arguments, ClassLoader cl, boolean recordCreatedAt) {
            super(oid, m, arguments, cl, recordCreatedAt);
        }

        @Override
        public void checkIfCanBeExecutedOnChannel(@NonNull Channel channel) throws IOException {
            super.checkIfCanBeExecutedOnChannel(channel);
            if (channel.isClosingOrClosed()) {
                throw new ChannelClosedException(channel, "The request cannot be executed on channel " + channel + ". The channel is closing down or has closed down", channel.getCloseRequestCause());
            }
        }
    }

    static class RPCRequest
    extends Request<Serializable, Throwable>
    implements DelegatingCallable<Serializable, Throwable>,
    InternalCallable<Serializable, Throwable> {
        protected final int oid;
        @CheckForNull
        private final String declaringClassName;
        protected final String methodName;
        private final String[] types;
        private final Object[] arguments;
        @CheckForNull
        @SuppressFBWarnings(value={"SE_TRANSIENT_FIELD_NOT_RESTORED"}, justification="We're fine with the default null on the recipient side")
        private final transient ClassLoader classLoader;
        private static final long serialVersionUID = 1L;

        private RPCRequest(int oid, Method m, Object[] arguments, @CheckForNull ClassLoader cl, boolean recordCreatedAt) {
            super(recordCreatedAt);
            this.oid = oid;
            this.arguments = arguments;
            this.declaringClassName = m.getDeclaringClass().getName();
            this.methodName = m.getName();
            this.classLoader = cl;
            this.types = new String[arguments.length];
            Class<?>[] params = m.getParameterTypes();
            for (int i = 0; i < arguments.length; ++i) {
                this.types[i] = params[i].getName();
            }
        }

        @Override
        public Serializable call() throws Throwable {
            return this.perform(this.getChannelOrFail());
        }

        @Override
        public ClassLoader getClassLoader() {
            if (this.classLoader != null) {
                return this.classLoader;
            }
            return this.getClass().getClassLoader();
        }

        @Override
        protected Serializable perform(@NonNull Channel channel) throws Throwable {
            Object o = channel.getExportedObject(this.oid);
            Object[] clazz = channel.getExportedTypes(this.oid);
            try {
                Object r;
                Method m = this.choose((Class<?>[])clazz);
                if (m == null) {
                    throw new IllegalStateException("Unable to call " + this.methodName + ". No matching method found in " + Arrays.toString(clazz) + " for " + o);
                }
                m.setAccessible(true);
                try {
                    r = m.invoke(o, this.arguments);
                }
                catch (IllegalArgumentException x) {
                    throw new RemotingSystemException("failed to invoke " + m + " on " + o + Arrays.toString(this.arguments), x);
                }
                if (r == null || r instanceof Serializable) {
                    return (Serializable)r;
                }
                throw new RemotingSystemException(new ClassCastException(r.getClass() + " is returned from " + m + " on " + o.getClass() + " but it's not serializable"));
            }
            catch (InvocationTargetException e) {
                throw e.getTargetException();
            }
        }

        private Method choose(Class<?>[] interfaces) {
            for (Class<?> clazz : interfaces) {
                block1: for (Method m : clazz.getMethods()) {
                    Class<?>[] paramTypes;
                    if (!m.getName().equals(this.methodName) || (paramTypes = m.getParameterTypes()).length != this.arguments.length) continue;
                    for (int i = 0; i < this.types.length; ++i) {
                        if (!this.types[i].equals(paramTypes[i].getName())) continue block1;
                    }
                    return m;
                }
            }
            return null;
        }

        Object[] getArguments() {
            return this.arguments;
        }

        @Override
        public String toString() {
            StringBuilder b = new StringBuilder(this.getClass().getSimpleName()).append(':').append(this.declaringClassName).append('.').append(this.methodName).append('[');
            for (int i = 0; i < this.types.length; ++i) {
                if (i > 0) {
                    b.append(',');
                }
                b.append(this.types[i]);
            }
            b.append("](").append(this.oid).append(')');
            return b.toString();
        }
    }

    private static class PhantomReferenceImpl
    extends PhantomReference<RemoteInvocationHandler> {
        private final int oid;
        @CheckForNull
        private Throwable origin;
        private Channel.Ref channel;

        private PhantomReferenceImpl(RemoteInvocationHandler referent, ReferenceQueue<? super RemoteInvocationHandler> referenceQueue) {
            super(referent, referenceQueue);
            this.oid = referent.oid;
            this.origin = Unexporter.retainOrigin ? referent.origin : null;
            this.channel = referent.channel;
        }

        private void cleanup() throws IOException {
            if (this.channel == null) {
                return;
            }
            Channel channel = this.channel.channel();
            if (channel != null && !channel.isClosingOrClosed()) {
                try {
                    channel.send(new UnexportCommand(this.oid, this.origin));
                }
                finally {
                    this.origin = null;
                    this.channel = null;
                }
            }
        }
    }
}

