/*
 * Decompiled with CFR 0.152.
 */
package hudson.remoting;

import hudson.remoting.ExportTable;
import hudson.remoting.Util;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.io.Writer;
import java.util.Date;
import java.util.LinkedList;

class ReferenceCountRecorder {
    private final int cap;
    private int total;
    private LinkedList<Event> events = new LinkedList();

    ReferenceCountRecorder(int cap) {
        this.cap = cap;
    }

    ReferenceCountRecorder() {
        this(1024);
    }

    synchronized void addEvent(Event ev) {
        ++this.total;
        this.events.add(ev);
        while (this.cap < this.events.size()) {
            this.events.remove(0);
        }
    }

    void onAddRef(Throwable callSite) {
        this.addEvent(new AddRefEvent(callSite));
    }

    void onRelease(Throwable callSite) {
        this.addEvent(new ReleaseEvent(callSite));
    }

    synchronized void dump(PrintWriter w) {
        w.printf("  Reference count recording: cap=%d total=%d%n", this.cap, this.total);
        for (Event e : this.events) {
            w.printf("  %s at %s%n", e.getClass().getSimpleName(), new Date(e.site.timestamp));
            StringWriter sw = new StringWriter();
            e.site.printStackTrace(new PrintWriter((Writer)sw, true));
            w.println(Util.indent(sw.toString()));
        }
    }

    static class ReleaseEvent
    extends Event {
        ReleaseEvent(Throwable site) {
            super(site);
        }
    }

    static class AddRefEvent
    extends Event {
        AddRefEvent(Throwable site) {
            super(site);
        }
    }

    static abstract class Event {
        ExportTable.Source site;

        protected Event(Throwable callSite) {
            this.site = new ExportTable.Source(callSite);
        }
    }
}

