/*
 * Decompiled with CFR 0.152.
 */
package org.jenkinsci.remoting.engine;

import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import hudson.remoting.Channel;
import hudson.remoting.SocketChannelStream;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.net.Socket;
import java.nio.charset.Charset;
import java.security.SecureRandom;
import java.util.Random;
import java.util.concurrent.ExecutorService;
import javax.annotation.Nonnull;
import javax.crypto.CipherInputStream;
import javax.crypto.CipherOutputStream;
import org.jenkinsci.remoting.engine.ChannelCiphers;
import org.jenkinsci.remoting.engine.HandshakeCiphers;
import org.jenkinsci.remoting.engine.Jnlp3Util;
import org.jenkinsci.remoting.engine.JnlpProtocol3;
import org.jenkinsci.remoting.engine.JnlpServerHandshake;
import org.jenkinsci.remoting.nio.NioChannelHub;

public abstract class JnlpServer3Handshake
extends JnlpServerHandshake {
    protected String cookie;
    private HandshakeCiphers handshakeCiphers;
    private String nodeName;
    static final String COOKIE_NAME = JnlpProtocol3.class.getName() + ".cookie";
    private static final Random RANDOM = new SecureRandom();

    public JnlpServer3Handshake(NioChannelHub hub, ExecutorService threadPool, Socket socket) throws IOException {
        super(hub, threadPool, socket);
    }

    public String getNodeName() {
        return this.nodeName;
    }

    public Channel connect() throws IOException, InterruptedException {
        try {
            this.out.println("Negotiate");
            this.request.load(new ByteArrayInputStream(this.in.readUTF().getBytes(Charset.forName("UTF-8"))));
            this.nodeName = this.request.getProperty("Node-Name");
            this.handshakeCiphers = HandshakeCiphers.create(this.nodeName, this.getNodeSecret(this.nodeName));
            this.authenticateToSlave();
            if (this.getRequestProperty("Cookie") != null) {
                this.cookie = this.handshakeCiphers.decrypt(this.getRequestProperty("Cookie"));
            }
            this.validateSlave();
        }
        catch (Failure f) {
            this.error(f.getMessage());
            return null;
        }
        this.out.println("Welcome");
        String newCookie = null;
        String encryptedCookie = null;
        for (int loopCount = 0; loopCount < 110; ++loopCount) {
            if (loopCount >= 100) {
                throw new IOException("JENKINS-37140 got really unlucky with the random number generator");
            }
            newCookie = this.generateCookie();
            encryptedCookie = this.handshakeCiphers.encrypt(newCookie);
            if (encryptedCookie.indexOf(10) == -1) break;
        }
        this.out.println(encryptedCookie);
        String aesKeyString = this.handshakeCiphers.decrypt(this.in.readUTF());
        String specKeyString = this.handshakeCiphers.decrypt(this.in.readUTF());
        ChannelCiphers channelCiphers = ChannelCiphers.create(Jnlp3Util.keyFromString(aesKeyString), Jnlp3Util.keyFromString(specKeyString));
        Channel channel = this.createChannelBuilder(this.nodeName).build(new CipherInputStream(SocketChannelStream.in(this.socket), channelCiphers.getDecryptCipher()), new CipherOutputStream(SocketChannelStream.out(this.socket), channelCiphers.getEncryptCipher()));
        channel.setProperty(COOKIE_NAME, newCookie);
        return channel;
    }

    protected abstract String getNodeSecret(String var1) throws Failure;

    private void authenticateToSlave() throws IOException, Failure {
        String challenge = this.handshakeCiphers.decrypt(this.request.getProperty("Challenge"));
        String challengeResponse = Jnlp3Util.createChallengeResponse(challenge);
        String encryptedChallengeResponse = this.handshakeCiphers.encrypt(challengeResponse);
        this.out.println(encryptedChallengeResponse.getBytes(Charset.forName("UTF-8")).length);
        this.out.print(encryptedChallengeResponse);
        this.out.flush();
        String challengeVerificationMessage = this.in.readUTF();
        if (!challengeVerificationMessage.equals("Welcome")) {
            throw new Failure("Slave did not accept our challenge response");
        }
    }

    protected void validateSlave() throws IOException, Failure {
        String masterChallenge = Jnlp3Util.generateChallenge();
        String encryptedMasterChallenge = this.handshakeCiphers.encrypt(masterChallenge);
        this.out.println(encryptedMasterChallenge.getBytes(Charset.forName("UTF-8")).length);
        this.out.print(encryptedMasterChallenge);
        this.out.flush();
        String encryptedMasterChallengeResponse = this.in.readUTF();
        String masterChallengeResponse = this.handshakeCiphers.decrypt(encryptedMasterChallengeResponse);
        if (!Jnlp3Util.validateChallengeResponse(masterChallenge, masterChallengeResponse)) {
            throw new Failure("Incorrect master challenge response from slave");
        }
    }

    private String generateCookie() {
        byte[] cookie = new byte[32];
        RANDOM.nextBytes(cookie);
        return this.toHexString(cookie);
    }

    @Nonnull
    private String toHexString(@Nonnull byte[] bytes) {
        StringBuilder buf = new StringBuilder();
        for (byte bb : bytes) {
            int b = bb & 0xFF;
            if (b < 16) {
                buf.append('0');
            }
            buf.append(Integer.toHexString(b));
        }
        return buf.toString();
    }

    @SuppressFBWarnings(value={"SIC_INNER_SHOULD_BE_STATIC"}, justification="It's an issue, but the class is being used in the core now")
    protected class Failure
    extends Exception {
        public Failure(String msg) {
            super(msg);
        }
    }
}

