/*
 * Decompiled with CFR 0.152.
 */
package org.jenkinsci.remoting.engine;

import java.math.BigInteger;
import java.nio.charset.Charset;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.security.SecureRandom;
import java.util.Arrays;

class Jnlp3Util {
    Jnlp3Util() {
    }

    public static byte[] generate128BitKey() {
        byte[] key = new byte[16];
        new SecureRandom().nextBytes(key);
        return key;
    }

    public static byte[] generate128BitKey(String str) {
        try {
            MessageDigest messageDigest = MessageDigest.getInstance("SHA-256");
            messageDigest.update(str.getBytes(Charset.forName("UTF-8")));
            return Arrays.copyOf(messageDigest.digest(), 16);
        }
        catch (NoSuchAlgorithmException nsae) {
            throw new AssertionError((Object)nsae);
        }
    }

    public static String keyToString(byte[] key) {
        return new String(key, Charset.forName("ISO-8859-1"));
    }

    public static byte[] keyFromString(String keyString) {
        return keyString.getBytes(Charset.forName("ISO-8859-1"));
    }

    public static String generateChallenge() {
        return new BigInteger(10400, new SecureRandom()).toString(32);
    }

    public static String createChallengeResponse(String challenge) {
        try {
            MessageDigest messageDigest = MessageDigest.getInstance("SHA-256");
            messageDigest.update(challenge.getBytes(Charset.forName("UTF-8")));
            return new String(messageDigest.digest(), Charset.forName("UTF-8"));
        }
        catch (NoSuchAlgorithmException nsae) {
            throw new AssertionError((Object)nsae);
        }
    }

    public static boolean validateChallengeResponse(String challenge, String challengeResponse) {
        return challengeResponse.equals(Jnlp3Util.createChallengeResponse(challenge));
    }
}

