/*
 * Decompiled with CFR 0.152.
 */
package hudson.remoting;

import hudson.remoting.Base64;
import hudson.remoting.Channel;
import hudson.remoting.ChannelBuilder;
import hudson.remoting.EngineListener;
import hudson.remoting.EngineListenerSplitter;
import hudson.remoting.FileSystemJarCache;
import hudson.remoting.JarCache;
import hudson.remoting.Util;
import java.io.BufferedInputStream;
import java.io.File;
import java.io.IOException;
import java.net.HttpURLConnection;
import java.net.MalformedURLException;
import java.net.Socket;
import java.net.URL;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.ThreadFactory;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.jenkinsci.remoting.engine.EngineUtil;
import org.jenkinsci.remoting.engine.JnlpProtocol;
import org.jenkinsci.remoting.engine.JnlpProtocolFactory;

public class Engine
extends Thread {
    private final ExecutorService executor = Executors.newCachedThreadPool(new ThreadFactory(){
        private final ThreadFactory defaultFactory = Executors.defaultThreadFactory();

        @Override
        public Thread newThread(final Runnable r) {
            Thread t = this.defaultFactory.newThread(new Runnable(){

                @Override
                public void run() {
                    CURRENT.set(Engine.this);
                    r.run();
                }
            });
            t.setDaemon(true);
            return t;
        }
    });
    @Deprecated
    public final EngineListener listener;
    private final EngineListenerSplitter events = new EngineListenerSplitter();
    private List<URL> candidateUrls;
    private URL hudsonUrl;
    private final String secretKey;
    public final String slaveName;
    private String credentials;
    private String proxyCredentials = System.getProperty("proxyCredentials");
    private String tunnel;
    private boolean noReconnect;
    private JarCache jarCache = new FileSystemJarCache(new File(System.getProperty("user.home"), ".jenkins/cache/jars"), true);
    private static final ThreadLocal<Engine> CURRENT = new ThreadLocal();
    private static final Logger LOGGER = Logger.getLogger(Engine.class.getName());
    @Deprecated
    public static final String GREETING_SUCCESS = "Welcome";

    public Engine(EngineListener listener, List<URL> hudsonUrls, String secretKey, String slaveName) {
        this.listener = listener;
        this.events.add(listener);
        this.candidateUrls = hudsonUrls;
        this.secretKey = secretKey;
        this.slaveName = slaveName;
        if (this.candidateUrls.isEmpty()) {
            throw new IllegalArgumentException("No URLs given");
        }
    }

    public void setJarCache(JarCache jarCache) {
        this.jarCache = jarCache;
    }

    public URL getHudsonUrl() {
        return this.hudsonUrl;
    }

    public void setTunnel(String tunnel) {
        this.tunnel = tunnel;
    }

    public void setCredentials(String creds) {
        this.credentials = creds;
    }

    public void setProxyCredentials(String proxyCredentials) {
        this.proxyCredentials = proxyCredentials;
    }

    public void setNoReconnect(boolean noReconnect) {
        this.noReconnect = noReconnect;
    }

    public void addListener(EngineListener el) {
        this.events.add(el);
    }

    public void removeListener(EngineListener el) {
        this.events.remove(el);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        List<JnlpProtocol> protocols = JnlpProtocolFactory.createProtocols(this.secretKey, this.slaveName, this.events);
        try {
            boolean first = true;
            while (true) {
                if (first) {
                    first = false;
                } else if (this.noReconnect) {
                    return;
                }
                this.events.status("Locating server among " + this.candidateUrls);
                Throwable firstError = null;
                String host = null;
                String port = null;
                for (URL url : this.candidateUrls) {
                    block27: {
                        String encoding;
                        String s = url.toExternalForm();
                        if (!s.endsWith("/")) {
                            s = s + '/';
                        }
                        URL salURL = new URL(s + "tcpSlaveAgentListener/");
                        HttpURLConnection con = (HttpURLConnection)Util.openURLConnection(salURL);
                        if (this.credentials != null) {
                            encoding = Base64.encode(this.credentials.getBytes("UTF-8"));
                            con.setRequestProperty("Authorization", "Basic " + encoding);
                        }
                        if (this.proxyCredentials != null) {
                            encoding = Base64.encode(this.proxyCredentials.getBytes("UTF-8"));
                            con.setRequestProperty("Proxy-Authorization", "Basic " + encoding);
                        }
                        try {
                            con.setConnectTimeout(30000);
                            con.setReadTimeout(60000);
                            con.connect();
                        }
                        catch (IOException x) {
                            if (firstError == null) {
                                firstError = new IOException("Failed to connect to " + salURL + ": " + x.getMessage()).initCause(x);
                            }
                            con.disconnect();
                            continue;
                        }
                        try {
                            port = con.getHeaderField("X-Hudson-JNLP-Port");
                            if (con.getResponseCode() != 200) {
                                if (firstError != null) continue;
                                firstError = new Exception(salURL + " is invalid: " + con.getResponseCode() + " " + con.getResponseMessage());
                                continue;
                            }
                            if (port == null) {
                                if (firstError != null) continue;
                                firstError = new Exception(url + " is not Jenkins");
                                continue;
                            }
                            host = con.getHeaderField("X-Jenkins-JNLP-Host");
                            if (host != null) break block27;
                            host = url.getHost();
                        }
                        finally {
                            con.disconnect();
                            continue;
                        }
                    }
                    this.hudsonUrl = url;
                    firstError = null;
                    this.candidateUrls = Collections.singletonList(this.hudsonUrl);
                    break;
                }
                if (firstError != null) {
                    this.events.error(firstError);
                    return;
                }
                this.events.status("Handshaking");
                Socket jnlpSocket = this.connect(host, port);
                ChannelBuilder channelBuilder = new ChannelBuilder("channel", this.executor).withJarCache(this.jarCache).withMode(Channel.Mode.BINARY);
                Channel channel = null;
                for (JnlpProtocol protocol : protocols) {
                    this.events.status("Trying protocol: " + protocol.getName());
                    try {
                        channel = protocol.establishChannel(jnlpSocket, channelBuilder);
                    }
                    catch (IOException ioe) {
                        this.events.status("Protocol failed to establish channel", ioe);
                    }
                    if (channel != null) break;
                    jnlpSocket.close();
                    jnlpSocket = this.connect(host, port);
                }
                if (channel == null) {
                    this.onConnectionRejected("None of the protocols were accepted");
                    continue;
                }
                this.events.status("Connected");
                channel.join();
                this.events.status("Terminated");
                if (this.noReconnect) {
                    return;
                }
                this.events.onDisconnect();
                this.waitForServerToBack();
                this.events.onReconnect();
            }
        }
        catch (Throwable e) {
            this.events.error(e);
            return;
        }
    }

    private void onConnectionRejected(String greeting) throws InterruptedException {
        this.events.error(new Exception("The server rejected the connection: " + greeting));
        Thread.sleep(10000L);
    }

    private Socket connect(String host, String port) throws IOException, InterruptedException {
        if (this.tunnel != null) {
            String[] tokens = this.tunnel.split(":", 3);
            if (tokens.length != 2) {
                throw new IOException("Illegal tunneling parameter: " + this.tunnel);
            }
            if (tokens[0].length() > 0) {
                host = tokens[0];
            }
            if (tokens[1].length() > 0) {
                port = tokens[1];
            }
        }
        String msg = "Connecting to " + host + ':' + port;
        this.events.status(msg);
        int retry = 1;
        while (true) {
            try {
                Socket s;
                boolean isProxy = false;
                if (System.getProperty("http.proxyHost") != null) {
                    String proxyHost = System.getProperty("http.proxyHost");
                    String proxyPort = System.getProperty("http.proxyPort", "80");
                    s = new Socket(proxyHost, Integer.parseInt(proxyPort));
                    isProxy = true;
                } else {
                    String httpProxy = System.getenv("http_proxy");
                    if (httpProxy != null) {
                        try {
                            URL url = new URL(httpProxy);
                            s = new Socket(url.getHost(), url.getPort());
                            isProxy = true;
                        }
                        catch (MalformedURLException e) {
                            System.err.println("Not use http_proxy environment variable which is invalid: " + e.getMessage());
                            s = new Socket(host, Integer.parseInt(port));
                        }
                    } else {
                        s = new Socket(host, Integer.parseInt(port));
                    }
                }
                s.setTcpNoDelay(true);
                s.setSoTimeout(1800000);
                if (isProxy) {
                    String connectCommand = String.format("CONNECT %s:%s HTTP/1.1\r\nHost: %s\r\n\r\n", host, port, host);
                    s.getOutputStream().write(connectCommand.getBytes("UTF-8"));
                    BufferedInputStream is = new BufferedInputStream(s.getInputStream());
                    String line = EngineUtil.readLine(is);
                    String[] responseLineParts = line.split(" ");
                    if (responseLineParts.length < 2 || !responseLineParts[1].equals("200")) {
                        throw new IOException("Got a bad response from proxy: " + line);
                    }
                    while (!EngineUtil.readLine(is).isEmpty()) {
                    }
                }
                return s;
            }
            catch (IOException e) {
                if (retry++ > 10) {
                    throw (IOException)new IOException("Failed to connect to " + host + ':' + port).initCause(e);
                }
                Thread.sleep(10000L);
                this.events.status(msg + " (retrying:" + retry + ")", e);
                continue;
            }
            break;
        }
    }

    private void waitForServerToBack() throws InterruptedException {
        Thread t = Thread.currentThread();
        String oldName = t.getName();
        try {
            int retries = 0;
            while (true) {
                HttpURLConnection con;
                block8: {
                    Thread.sleep(10000L);
                    URL url = new URL(this.hudsonUrl, "tcpSlaveAgentListener/");
                    t.setName(oldName + ": trying " + url + " for " + ++retries + " times");
                    con = (HttpURLConnection)url.openConnection();
                    con.setConnectTimeout(5000);
                    con.setReadTimeout(5000);
                    con.connect();
                    if (con.getResponseCode() != 200) break block8;
                    return;
                }
                try {
                    LOGGER.info("Master isn't ready to talk to us. Will retry again: response code=" + con.getResponseCode());
                }
                catch (IOException e) {
                    LOGGER.log(Level.INFO, "Failed to connect to the master. Will retry again", e);
                }
            }
        }
        finally {
            t.setName(oldName);
        }
    }

    public static Engine current() {
        return CURRENT.get();
    }
}

