/*
 * Decompiled with CFR 0.152.
 */
package hudson.maven;

import hudson.AbortException;
import hudson.Util;
import hudson.maven.MavenEmbedderException;
import hudson.maven.MavenEmbedderUtils;
import hudson.maven.MavenInformation;
import hudson.maven.Messages;
import java.io.File;
import java.io.IOException;
import jenkins.security.MasterToSlaveCallable;

public class MavenVersionCallable
extends MasterToSlaveCallable<MavenInformation, IOException> {
    private static final long serialVersionUID = -2644951622080930034L;
    private final String mavenHome;

    public MavenVersionCallable(String mavenHome) throws IOException {
        if (Util.fixEmptyAndTrim((String)mavenHome) == null) {
            throw new AbortException(Messages.MavenVersionCallable_MavenHomeDoesntExist(mavenHome));
        }
        this.mavenHome = mavenHome;
    }

    public MavenInformation call() throws IOException {
        try {
            File home = new File(this.mavenHome);
            if (!home.isDirectory()) {
                if (home.exists()) {
                    throw new AbortException(Messages.MavenVersionCallable_MavenHomeIsNotDirectory(home));
                }
                throw new AbortException(Messages.MavenVersionCallable_MavenHomeDoesntExist(home));
            }
            return MavenEmbedderUtils.getMavenVersion((File)home);
        }
        catch (MavenEmbedderException e) {
            throw new IOException(e);
        }
    }
}

