/*
 * Decompiled with CFR 0.152.
 */
package hudson.maven;

import com.google.common.collect.Maps;
import hudson.AbortException;
import hudson.EnvVars;
import hudson.maven.AbstractMavenBuild;
import hudson.maven.Messages;
import hudson.model.AbstractProject;
import hudson.model.Action;
import hudson.remoting.Channel;
import hudson.remoting.VirtualChannel;
import hudson.security.ACL;
import hudson.util.RemotingDiagnostics;
import java.io.IOException;
import java.util.Map;
import java.util.Set;
import java.util.SortedMap;
import java.util.TreeMap;
import javax.servlet.RequestDispatcher;
import javax.servlet.ServletException;
import jenkins.model.Jenkins;
import org.kohsuke.stapler.StaplerRequest;
import org.kohsuke.stapler.StaplerResponse;

public final class MavenProbeAction
implements Action {
    private final transient Channel channel;
    private final transient AbstractMavenBuild<?, ?> build;
    public final transient AbstractProject<?, ?> owner;

    MavenProbeAction(AbstractProject<?, ?> owner, Channel channel, AbstractMavenBuild<?, ?> build) {
        this.channel = channel;
        this.build = build;
        this.owner = owner;
    }

    public String getIconFileName() {
        if (this.channel == null) {
            return null;
        }
        return "computer.png";
    }

    public String getDisplayName() {
        return Messages.MavenProbeAction_DisplayName();
    }

    public String getUrlName() {
        if (this.channel == null) {
            return null;
        }
        return "probe";
    }

    public Map<Object, Object> getSystemProperties() throws IOException, InterruptedException {
        TreeMap props = RemotingDiagnostics.getSystemProperties((VirtualChannel)this.channel);
        if (this.build != null) {
            final Set sensitiveBuildVars = this.build.getSensitiveBuildVariables();
            props = new TreeMap(Maps.transformEntries((Map)props, (Maps.EntryTransformer)new Maps.EntryTransformer<Object, Object, Object>(){

                public Object transformEntry(Object key, Object value) {
                    return sensitiveBuildVars.contains(key.toString()) ? "********" : value;
                }
            }));
        }
        return props;
    }

    public Map<String, String> getEnvVars() throws IOException, InterruptedException {
        EnvVars vars = EnvVars.getRemote((VirtualChannel)this.channel);
        if (this.build != null) {
            final Set sensitiveBuildVars = this.build.getSensitiveBuildVariables();
            vars = new EnvVars((Map)Maps.transformEntries((SortedMap)vars, (Maps.EntryTransformer)new Maps.EntryTransformer<String, String, String>(){

                public String transformEntry(String key, String value) {
                    return sensitiveBuildVars.contains(key) ? "********" : value;
                }
            }));
        }
        return vars;
    }

    public Map<String, String> getThreadDump() throws IOException, InterruptedException {
        return RemotingDiagnostics.getThreadDump((VirtualChannel)this.channel);
    }

    public void doScript(StaplerRequest req, StaplerResponse rsp) throws IOException, ServletException {
        if (this.owner == null) {
            throw new AbortException("Completed build");
        }
        Jenkins._doScript((StaplerRequest)req, (StaplerResponse)rsp, (RequestDispatcher)req.getView((Object)this, "_script.jelly"), (VirtualChannel)this.channel, (ACL)this.owner.getACL());
    }

    public RemotingDiagnostics.HeapDump getHeapDump() throws IOException {
        if (this.owner == null) {
            throw new AbortException("Completed build");
        }
        return new RemotingDiagnostics.HeapDump(this.owner, (VirtualChannel)this.channel);
    }
}

