/*
 * Decompiled with CFR 0.152.
 */
package hudson.maven;

import hudson.EnvVars;
import hudson.FilePath;
import hudson.Launcher;
import hudson.maven.AbstractMavenBuild;
import hudson.maven.AbstractMavenProcessFactory;
import hudson.maven.MavenModuleSet;
import hudson.maven.MavenProcessFactory;
import hudson.maven.Messages;
import hudson.maven.PlexusModuleContributor;
import hudson.maven.PlexusModuleContributorFactory;
import hudson.maven.ProcessCache;
import hudson.model.BuildListener;
import hudson.model.Run;
import hudson.model.TaskListener;
import hudson.remoting.Callable;
import hudson.remoting.Channel;
import hudson.tasks.Maven;
import java.io.File;
import java.io.FilenameFilter;
import java.io.IOException;
import java.net.URL;
import jenkins.security.MasterToSlaveCallable;
import org.jvnet.hudson.maven3.agent.Maven3Main;
import org.jvnet.hudson.maven3.launcher.Maven3Launcher;
import org.jvnet.hudson.maven3.listeners.HudsonMavenExecutionResult;

public class Maven3ProcessFactory
extends AbstractMavenProcessFactory
implements ProcessCache.Factory {
    private static final FilenameFilter CLASSWORLDS_FILTER = new FilenameFilter(){

        @Override
        public boolean accept(File dir, String name) {
            return name.contains("plexus-classworlds") && name.endsWith(".jar");
        }
    };

    Maven3ProcessFactory(MavenModuleSet mms, AbstractMavenBuild<?, ?> build, Launcher launcher, EnvVars envVars, String mavenOpts, FilePath workDir) {
        super(mms, build, launcher, envVars, mavenOpts, workDir);
    }

    @Override
    protected String getMavenAgentClassPath(Maven.MavenInstallation mvn, FilePath slaveRoot, BuildListener listener) throws IOException, InterruptedException {
        String classWorldsJar = (String)this.getLauncher().getChannel().call((Callable)new GetClassWorldsJar(mvn.getHome(), (TaskListener)listener));
        return this.classPathEntry(slaveRoot, Maven3Main.class, "maven3-agent", (TaskListener)listener) + (this.getLauncher().isUnix() ? ":" : ";") + classWorldsJar;
    }

    @Override
    protected String getMainClassName() {
        return Maven3Main.class.getName();
    }

    @Override
    protected String getMavenInterceptorClassPath(Maven.MavenInstallation mvn, FilePath slaveRoot, BuildListener listener) throws IOException, InterruptedException {
        return this.classPathEntry(slaveRoot, Maven3Launcher.class, "maven3-interceptor", (TaskListener)listener);
    }

    @Override
    protected String getMavenInterceptorCommonClassPath(Maven.MavenInstallation mvn, FilePath slaveRoot, BuildListener listener) throws IOException, InterruptedException {
        return this.classPathEntry(slaveRoot, HudsonMavenExecutionResult.class, "maven3-interceptor-commons", (TaskListener)listener);
    }

    @Override
    protected String getMavenInterceptorOverride(Maven.MavenInstallation mvn, FilePath slaveRoot, BuildListener listener) throws IOException, InterruptedException {
        return null;
    }

    @Override
    protected void applyPlexusModuleContributor(Channel channel, AbstractMavenBuild<?, ?> context) throws InterruptedException, IOException {
        channel.call((Callable)new InstallPlexusModulesTask(context));
    }

    protected static final class GetClassWorldsJar
    extends MasterToSlaveCallable<String, IOException> {
        private static final long serialVersionUID = -2599434124883557137L;
        private final String mvnHome;
        private final TaskListener listener;

        protected GetClassWorldsJar(String mvnHome, TaskListener listener) {
            this.mvnHome = mvnHome;
            this.listener = listener;
        }

        public String call() throws IOException {
            File bootDir;
            File[] classworlds;
            File home = new File(this.mvnHome);
            if (MavenProcessFactory.debug) {
                this.listener.getLogger().println("Using mvnHome: " + this.mvnHome);
            }
            if ((classworlds = (bootDir = new File(home, "boot")).listFiles(CLASSWORLDS_FILTER)) == null || classworlds.length == 0) {
                this.listener.error(Messages.MavenProcessFactory_ClassWorldsNotFound(home));
                throw new Run.RunnerAbortedException();
            }
            return classworlds[0].getAbsolutePath();
        }
    }

    private static final class InstallPlexusModulesTask
    extends MasterToSlaveCallable<Void, IOException> {
        PlexusModuleContributor c;
        private static final long serialVersionUID = 1L;

        public InstallPlexusModulesTask(AbstractMavenBuild<?, ?> context) throws IOException, InterruptedException {
            this.c = PlexusModuleContributorFactory.aggregate(context);
        }

        public Void call() throws IOException {
            Maven3Main.addPlexusComponents((URL[])this.c.getPlexusComponentJars().toArray(new URL[0]));
            return null;
        }
    }
}

