/*
 * Decompiled with CFR 0.152.
 */
package org.jvnet.hudson.test.recipes;

import java.lang.annotation.Documented;
import java.lang.annotation.ElementType;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.lang.annotation.Target;
import java.lang.reflect.Method;
import java.util.logging.Logger;
import org.junit.runner.Description;
import org.jvnet.hudson.test.HudsonHomeLoader;
import org.jvnet.hudson.test.HudsonTestCase;
import org.jvnet.hudson.test.JenkinsRecipe;
import org.jvnet.hudson.test.JenkinsRule;
import org.jvnet.hudson.test.recipes.Recipe;

@Documented
@Recipe(value=RunnerImpl.class)
@JenkinsRecipe(value=RuleRunnerImpl.class)
@Target(value={ElementType.METHOD})
@Retention(value=RetentionPolicy.RUNTIME)
public @interface LocalData {
    public static final Logger LOGGER = Logger.getLogger(LocalData.class.getName());

    public String value() default "";

    public static class RuleRunnerImpl
    extends JenkinsRecipe.Runner<LocalData> {
        @Override
        public void setup(JenkinsRule jenkinsRule, LocalData recipe) throws Exception {
            Description desc = jenkinsRule.getTestDescription();
            Method testMethod = null;
            for (Class cls = desc.getTestClass(); testMethod == null && cls != null; cls = cls.getSuperclass()) {
                try {
                    testMethod = cls.getDeclaredMethod(desc.getMethodName(), new Class[0]);
                    continue;
                }
                catch (NoSuchMethodException ex) {
                    try {
                        testMethod = cls.getDeclaredMethod(desc.getMethodName(), JenkinsRule.class);
                        continue;
                    }
                    catch (NoSuchMethodException ex2) {
                        LOGGER.fine("No method " + desc.getMethodName() + " in " + String.valueOf(cls));
                    }
                }
            }
            if (testMethod == null) {
                throw new NoSuchMethodException("Could not look up any test method for " + String.valueOf(desc));
            }
            jenkinsRule.with(new HudsonHomeLoader.Local(testMethod, recipe.value()));
        }
    }

    public static class RunnerImpl
    extends Recipe.Runner<LocalData> {
        @Override
        public void setup(HudsonTestCase testCase, LocalData recipe) throws Exception {
            testCase.with(new HudsonHomeLoader.Local(((Object)((Object)testCase)).getClass().getMethod(testCase.getName(), new Class[0]), recipe.value()));
        }
    }
}

