/*
 * Decompiled with CFR 0.152.
 */
package org.jvnet.hudson.test.junit.jupiter;

import edu.umd.cs.findbugs.annotations.CheckForNull;
import edu.umd.cs.findbugs.annotations.NonNull;
import edu.umd.cs.findbugs.annotations.Nullable;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import hudson.model.UnprotectedRootAction;
import hudson.security.ACL;
import hudson.security.ACLContext;
import hudson.security.csrf.CrumbExclusion;
import hudson.util.NamingThreadFactory;
import hudson.util.StreamCopyThread;
import io.jenkins.test.fips.FIPSTestBundleProvider;
import java.io.BufferedReader;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.ObjectStreamClass;
import java.io.OutputStream;
import java.io.Serializable;
import java.lang.annotation.Annotation;
import java.lang.invoke.CallSite;
import java.lang.management.ManagementFactory;
import java.lang.management.RuntimeMXBean;
import java.lang.reflect.Method;
import java.net.HttpURLConnection;
import java.net.InetAddress;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.net.URLClassLoader;
import java.net.URLConnection;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.nio.file.CopyOption;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.attribute.FileAttribute;
import java.security.KeyManagementException;
import java.security.KeyStore;
import java.security.KeyStoreException;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.security.cert.CertificateException;
import java.security.cert.CertificateFactory;
import java.security.cert.X509Certificate;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.TreeMap;
import java.util.TreeSet;
import java.util.UUID;
import java.util.concurrent.CancellationException;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicReference;
import java.util.jar.Attributes;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;
import java.util.jar.JarInputStream;
import java.util.jar.JarOutputStream;
import java.util.jar.Manifest;
import java.util.logging.ConsoleHandler;
import java.util.logging.Handler;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import java.util.zip.ZipEntry;
import java.util.zip.ZipOutputStream;
import javax.net.ssl.HttpsURLConnection;
import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLSocketFactory;
import javax.net.ssl.TrustManagerFactory;
import javax.servlet.FilterChain;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import jenkins.model.Jenkins;
import jenkins.model.JenkinsLocationConfiguration;
import jenkins.test.https.KeyStoreManager;
import jenkins.util.Timer;
import org.apache.commons.io.FileUtils;
import org.apache.commons.io.IOUtils;
import org.htmlunit.WebClient;
import org.junit.jupiter.api.extension.AfterEachCallback;
import org.junit.jupiter.api.extension.BeforeEachCallback;
import org.junit.jupiter.api.extension.ExtensionContext;
import org.junit.rules.DisableOnDebug;
import org.junit.rules.ErrorCollector;
import org.junit.runner.Description;
import org.jvnet.hudson.test.HudsonHomeLoader;
import org.jvnet.hudson.test.JenkinsRule;
import org.jvnet.hudson.test.PluginUtils;
import org.jvnet.hudson.test.PrefixedOutputStream;
import org.jvnet.hudson.test.TemporaryDirectoryAllocator;
import org.jvnet.hudson.test.TestEnvironment;
import org.jvnet.hudson.test.WarExploder;
import org.jvnet.hudson.test.recipes.LocalData;
import org.kohsuke.stapler.HttpResponse;
import org.kohsuke.stapler.HttpResponses;
import org.kohsuke.stapler.QueryParameter;
import org.kohsuke.stapler.StaplerRequest2;
import org.kohsuke.stapler.StaplerResponse2;
import org.kohsuke.stapler.verb.POST;
import org.opentest4j.TestAbortedException;
import org.springframework.security.core.Authentication;

@SuppressFBWarnings(value={"URLCONNECTION_SSRF_FD"}, justification="irrelevant")
public class RealJenkinsExtension
implements BeforeEachCallback,
AfterEachCallback {
    private static final Logger LOGGER = Logger.getLogger(RealJenkinsExtension.class.getName());
    private static final String REAL_JENKINS_EXTENSION_LOGGING = "RealJenkinsExtension.logging.";
    private Description description;
    private ExtensionContext extensionContext;
    private final TemporaryDirectoryAllocator tmp = new TemporaryDirectoryAllocator();
    private AtomicReference<File> home;
    private int port;
    private String httpListenAddress = InetAddress.getLoopbackAddress().getHostAddress();
    private File war;
    private String javaHome;
    private boolean includeTestClasspathPlugins = true;
    private final String token = UUID.randomUUID().toString();
    private final Set<String> extraPlugins = new TreeSet<String>();
    private final List<SyntheticPlugin> syntheticPlugins = new ArrayList<SyntheticPlugin>();
    private final Set<String> skippedPlugins = new TreeSet<String>();
    private final List<String> javaOptions = new ArrayList<String>();
    private final List<String> jenkinsOptions = new ArrayList<String>();
    private final Map<String, String> extraEnv = new TreeMap<String, String>();
    private int timeout = Integer.getInteger("jenkins.test.timeout", new DisableOnDebug(null).isDebugging() ? 0 : 600);
    private String host = "localhost";
    Process proc;
    private Path portFile;
    private Map<String, Level> loggers = new HashMap<String, Level>();
    private int debugPort = 0;
    private boolean debugServer = true;
    private boolean debugSuspend;
    private boolean prepareHomeLazily;
    private boolean provisioned;
    private final List<File> bootClasspathFiles = new ArrayList<File>();
    private static final Pattern SNAPSHOT_INDEX_JELLY = Pattern.compile("(file:/.+/target)/classes/index.jelly");
    private final PrefixedOutputStream.Builder prefixedOutputStreamBuilder = PrefixedOutputStream.builder();
    private boolean https;
    private KeyStoreManager keyStoreManager;
    private SSLSocketFactory sslSocketFactory;
    private X509Certificate rootCA;
    @NonNull
    private String prefix = "/jenkins";

    public RealJenkinsExtension() {
        this.home = new AtomicReference();
    }

    public RealJenkinsExtension(RealJenkinsExtension source) {
        this.home = source.home;
        this.includeTestClasspathPlugins = source.includeTestClasspathPlugins;
        this.extraPlugins.addAll(source.extraPlugins);
        this.syntheticPlugins.addAll(source.syntheticPlugins);
        this.skippedPlugins.addAll(source.skippedPlugins);
    }

    public RealJenkinsExtension addPlugins(String ... plugins) {
        this.extraPlugins.addAll(List.of(plugins));
        return this;
    }

    public RealJenkinsExtension addSyntheticPlugin(SyntheticPlugin plugin) {
        this.syntheticPlugins.add(plugin);
        return this;
    }

    @SuppressFBWarnings(value={"PATH_TRAVERSAL_IN"}, justification="irrelevant, this is test code")
    public File createSyntheticPlugin(SyntheticPlugin plugin) throws IOException, URISyntaxException {
        File pluginJpi = new File(this.tmp.allocate("synthetic-plugin"), plugin.shortName + ".jpi");
        if (this.war == null) {
            throw new IllegalStateException("createSyntheticPlugin may only be invoked from within a test method");
        }
        try (JarFile jf = new JarFile(this.war);){
            String jenkinsVersion = jf.getManifest().getMainAttributes().getValue("Jenkins-Version");
            plugin.writeTo(pluginJpi, jenkinsVersion);
        }
        return pluginJpi;
    }

    public RealJenkinsExtension omitPlugins(String ... plugins) {
        this.skippedPlugins.addAll(List.of(plugins));
        return this;
    }

    public RealJenkinsExtension javaOptions(String ... options) {
        this.javaOptions.addAll(List.of(options));
        return this;
    }

    public RealJenkinsExtension jenkinsOptions(String ... options) {
        this.jenkinsOptions.addAll(List.of(options));
        return this;
    }

    public RealJenkinsExtension extraEnv(String key, String value) {
        this.extraEnv.put(key, value);
        return this;
    }

    public RealJenkinsExtension withTimeout(int timeout) {
        this.timeout = timeout;
        return this;
    }

    public RealJenkinsExtension withHost(String host) {
        if (this.https) {
            throw new IllegalStateException("Don't call this method when using HTTPS");
        }
        this.host = host;
        return this;
    }

    public RealJenkinsExtension withPrefix(@NonNull String prefix) {
        if (!prefix.isEmpty()) {
            if (!prefix.startsWith("/")) {
                throw new IllegalArgumentException("Prefix must start with a leading slash.");
            }
            if (prefix.endsWith("/")) {
                throw new IllegalArgumentException("Prefix must not end with a trailing slash.");
            }
        }
        this.prefix = prefix;
        return this;
    }

    public RealJenkinsExtension withWar(File war) {
        this.war = war;
        return this;
    }

    public RealJenkinsExtension withJavaHome(String JavaHome) {
        this.javaHome = JavaHome;
        return this;
    }

    public RealJenkinsExtension withLogger(Class<?> clazz, Level level) {
        return this.withLogger(clazz.getName(), level);
    }

    public RealJenkinsExtension withPackageLogger(Class<?> clazz, Level level) {
        return this.withLogger(clazz.getPackageName(), level);
    }

    public RealJenkinsExtension withLogger(String logger, Level level) {
        this.loggers.put(logger, level);
        return this;
    }

    public RealJenkinsExtension withName(String name) {
        this.prefixedOutputStreamBuilder.withName(name);
        return this;
    }

    public String getName() {
        return this.prefixedOutputStreamBuilder.getName();
    }

    public RealJenkinsExtension withColor(PrefixedOutputStream.AnsiColor color) {
        this.prefixedOutputStreamBuilder.withColor(color);
        return this;
    }

    public RealJenkinsExtension withPort(int port) {
        this.port = port;
        return this;
    }

    public RealJenkinsExtension withHttpListenAddress(String httpListenAddress) {
        this.httpListenAddress = httpListenAddress;
        return this;
    }

    public RealJenkinsExtension withDebugPort(int debugPort) {
        if (debugPort < 0) {
            throw new IllegalArgumentException("debugPort must be positive");
        }
        if (debugPort >= 65536) {
            throw new IllegalArgumentException("debugPort must be a valid TCP port (< 65536)");
        }
        this.debugPort = debugPort;
        return this;
    }

    public RealJenkinsExtension withDebugServer(boolean debugServer) {
        this.debugServer = debugServer;
        return this;
    }

    public RealJenkinsExtension withDebugSuspend(boolean debugSuspend) {
        this.debugSuspend = debugSuspend;
        return this;
    }

    public RealJenkinsExtension includeTestClasspathPlugins(boolean includeTestClasspathPlugins) {
        this.includeTestClasspathPlugins = includeTestClasspathPlugins;
        return this;
    }

    public RealJenkinsExtension prepareHomeLazily(boolean prepareHomeLazily) {
        this.prepareHomeLazily = prepareHomeLazily;
        return this;
    }

    public RealJenkinsExtension withFIPSEnabled() {
        return this.withFIPSEnabled(FIPSTestBundleProvider.get());
    }

    public RealJenkinsExtension withFIPSEnabled(FIPSTestBundleProvider fipsTestBundleProvider) {
        Objects.requireNonNull(fipsTestBundleProvider, "fipsTestBundleProvider must not be null");
        try {
            return this.withBootClasspath(fipsTestBundleProvider.getBootClasspathFiles().toArray(new File[0])).javaOptions(fipsTestBundleProvider.getJavaOptions().toArray(new String[0]));
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public RealJenkinsExtension withBootClasspath(File ... files) {
        this.bootClasspathFiles.addAll(List.of(files));
        return this;
    }

    public static List<String> getJacocoAgentOptions() {
        RuntimeMXBean runtimeMxBean = ManagementFactory.getRuntimeMXBean();
        List<String> arguments = runtimeMxBean.getInputArguments();
        return arguments.stream().filter(argument -> argument.startsWith("-javaagent:") && argument.contains("jacoco")).toList();
    }

    public void beforeEach(ExtensionContext context) throws Exception {
        this.extensionContext = context;
        this.description = Description.createTestDescription((String)this.extensionContext.getTestClass().map(Class::getName).orElse(null), (String)this.extensionContext.getTestMethod().map(Method::getName).orElse(null), (Annotation[])new Annotation[0]);
        System.err.println("=== Starting " + String.valueOf(this.description));
        this.jenkinsOptions("--webroot=" + String.valueOf(this.createTempDirectory("webroot")), "--pluginroot=" + String.valueOf(this.createTempDirectory("pluginroot")));
        if (this.war == null) {
            this.war = RealJenkinsExtension.findJenkinsWar();
        }
        if (this.home.get() == null) {
            this.home.set(this.tmp.allocate());
            if (!this.prepareHomeLazily) {
                this.provision();
            }
        }
    }

    public void afterEach(ExtensionContext context) throws Exception {
        System.err.println("=== Stopping " + String.valueOf(this.description));
        this.stopJenkins();
        try {
            this.tmp.dispose();
        }
        catch (Exception x) {
            LOGGER.log(Level.WARNING, null, x);
        }
    }

    @SuppressFBWarnings(value={"PATH_TRAVERSAL_IN"}, justification="irrelevant")
    private void provision() throws Exception {
        String targetJenkinsVersion;
        LocalData localData;
        this.provisioned = true;
        if (this.home.get() == null) {
            this.home.set(this.tmp.allocate());
        }
        if ((localData = ((Method)this.extensionContext.getTestMethod().orElseThrow()).getAnnotation(LocalData.class)) != null) {
            new HudsonHomeLoader.Local((Method)this.extensionContext.getTestMethod().orElseThrow(), localData.value()).copy(this.getHome());
        }
        File plugins = new File(this.getHome(), "plugins");
        Files.createDirectories(plugins.toPath(), new FileAttribute[0]);
        try (JarFile jf = new JarFile(this.war);){
            targetJenkinsVersion = jf.getManifest().getMainAttributes().getValue("Jenkins-Version");
            PluginUtils.createRealJenkinsExtensionPlugin(plugins, targetJenkinsVersion);
        }
        if (this.includeTestClasspathPlugins) {
            TreeSet<String> snapshotPlugins = new TreeSet<String>();
            Enumeration<URL> indexJellies = RealJenkinsExtension.class.getClassLoader().getResources("index.jelly");
            while (indexJellies.hasMoreElements()) {
                String indexJelly = indexJellies.nextElement().toString();
                Matcher m = SNAPSHOT_INDEX_JELLY.matcher(indexJelly);
                if (!m.matches()) continue;
                Path snapshotManifest = Paths.get(URI.create(m.group(1) + "/test-classes/the.jpl"));
                if (!Files.exists(snapshotManifest, new LinkOption[0])) {
                    snapshotManifest = Paths.get(URI.create(m.group(1) + "/test-classes/the.hpl"));
                }
                if (Files.exists(snapshotManifest, new LinkOption[0])) {
                    String shortName;
                    try (InputStream is = Files.newInputStream(snapshotManifest, new OpenOption[0]);){
                        shortName = new Manifest(is).getMainAttributes().getValue("Short-Name");
                    }
                    if (shortName == null) {
                        throw new IOException("malformed " + String.valueOf(snapshotManifest));
                    }
                    if (this.skippedPlugins.contains(shortName)) continue;
                    Files.copy(snapshotManifest, plugins.toPath().resolve(shortName + ".jpl"), new CopyOption[0]);
                    snapshotPlugins.add(shortName);
                    continue;
                }
                System.err.println("Warning: found " + indexJelly + " but did not find corresponding ../test-classes/the.[hj]pl");
            }
            URL index = RealJenkinsExtension.class.getResource("/test-dependencies/index");
            if (index != null) {
                try (BufferedReader r = new BufferedReader(new InputStreamReader(index.openStream(), StandardCharsets.UTF_8));){
                    String line;
                    while ((line = r.readLine()) != null) {
                        File f;
                        if (snapshotPlugins.contains(line) || this.skippedPlugins.contains(line)) continue;
                        URL url = new URL(index, line + ".jpi");
                        try {
                            f = new File(url.toURI());
                        }
                        catch (IllegalArgumentException x) {
                            if (x.getMessage().equals("URI is not hierarchical")) {
                                throw new IOException("You are probably trying to load plugins from within a jarfile (not possible). If you are running this in your IDE and see this message, it is likely that you have a clean target directory. Try running 'mvn test-compile' from the command line (once only), which will copy the required plugins into target/test-classes/test-dependencies - then retry your test", x);
                            }
                            throw new IOException(String.valueOf(index) + " contains bogus line " + line, x);
                        }
                        if (f.exists()) {
                            FileUtils.copyURLToFile((URL)url, (File)new File(plugins, line + ".jpi"));
                            continue;
                        }
                        FileUtils.copyURLToFile((URL)new URL(index, line + ".hpi"), (File)new File(plugins, line + ".jpi"));
                    }
                }
            }
        }
        for (String extraPlugin : this.extraPlugins) {
            String name;
            URL url = RealJenkinsExtension.class.getClassLoader().getResource(extraPlugin);
            try (InputStream is = url.openStream();
                 JarInputStream jis = new JarInputStream(is);){
                Manifest man = jis.getManifest();
                if (man == null) {
                    throw new IOException("No manifest found in " + extraPlugin);
                }
                name = man.getMainAttributes().getValue("Short-Name");
                if (name == null) {
                    throw new IOException("No Short-Name found in " + extraPlugin);
                }
            }
            FileUtils.copyURLToFile((URL)url, (File)new File(plugins, name + ".jpi"));
        }
        for (SyntheticPlugin syntheticPlugin : this.syntheticPlugins) {
            syntheticPlugin.writeTo(new File(plugins, syntheticPlugin.shortName + ".jpi"), targetJenkinsVersion);
        }
        System.err.println("Will load plugins: " + Stream.of(plugins.list()).filter(n -> n.matches(".+[.][hj]p[il]")).sorted().collect(Collectors.joining(" ")));
    }

    public void deprovision() throws Exception {
        this.tmp.dispose();
        this.home.set(null);
        this.provisioned = false;
    }

    public Path createTempDirectory(String prefix) throws IOException {
        return this.tmp.allocate(prefix).toPath();
    }

    public boolean isAlive() {
        return this.proc != null && this.proc.isAlive();
    }

    public String[] getTruststoreJavaOptions() {
        return this.keyStoreManager != null ? this.keyStoreManager.getTruststoreJavaOptions() : new String[]{};
    }

    public void then(Step ... steps) throws Throwable {
        this.then(new StepsToStep2(steps));
    }

    public <T extends Serializable> T then(Step2<T> s) throws Throwable {
        this.startJenkins();
        try {
            T t = this.runRemotely(s);
            return t;
        }
        finally {
            this.stopJenkins();
        }
    }

    public URL getUrl() throws MalformedURLException {
        if (this.port == 0) {
            throw new IllegalStateException("This method must be called after calling #startJenkins.");
        }
        return new URL(this.https ? "https" : "http", this.host, this.port, this.prefix + "/");
    }

    public RealJenkinsExtension https() {
        try {
            Path keyStorePath = this.tmp.allocate().toPath().resolve("test-keystore.p12");
            IOUtils.copy((URL)this.getClass().getResource("/https/test-keystore.p12"), (File)keyStorePath.toFile());
            KeyStoreManager keyStoreManager = new KeyStoreManager(keyStorePath, "changeit");
            try (InputStream is = this.getClass().getResourceAsStream("/https/test-cert.pem");){
                X509Certificate cert = (X509Certificate)CertificateFactory.getInstance("X.509").generateCertificate(is);
                this.https("localhost", keyStoreManager, cert);
            }
        }
        catch (IOException | KeyStoreException | NoSuchAlgorithmException | CertificateException e) {
            throw new RuntimeException(e);
        }
        return this;
    }

    public RealJenkinsExtension https(@NonNull String host, @NonNull KeyStoreManager keyStoreManager, @NonNull X509Certificate rootCA) {
        this.host = host;
        this.https = true;
        this.keyStoreManager = keyStoreManager;
        try {
            this.sslSocketFactory = keyStoreManager.buildClientSSLContext().getSocketFactory();
        }
        catch (IOException | KeyManagementException | KeyStoreException | NoSuchAlgorithmException | CertificateException e) {
            throw new RuntimeException(e);
        }
        this.rootCA = rootCA;
        return this;
    }

    @Nullable
    public X509Certificate getRootCA() {
        return this.rootCA;
    }

    @Nullable
    public String getRootCAPem() {
        String string;
        block10: {
            if (this.rootCA == null) {
                return null;
            }
            InputStream is = this.getClass().getResourceAsStream("/https/test-cert.pem");
            try {
                assert (is != null);
                string = IOUtils.toString((InputStream)is, (Charset)StandardCharsets.UTF_8);
                if (is == null) break block10;
            }
            catch (Throwable throwable) {
                try {
                    if (is != null) {
                        try {
                            is.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (IOException e) {
                    throw new RuntimeException(e);
                }
            }
            is.close();
        }
        return string;
    }

    @NonNull
    public SSLContext buildSSLContext() throws NoSuchAlgorithmException {
        if (this.rootCA != null) {
            try {
                KeyStore myTrustStore = KeyStore.getInstance(KeyStore.getDefaultType());
                myTrustStore.load(null, null);
                myTrustStore.setCertificateEntry(this.getName() != null ? this.getName() : UUID.randomUUID().toString(), this.rootCA);
                TrustManagerFactory trustManagerFactory = TrustManagerFactory.getInstance(TrustManagerFactory.getDefaultAlgorithm());
                trustManagerFactory.init(myTrustStore);
                SSLContext context = SSLContext.getInstance("TLS");
                context.init(null, trustManagerFactory.getTrustManagers(), null);
                return context;
            }
            catch (IOException | KeyManagementException | KeyStoreException | CertificateException e) {
                throw new RuntimeException(e);
            }
        }
        return SSLContext.getDefault();
    }

    private URL endpoint(String method) throws MalformedURLException {
        return new URL(this.getUrl(), "RealJenkinsExtension/" + method + "?token=" + this.token);
    }

    public File getHome() {
        return this.home.get();
    }

    public void setHome(File newHome) {
        this.home = new AtomicReference<File>(newHome);
    }

    private static File findJenkinsWar() throws Exception {
        for (File d = new File(".").getAbsoluteFile(); d != null; d = d.getParentFile()) {
            File war;
            if (!new File(d, ".jenkins").exists() || !(war = new File(d, "war/target/jenkins.war")).exists()) continue;
            LOGGER.log(Level.INFO, "Using jenkins.war from {0}", war);
            return war;
        }
        return WarExploder.findJenkinsWar();
    }

    public WebClient createWebClient() {
        WebClient wc = new WebClient();
        if (this.keyStoreManager != null) {
            this.keyStoreManager.configureWebClient(wc);
        }
        return wc;
    }

    @SuppressFBWarnings(value={"PATH_TRAVERSAL_IN", "URLCONNECTION_SSRF_FD", "COMMAND_INJECTION"}, justification="irrelevant")
    public void startJenkins() throws Exception {
        boolean debugging;
        if (this.proc != null) {
            throw new IllegalStateException("Jenkins is (supposedly) already running");
        }
        if (this.prepareHomeLazily && !this.provisioned) {
            this.provision();
        }
        Path metadata = this.createTempDirectory("RealJenkinsExtension");
        Path cpFile = metadata.resolve("cp.txt");
        String cp = System.getProperty("java.class.path");
        Files.writeString(cpFile, (CharSequence)Stream.of(cp.split(File.pathSeparator)).collect(Collectors.joining(System.lineSeparator())), StandardCharsets.UTF_8, new OpenOption[0]);
        ArrayList<CallSite> argv = new ArrayList<CallSite>(List.of(new File(this.javaHome != null ? this.javaHome : System.getProperty("java.home"), "bin/java").getAbsolutePath(), "-ea", "-Dhudson.Main.development=true", "-DRealJenkinsExtension.classpath=" + String.valueOf(cpFile), "-DRealJenkinsExtension.location=" + String.valueOf(RealJenkinsExtension.class.getProtectionDomain().getCodeSource().getLocation()), "-DRealJenkinsExtension.description=" + String.valueOf(this.description), "-DRealJenkinsExtension.token=" + this.token));
        argv.addAll(RealJenkinsExtension.getJacocoAgentOptions());
        for (Map.Entry<String, Level> e : this.loggers.entrySet()) {
            argv.add((CallSite)((Object)("-DRealJenkinsExtension.logging." + e.getKey() + "=" + e.getValue().getName())));
        }
        this.portFile = metadata.resolve("jenkins-port.txt");
        argv.add((CallSite)((Object)("-Dwinstone.portFileName=" + String.valueOf(this.portFile))));
        String tmp = System.getProperty("java.io.tmpdir");
        if (tmp != null) {
            argv.add((CallSite)((Object)("-Djava.io.tmpdir=" + tmp)));
        }
        if (debugging = new DisableOnDebug(null).isDebugging()) {
            argv.add((CallSite)((Object)("-agentlib:jdwp=transport=dt_socket,server=" + (this.debugServer ? "y" : "n") + ",suspend=" + (this.debugSuspend ? "y" : "n") + (String)(this.debugPort > 0 ? ",address=" + this.httpListenAddress + ":" + this.debugPort : ""))));
        }
        if (!this.bootClasspathFiles.isEmpty()) {
            String fileList = this.bootClasspathFiles.stream().map(File::getAbsolutePath).collect(Collectors.joining(File.pathSeparator));
            argv.add((CallSite)((Object)("-Xbootclasspath/a:" + fileList)));
        }
        argv.addAll(this.javaOptions);
        argv.addAll(List.of("-jar", this.war.getAbsolutePath(), "--enable-future-java", "--httpListenAddress=" + this.httpListenAddress));
        if (!this.prefix.isEmpty()) {
            argv.add((CallSite)((Object)("--prefix=" + this.prefix)));
        }
        argv.addAll(this.getPortOptions());
        if (this.https) {
            argv.add((CallSite)((Object)("--httpsKeyStore=" + String.valueOf(this.keyStoreManager.getPath().toAbsolutePath()))));
            if (this.keyStoreManager.getPassword() != null) {
                argv.add((CallSite)((Object)("--httpsKeyStorePassword=" + this.keyStoreManager.getPassword())));
            }
        }
        argv.addAll(this.jenkinsOptions);
        TreeMap<String, String> env = new TreeMap<String, String>();
        env.put("JENKINS_HOME", this.getHome().getAbsolutePath());
        String forkNumber = System.getProperty("surefire.forkNumber");
        if (forkNumber != null) {
            env.put("SUREFIRE_FORK_NUMBER", forkNumber);
        }
        for (Map.Entry<String, String> entry : this.extraEnv.entrySet()) {
            if (entry.getValue() == null) continue;
            env.put(entry.getKey(), entry.getValue());
        }
        System.err.println(env.entrySet().stream().map(Object::toString).collect(Collectors.joining(" ")) + " " + String.join((CharSequence)" ", argv));
        ProcessBuilder pb = new ProcessBuilder(argv);
        pb.environment().putAll(env);
        pb.redirectErrorStream(true);
        this.proc = pb.start();
        new StreamCopyThread(this.description.toString(), this.proc.getInputStream(), this.prefixedOutputStreamBuilder.build(System.err)).start();
        int tries = 0;
        while (true) {
            block20: {
                if (!this.proc.isAlive()) {
                    int exitValue = this.proc.exitValue();
                    this.proc = null;
                    throw new IOException("Jenkins process terminated prematurely with exit code " + exitValue);
                }
                if (this.port == 0 && this.portFile != null && Files.isRegularFile(this.portFile, new LinkOption[0])) {
                    this.port = RealJenkinsExtension.readPort(this.portFile);
                }
                if (this.port != 0) {
                    try {
                        URL status = this.endpoint("status");
                        HttpURLConnection conn = this.decorateConnection(status.openConnection());
                        String checkResult = RealJenkinsExtension.checkResult(conn);
                        if (checkResult != null) {
                            throw new IOException("Response code " + conn.getResponseCode() + " for " + String.valueOf(status) + ": " + checkResult + " " + String.valueOf(conn.getHeaderFields()));
                        }
                        System.err.println((this.getName() != null ? this.getName() : "Jenkins") + " is running at " + String.valueOf(this.getUrl()));
                        break;
                    }
                    catch (JenkinsStartupException jse) {
                        this.proc.destroyForcibly();
                        this.proc = null;
                        throw jse;
                    }
                    catch (Exception x) {
                        if (!debugging && ++tries == 1800) {
                            throw new AssertionError((Object)"Jenkins did not start after 3m");
                        }
                        if (tries % 600 != 0) break block20;
                        x.printStackTrace();
                    }
                }
            }
            Thread.sleep(100L);
        }
        this.addTimeout();
    }

    private Collection<String> getPortOptions() {
        if (this.https) {
            return List.of("--httpPort=-1", "--httpsPort=" + this.port);
        }
        return List.of("--httpPort=" + this.port);
    }

    @CheckForNull
    public static String checkResult(HttpURLConnection conn) throws IOException {
        int code = conn.getResponseCode();
        if (code == 200) {
            conn.getInputStream().close();
            return null;
        }
        String err = "?";
        try (InputStream is = conn.getErrorStream();){
            if (is != null) {
                err = new String(is.readAllBytes(), StandardCharsets.UTF_8);
            }
        }
        catch (Exception x) {
            x.printStackTrace();
        }
        if (code == 500) {
            throw new JenkinsStartupException(err);
        }
        return err;
    }

    private void addTimeout() {
        if (this.timeout > 0) {
            Timer.get().schedule(() -> {
                if (this.proc != null) {
                    LOGGER.warning("Test timeout expired, stopping steps\u2026");
                    try {
                        this.decorateConnection(this.endpoint("timeout").openConnection()).getInputStream().close();
                    }
                    catch (IOException x) {
                        x.printStackTrace();
                    }
                    LOGGER.warning("\u2026and giving steps a chance to fail\u2026");
                    try {
                        Thread.sleep(15000L);
                    }
                    catch (InterruptedException x) {
                        x.printStackTrace();
                    }
                    LOGGER.warning("\u2026and killing Jenkins process.");
                    this.proc.destroyForcibly();
                    this.proc = null;
                }
            }, (long)this.timeout, TimeUnit.SECONDS);
        }
    }

    private static int readPort(Path portFile) throws IOException {
        String s = Files.readString(portFile, StandardCharsets.UTF_8);
        try {
            return Integer.parseInt(s);
        }
        catch (NumberFormatException e) {
            throw new AssertionError((Object)("Unable to parse port from " + s + ". Jenkins did not start."));
        }
    }

    public void stopJenkins() throws Exception {
        if (this.proc != null) {
            Process _proc = this.proc;
            this.proc = null;
            if (_proc.isAlive()) {
                try {
                    this.decorateConnection(this.endpoint("exit").openConnection()).getInputStream().close();
                }
                catch (IOException e) {
                    System.err.println("Unable to connect to the Jenkins process to stop it: " + String.valueOf(e));
                }
            } else {
                System.err.println("Jenkins process was already terminated.");
            }
            if (!_proc.waitFor(60L, TimeUnit.SECONDS)) {
                System.err.println("Jenkins failed to stop within 60 seconds, attempting to kill the Jenkins process");
                _proc.destroyForcibly();
                throw new AssertionError((Object)"Jenkins failed to terminate within 60 seconds");
            }
            int exitValue = _proc.exitValue();
            if (exitValue != 0) {
                throw new AssertionError((Object)("nonzero exit code: " + exitValue));
            }
        }
    }

    public void stopJenkinsForcibly() {
        if (this.proc != null) {
            Process _proc = this.proc;
            this.proc = null;
            System.err.println("Killing the Jenkins process as requested");
            _proc.destroyForcibly();
        }
    }

    public void runRemotely(Step ... steps) throws Throwable {
        this.runRemotely(new StepsToStep2(steps));
    }

    public void run(Step step) throws Throwable {
        this.runRemotely(step);
    }

    public void run(ErrorCollector errors, Step step) {
        errors.checkSucceeds(() -> {
            try {
                this.run(step);
                return null;
            }
            catch (Exception x) {
                throw x;
            }
            catch (Throwable x) {
                throw new Exception(x);
            }
        });
    }

    @SuppressFBWarnings(value={"URLCONNECTION_SSRF_FD"}, justification="irrelevant")
    public <T extends Serializable> T runRemotely(Step2<T> s) throws Throwable {
        HttpURLConnection conn = this.decorateConnection(this.endpoint("step").openConnection());
        conn.setRequestProperty("Content-Type", "application/octet-stream");
        conn.setDoOutput(true);
        Init2.writeSer(conn.getOutputStream(), (Object)new InputPayload(this.token, s, this.getUrl()));
        try {
            OutputPayload result = (OutputPayload)Init2.readSer(conn.getInputStream(), null);
            if (result.assumptionFailure != null) {
                throw new TestAbortedException(result.assumptionFailure, (Throwable)result.error);
            }
            if (result.error != null) {
                throw new StepException(result.error, this.getName());
            }
            return (T)((Serializable)result.result);
        }
        catch (IOException e) {
            try (InputStream is = conn.getErrorStream();){
                if (is != null) {
                    String errorMessage = new String(is.readAllBytes(), StandardCharsets.UTF_8);
                    e.addSuppressed(new IOException("Response body: " + errorMessage));
                }
            }
            catch (IOException e2) {
                e.addSuppressed(e2);
            }
            throw e;
        }
    }

    public <T extends Serializable> T call(Step2<T> s) throws Throwable {
        return this.runRemotely(s);
    }

    private HttpURLConnection decorateConnection(@NonNull URLConnection urlConnection) {
        if (this.sslSocketFactory != null) {
            ((HttpsURLConnection)urlConnection).setSSLSocketFactory(this.sslSocketFactory);
        }
        return (HttpURLConnection)urlConnection;
    }

    public <A1 extends Serializable> void runRemotely(StepWithOneArg<A1> s, A1 arg1) throws Throwable {
        this.runRemotely(new StepWithOneArgWrapper<A1>(s, arg1));
    }

    public <A1 extends Serializable, A2 extends Serializable> void runRemotely(StepWithTwoArgs<A1, A2> s, A1 arg1, A2 arg2) throws Throwable {
        this.runRemotely(new StepWithTwoArgsWrapper<A1, A2>(s, arg1, arg2));
    }

    public <A1 extends Serializable, A2 extends Serializable, A3 extends Serializable> void runRemotely(StepWithThreeArgs<A1, A2, A3> s, A1 arg1, A2 arg2, A3 arg3) throws Throwable {
        this.runRemotely(new StepWithThreeArgsWrapper<A1, A2, A3>(s, arg1, arg2, arg3));
    }

    public <A1 extends Serializable, A2 extends Serializable, A3 extends Serializable, A4 extends Serializable> void runRemotely(StepWithFourArgs<A1, A2, A3, A4> s, A1 arg1, A2 arg2, A3 arg3, A4 arg4) throws Throwable {
        this.runRemotely(new StepWithFourArgsWrapper<A1, A2, A3, A4>(s, arg1, arg2, arg3, arg4));
    }

    public <R extends Serializable, A1 extends Serializable> R runRemotely(StepWithReturnAndOneArg<R, A1> s, A1 arg1) throws Throwable {
        return (R)this.runRemotely(new StepWithReturnAndOneArgWrapper<R, A1>(s, arg1));
    }

    public <R extends Serializable, A1 extends Serializable, A2 extends Serializable> R runRemotely(StepWithReturnAndTwoArgs<R, A1, A2> s, A1 arg1, A2 arg2) throws Throwable {
        return (R)this.runRemotely(new StepWithReturnAndTwoArgsWrapper<R, A1, A2>(s, arg1, arg2));
    }

    public <R extends Serializable, A1 extends Serializable, A2 extends Serializable, A3 extends Serializable> R runRemotely(StepWithReturnAndThreeArgs<R, A1, A2, A3> s, A1 arg1, A2 arg2, A3 arg3) throws Throwable {
        return (R)this.runRemotely(new StepWithReturnAndThreeArgsWrapper<R, A1, A2, A3>(s, arg1, arg2, arg3));
    }

    public <R extends Serializable, A1 extends Serializable, A2 extends Serializable, A3 extends Serializable, A4 extends Serializable> R runRemotely(StepWithReturnAndFourArgs<R, A1, A2, A3, A4> s, A1 arg1, A2 arg2, A3 arg3, A4 arg4) throws Throwable {
        return (R)this.runRemotely(new StepWithReturnAndFourArgsWrapper<R, A1, A2, A3, A4>(s, arg1, arg2, arg3, arg4));
    }

    public static final class SyntheticPlugin {
        private final String pkg;
        private String shortName;
        private String version = "1-SNAPSHOT";
        private final Map<String, String> headers = new HashMap<String, String>();

        public SyntheticPlugin(Class<?> exampleClass) {
            this(exampleClass.getPackage());
        }

        public SyntheticPlugin(Package pkg) {
            this(pkg.getName());
        }

        public SyntheticPlugin(String pkg) {
            this.pkg = pkg;
            this.shortName = "synthetic-" + this.pkg.replace('.', '-');
        }

        public SyntheticPlugin shortName(String shortName) {
            this.shortName = shortName;
            return this;
        }

        public SyntheticPlugin version(String version) {
            this.version = version;
            return this;
        }

        public SyntheticPlugin header(String key, String value) {
            this.headers.put(key, value);
            return this;
        }

        void writeTo(File jpi, String defaultJenkinsVersion) throws IOException, URISyntaxException {
            Manifest mani = new Manifest();
            Attributes attr = mani.getMainAttributes();
            attr.put(Attributes.Name.MANIFEST_VERSION, "1.0");
            attr.putValue("Short-Name", this.shortName);
            attr.putValue("Plugin-Version", this.version);
            attr.putValue("Jenkins-Version", defaultJenkinsVersion);
            for (Map.Entry<String, String> entry : this.headers.entrySet()) {
                attr.putValue(entry.getKey(), entry.getValue());
            }
            ByteArrayOutputStream jar = new ByteArrayOutputStream();
            try (JarOutputStream jos = new JarOutputStream((OutputStream)jar, mani);){
                String pkgSlash = this.pkg.replace('.', '/');
                URL mainU = RealJenkinsExtension.class.getClassLoader().getResource(pkgSlash);
                if (mainU == null) {
                    throw new IOException("Cannot find " + pkgSlash + " in classpath");
                }
                Path main = Path.of(mainU.toURI());
                if (!Files.isDirectory(main, new LinkOption[0])) {
                    throw new IOException(String.valueOf(main) + " does not exist");
                }
                Path metaInf = Path.of(URI.create(mainU.toString().replaceFirst("\\Q" + pkgSlash + "\\E/?$", "META-INF")));
                if (Files.isDirectory(metaInf, new LinkOption[0])) {
                    this.zip(jos, metaInf, "META-INF/", this.pkg);
                }
                this.zip(jos, main, pkgSlash + "/", null);
            }
            try (FileOutputStream os = new FileOutputStream(jpi);
                 JarOutputStream jos = new JarOutputStream((OutputStream)os, mani);){
                jos.putNextEntry(new JarEntry("WEB-INF/lib/" + this.shortName + ".jar"));
                jos.write(jar.toByteArray());
            }
            LOGGER.info(() -> "Generated " + String.valueOf(jpi));
        }

        private void zip(ZipOutputStream zos, Path dir, String prefix, @CheckForNull String filter) throws IOException {
            try (Stream<Path> stream = Files.list(dir);){
                Iterable iterable = stream::iterator;
                for (Path child : iterable) {
                    Path nameP = child.getFileName();
                    assert (nameP != null);
                    String name = nameP.toString();
                    if (Files.isDirectory(child, new LinkOption[0])) {
                        this.zip(zos, child, prefix + name + "/", filter);
                        continue;
                    }
                    if (filter != null && !Files.readString(child, StandardCharsets.ISO_8859_1).contains(filter)) {
                        LOGGER.info(() -> "Skipping " + String.valueOf(child) + " since it makes no mention of " + filter);
                        continue;
                    }
                    LOGGER.info(() -> "Packing " + String.valueOf(child));
                    zos.putNextEntry(new ZipEntry(prefix + name));
                    Files.copy(child, zos);
                }
            }
        }
    }

    private static class StepsToStep2
    implements Step2<Serializable> {
        private final Step[] steps;

        StepsToStep2(Step ... steps) {
            this.steps = steps;
        }

        @Override
        public Serializable run(JenkinsRule r) throws Throwable {
            for (Step step : this.steps) {
                step.run(r);
            }
            return null;
        }
    }

    @FunctionalInterface
    public static interface Step
    extends Serializable {
        public void run(JenkinsRule var1) throws Throwable;
    }

    @FunctionalInterface
    public static interface Step2<T extends Serializable>
    extends Serializable {
        public T run(JenkinsRule var1) throws Throwable;
    }

    public static class JenkinsStartupException
    extends IOException {
        public JenkinsStartupException(String message) {
            super(message);
        }
    }

    private static class InputPayload
    implements Serializable {
        private final String token;
        private final Step2<?> step;
        private final URL url;
        private final String contextPath;

        InputPayload(String token, Step2<?> step, URL url) {
            this.token = token;
            this.step = step;
            this.url = url;
            this.contextPath = url.getPath().replaceAll("/$", "");
        }
    }

    public static final class Init2 {
        public static void run(Object jenkins) throws Exception {
            Object pluginManager = jenkins.getClass().getField("pluginManager").get(jenkins);
            ClassLoader uberClassLoader = (ClassLoader)pluginManager.getClass().getField("uberClassLoader").get(pluginManager);
            URLClassLoader tests = new URLClassLoader((URL[])Files.readAllLines(Paths.get(System.getProperty("RealJenkinsExtension.classpath"), new String[0]), StandardCharsets.UTF_8).stream().map(Init2::pathToURL).toArray(URL[]::new), uberClassLoader);
            tests.loadClass("org.jvnet.hudson.test.junit.jupiter.RealJenkinsExtension$Endpoint").getMethod("register", new Class[0]).invoke(null, new Object[0]);
        }

        @SuppressFBWarnings(value={"PATH_TRAVERSAL_IN"}, justification="irrelevant")
        private static URL pathToURL(String path) {
            try {
                return Paths.get(path, new String[0]).toUri().toURL();
            }
            catch (MalformedURLException x) {
                throw new IllegalArgumentException(x);
            }
        }

        static void writeSer(File f, Object o) throws Exception {
            try (FileOutputStream os = new FileOutputStream(f);){
                Init2.writeSer(os, o);
            }
        }

        static void writeSer(OutputStream os, Object o) throws Exception {
            try (ObjectOutputStream oos = new ObjectOutputStream(os);){
                oos.writeObject(o);
            }
        }

        static Object readSer(File f, ClassLoader loader) throws Exception {
            try (FileInputStream is = new FileInputStream(f);){
                Object object = Init2.readSer(is, loader);
                return object;
            }
        }

        @SuppressFBWarnings(value={"OBJECT_DESERIALIZATION"}, justification="irrelevant")
        static Object readSer(InputStream is, final ClassLoader loader) throws Exception {
            try (ObjectInputStream ois = new ObjectInputStream(is){

                @Override
                protected Class<?> resolveClass(ObjectStreamClass desc) throws IOException, ClassNotFoundException {
                    if (loader != null) {
                        try {
                            return loader.loadClass(desc.getName());
                        }
                        catch (ClassNotFoundException classNotFoundException) {
                            // empty catch block
                        }
                    }
                    return super.resolveClass(desc);
                }
            };){
                Object object = ois.readObject();
                return object;
            }
        }

        private Init2() {
        }
    }

    private static class OutputPayload
    implements Serializable {
        private final Object result;
        private final ProxyException error;
        private final String assumptionFailure;

        OutputPayload(Object result, Throwable error) {
            this.result = result;
            this.error = error != null ? new ProxyException(error) : null;
            this.assumptionFailure = error instanceof TestAbortedException ? error.getMessage() : null;
        }
    }

    public static final class ProxyException
    extends IOException {
        ProxyException(Throwable cause) {
            super(cause.toString());
            this.setStackTrace(cause.getStackTrace());
            if (cause.getCause() != null) {
                this.initCause(new ProxyException(cause.getCause()));
            }
            for (Throwable suppressed : cause.getSuppressed()) {
                this.addSuppressed(new ProxyException(suppressed));
            }
        }

        @Override
        public String toString() {
            return this.getMessage();
        }
    }

    public static class StepException
    extends Exception {
        StepException(Throwable cause, @CheckForNull String name) {
            super(name != null ? "Remote step in " + name + " threw an exception: " + String.valueOf(cause) : "Remote step threw an exception: " + String.valueOf(cause), cause);
        }
    }

    private static final class StepWithOneArgWrapper<A1 extends Serializable>
    implements Step {
        private final StepWithOneArg<A1> delegate;
        private final A1 arg1;

        StepWithOneArgWrapper(StepWithOneArg<A1> delegate, A1 arg1) {
            this.delegate = delegate;
            this.arg1 = arg1;
        }

        @Override
        public void run(JenkinsRule r) throws Throwable {
            this.delegate.run(r, this.arg1);
        }
    }

    @FunctionalInterface
    public static interface StepWithOneArg<A1 extends Serializable>
    extends Serializable {
        public void run(JenkinsRule var1, A1 var2) throws Throwable;
    }

    private static final class StepWithTwoArgsWrapper<A1 extends Serializable, A2 extends Serializable>
    implements Step {
        private final StepWithTwoArgs<A1, A2> delegate;
        private final A1 arg1;
        private final A2 arg2;

        StepWithTwoArgsWrapper(StepWithTwoArgs<A1, A2> delegate, A1 arg1, A2 arg2) {
            this.delegate = delegate;
            this.arg1 = arg1;
            this.arg2 = arg2;
        }

        @Override
        public void run(JenkinsRule r) throws Throwable {
            this.delegate.run(r, this.arg1, this.arg2);
        }
    }

    @FunctionalInterface
    public static interface StepWithTwoArgs<A1 extends Serializable, A2 extends Serializable>
    extends Serializable {
        public void run(JenkinsRule var1, A1 var2, A2 var3) throws Throwable;
    }

    private static final class StepWithThreeArgsWrapper<A1 extends Serializable, A2 extends Serializable, A3 extends Serializable>
    implements Step {
        private final StepWithThreeArgs<A1, A2, A3> delegate;
        private final A1 arg1;
        private final A2 arg2;
        private final A3 arg3;

        StepWithThreeArgsWrapper(StepWithThreeArgs<A1, A2, A3> delegate, A1 arg1, A2 arg2, A3 arg3) {
            this.delegate = delegate;
            this.arg1 = arg1;
            this.arg2 = arg2;
            this.arg3 = arg3;
        }

        @Override
        public void run(JenkinsRule r) throws Throwable {
            this.delegate.run(r, this.arg1, this.arg2, this.arg3);
        }
    }

    @FunctionalInterface
    public static interface StepWithThreeArgs<A1 extends Serializable, A2 extends Serializable, A3 extends Serializable>
    extends Serializable {
        public void run(JenkinsRule var1, A1 var2, A2 var3, A3 var4) throws Throwable;
    }

    private static final class StepWithFourArgsWrapper<A1 extends Serializable, A2 extends Serializable, A3 extends Serializable, A4 extends Serializable>
    implements Step {
        private final StepWithFourArgs<A1, A2, A3, A4> delegate;
        private final A1 arg1;
        private final A2 arg2;
        private final A3 arg3;
        private final A4 arg4;

        StepWithFourArgsWrapper(StepWithFourArgs<A1, A2, A3, A4> delegate, A1 arg1, A2 arg2, A3 arg3, A4 arg4) {
            this.delegate = delegate;
            this.arg1 = arg1;
            this.arg2 = arg2;
            this.arg3 = arg3;
            this.arg4 = arg4;
        }

        @Override
        public void run(JenkinsRule r) throws Throwable {
            this.delegate.run(r, this.arg1, this.arg2, this.arg3, this.arg4);
        }
    }

    @FunctionalInterface
    public static interface StepWithFourArgs<A1 extends Serializable, A2 extends Serializable, A3 extends Serializable, A4 extends Serializable>
    extends Serializable {
        public void run(JenkinsRule var1, A1 var2, A2 var3, A3 var4, A4 var5) throws Throwable;
    }

    private static final class StepWithReturnAndOneArgWrapper<R extends Serializable, A1 extends Serializable>
    implements Step2<R> {
        private final StepWithReturnAndOneArg<R, A1> delegate;
        private final A1 arg1;

        StepWithReturnAndOneArgWrapper(StepWithReturnAndOneArg<R, A1> delegate, A1 arg1) {
            this.delegate = delegate;
            this.arg1 = arg1;
        }

        @Override
        public R run(JenkinsRule r) throws Throwable {
            return this.delegate.run(r, this.arg1);
        }
    }

    @FunctionalInterface
    public static interface StepWithReturnAndOneArg<R extends Serializable, A1 extends Serializable>
    extends Serializable {
        public R run(JenkinsRule var1, A1 var2) throws Throwable;
    }

    private static final class StepWithReturnAndTwoArgsWrapper<R extends Serializable, A1 extends Serializable, A2 extends Serializable>
    implements Step2<R> {
        private final StepWithReturnAndTwoArgs<R, A1, A2> delegate;
        private final A1 arg1;
        private final A2 arg2;

        StepWithReturnAndTwoArgsWrapper(StepWithReturnAndTwoArgs<R, A1, A2> delegate, A1 arg1, A2 arg2) {
            this.delegate = delegate;
            this.arg1 = arg1;
            this.arg2 = arg2;
        }

        @Override
        public R run(JenkinsRule r) throws Throwable {
            return this.delegate.run(r, this.arg1, this.arg2);
        }
    }

    @FunctionalInterface
    public static interface StepWithReturnAndTwoArgs<R extends Serializable, A1 extends Serializable, A2 extends Serializable>
    extends Serializable {
        public R run(JenkinsRule var1, A1 var2, A2 var3) throws Throwable;
    }

    private static final class StepWithReturnAndThreeArgsWrapper<R extends Serializable, A1 extends Serializable, A2 extends Serializable, A3 extends Serializable>
    implements Step2<R> {
        private final StepWithReturnAndThreeArgs<R, A1, A2, A3> delegate;
        private final A1 arg1;
        private final A2 arg2;
        private final A3 arg3;

        StepWithReturnAndThreeArgsWrapper(StepWithReturnAndThreeArgs<R, A1, A2, A3> delegate, A1 arg1, A2 arg2, A3 arg3) {
            this.delegate = delegate;
            this.arg1 = arg1;
            this.arg2 = arg2;
            this.arg3 = arg3;
        }

        @Override
        public R run(JenkinsRule r) throws Throwable {
            return this.delegate.run(r, this.arg1, this.arg2, this.arg3);
        }
    }

    @FunctionalInterface
    public static interface StepWithReturnAndThreeArgs<R extends Serializable, A1 extends Serializable, A2 extends Serializable, A3 extends Serializable>
    extends Serializable {
        public R run(JenkinsRule var1, A1 var2, A2 var3, A3 var4) throws Throwable;
    }

    private static final class StepWithReturnAndFourArgsWrapper<R extends Serializable, A1 extends Serializable, A2 extends Serializable, A3 extends Serializable, A4 extends Serializable>
    implements Step2<R> {
        private final StepWithReturnAndFourArgs<R, A1, A2, A3, A4> delegate;
        private final A1 arg1;
        private final A2 arg2;
        private final A3 arg3;
        private final A4 arg4;

        StepWithReturnAndFourArgsWrapper(StepWithReturnAndFourArgs<R, A1, A2, A3, A4> delegate, A1 arg1, A2 arg2, A3 arg3, A4 arg4) {
            this.delegate = delegate;
            this.arg1 = arg1;
            this.arg2 = arg2;
            this.arg3 = arg3;
            this.arg4 = arg4;
        }

        @Override
        public R run(JenkinsRule r) throws Throwable {
            return this.delegate.run(r, this.arg1, this.arg2, this.arg3, this.arg4);
        }
    }

    @FunctionalInterface
    public static interface StepWithReturnAndFourArgs<R extends Serializable, A1 extends Serializable, A2 extends Serializable, A3 extends Serializable, A4 extends Serializable>
    extends Serializable {
        public R run(JenkinsRule var1, A1 var2, A2 var3, A3 var4, A4 var5) throws Throwable;
    }

    public static final class CustomJenkinsRule
    extends JenkinsRule
    implements AutoCloseable {
        private final URL url;

        public CustomJenkinsRule(URL url, String contextPath) throws Exception {
            this.jenkins = Jenkins.get();
            this.url = url;
            this.contextPath = contextPath;
            if (this.jenkins.isUsageStatisticsCollected()) {
                this.jenkins.setNoUsageStatistics(Boolean.valueOf(true));
            }
            if (JenkinsLocationConfiguration.get().getUrl() == null) {
                JenkinsLocationConfiguration.get().setUrl(url.toExternalForm());
            }
            this.testDescription = Description.createSuiteDescription((String)System.getProperty("RealJenkinsExtension.description"), (Annotation[])new Annotation[0]);
            this.env = new TestEnvironment(this.testDescription);
            this.env.pin();
        }

        @Override
        public URL getURL() throws IOException {
            return this.url;
        }

        @Override
        public void close() throws Exception {
            this.env.dispose();
        }
    }

    public static final class Endpoint
    implements UnprotectedRootAction {
        private static Set<Logger> loggers = new HashSet<Logger>();
        private final byte[] actualToken = System.getProperty("RealJenkinsExtension.token").getBytes(StandardCharsets.US_ASCII);
        private static final ExecutorService STEP_RUNNER = Executors.newSingleThreadExecutor((ThreadFactory)new NamingThreadFactory(Executors.defaultThreadFactory(), RealJenkinsExtension.class.getName() + ".STEP_RUNNER"));

        public static void register() throws Exception {
            Jenkins j = Jenkins.get();
            Endpoint.configureLogging();
            j.getActions().add(new Endpoint());
            CrumbExclusion.all().add((Object)new CrumbExclusion(){

                public boolean process(HttpServletRequest request, HttpServletResponse response, FilterChain chain) throws IOException, ServletException {
                    if (request.getPathInfo().startsWith("/RealJenkinsExtension/")) {
                        chain.doFilter((ServletRequest)request, (ServletResponse)response);
                        return true;
                    }
                    return false;
                }
            });
            JenkinsRule._configureUpdateCenter(j);
            System.err.println("RealJenkinsExtension ready");
            if (!new DisableOnDebug(null).isDebugging()) {
                Timer.get().scheduleAtFixedRate(JenkinsRule::dumpThreads, 2L, 2L, TimeUnit.MINUTES);
            }
        }

        private static void configureLogging() {
            Level minLevel = Level.INFO;
            for (String propertyName : System.getProperties().stringPropertyNames()) {
                if (!propertyName.startsWith(RealJenkinsExtension.REAL_JENKINS_EXTENSION_LOGGING)) continue;
                String loggerName = propertyName.substring(RealJenkinsExtension.REAL_JENKINS_EXTENSION_LOGGING.length());
                Logger logger = Logger.getLogger(loggerName);
                Level level = Level.parse(System.getProperty(propertyName));
                if (level.intValue() < minLevel.intValue()) {
                    minLevel = level;
                }
                logger.setLevel(level);
                loggers.add(logger);
            }
            if (!loggers.isEmpty()) {
                for (Handler h : Logger.getLogger("").getHandlers()) {
                    if (!(h instanceof ConsoleHandler)) continue;
                    h.setLevel(minLevel);
                }
            }
        }

        public String getUrlName() {
            return "RealJenkinsExtension";
        }

        public String getIconFileName() {
            return null;
        }

        public String getDisplayName() {
            return null;
        }

        private void checkToken(String token) {
            if (!MessageDigest.isEqual(this.actualToken, token.getBytes(StandardCharsets.US_ASCII))) {
                throw HttpResponses.forbidden();
            }
        }

        public void doStatus(@QueryParameter String token) {
            System.err.println("Checking status");
            this.checkToken(token);
        }

        @POST
        public void doStep(StaplerRequest2 req, StaplerResponse2 rsp) throws Throwable {
            InputPayload input = (InputPayload)Init2.readSer((InputStream)req.getInputStream(), Endpoint.class.getClassLoader());
            this.checkToken(input.token);
            Step2<?> s = input.step;
            URL url = input.url;
            String contextPath = input.contextPath;
            Throwable err = null;
            Serializable object = null;
            try {
                object = STEP_RUNNER.submit(() -> {
                    try (CustomJenkinsRule rule = new CustomJenkinsRule(url, contextPath);){
                        Object t;
                        block13: {
                            ACLContext ctx = ACL.as2((Authentication)ACL.SYSTEM2);
                            try {
                                t = s.run(rule);
                                if (ctx == null) break block13;
                            }
                            catch (Throwable throwable) {
                                if (ctx != null) {
                                    try {
                                        ctx.close();
                                    }
                                    catch (Throwable throwable2) {
                                        throwable.addSuppressed(throwable2);
                                    }
                                }
                                throw throwable;
                            }
                            ctx.close();
                        }
                        return t;
                    }
                    catch (Throwable t) {
                        throw new RuntimeException(t);
                    }
                }).get();
            }
            catch (ExecutionException e) {
                err = e.getCause().getCause();
            }
            catch (InterruptedException | CancellationException e) {
                err = e;
            }
            Init2.writeSer((OutputStream)rsp.getOutputStream(), (Object)new OutputPayload(object, err));
        }

        public HttpResponse doExit(@QueryParameter String token) throws IOException, InterruptedException {
            this.checkToken(token);
            try (ACLContext ctx = ACL.as2((Authentication)ACL.SYSTEM2);){
                Jenkins j = Jenkins.get();
                j.doQuietDown(true, 30000, null, false);
                j.getLifecycle().onStop("RealJenkinsExtension", null);
                j.cleanUp();
                new Thread(() -> System.exit(0), "exiting").start();
            }
            return HttpResponses.ok();
        }

        public void doTimeout(@QueryParameter String token) {
            this.checkToken(token);
            LOGGER.warning("Initiating shutdown");
            STEP_RUNNER.shutdownNow();
            try {
                LOGGER.warning("Awaiting termination of steps\u2026");
                STEP_RUNNER.awaitTermination(30L, TimeUnit.SECONDS);
                LOGGER.warning("\u2026terminated.");
            }
            catch (InterruptedException x) {
                x.printStackTrace();
            }
        }
    }
}

