/*
 * Decompiled with CFR 0.152.
 */
package org.jvnet.hudson.test.junit.jupiter;

import java.io.File;
import java.lang.annotation.Annotation;
import java.lang.reflect.AccessibleObject;
import java.lang.reflect.Method;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.junit.jupiter.api.extension.AfterEachCallback;
import org.junit.jupiter.api.extension.BeforeEachCallback;
import org.junit.jupiter.api.extension.ExtensionContext;
import org.junit.runner.Description;
import org.junit.runners.model.Statement;
import org.jvnet.hudson.test.JenkinsRule;
import org.jvnet.hudson.test.TemporaryDirectoryAllocator;

public class JenkinsSessionExtension
implements BeforeEachCallback,
AfterEachCallback {
    private static final Logger LOGGER = Logger.getLogger(JenkinsSessionExtension.class.getName());
    private final TemporaryDirectoryAllocator tmp = new TemporaryDirectoryAllocator();
    private ExtensionContext extensionContext;
    private Description description;
    private File home;
    private int port;

    public File getHome() {
        if (this.home == null) {
            throw new IllegalStateException("JENKINS_HOME has not been allocated yet");
        }
        return this.home;
    }

    public void beforeEach(ExtensionContext context) {
        this.extensionContext = context;
        this.description = Description.createTestDescription((String)this.extensionContext.getTestClass().map(Class::getName).orElse(null), (String)this.extensionContext.getTestMethod().map(Method::getName).orElse(null), (Annotation[])this.extensionContext.getTestMethod().map(AccessibleObject::getAnnotations).orElse(null));
        try {
            this.home = this.tmp.allocate();
        }
        catch (Exception x) {
            LOGGER.log(Level.WARNING, null, x);
        }
    }

    public void afterEach(ExtensionContext context) {
        try {
            this.tmp.dispose();
        }
        catch (Exception x) {
            LOGGER.log(Level.WARNING, null, x);
        }
    }

    public void then(final Step s) throws Throwable {
        final CustomJenkinsRule r = new CustomJenkinsRule(this.home, this.port);
        r.apply(new Statement(){

            public void evaluate() throws Throwable {
                JenkinsSessionExtension.this.port = r.getPort();
                s.run(r);
            }
        }, this.description).evaluate();
    }

    private static final class CustomJenkinsRule
    extends JenkinsRule {
        CustomJenkinsRule(File home, int port) {
            this.with(() -> home);
            this.localPort = port;
        }

        int getPort() {
            return this.localPort;
        }
    }

    @FunctionalInterface
    public static interface Step {
        public void run(JenkinsRule var1) throws Throwable;
    }
}

