/*
 * Decompiled with CFR 0.152.
 */
package org.jvnet.hudson.test.junit.jupiter;

import edu.umd.cs.findbugs.annotations.NonNull;
import hudson.security.ACL;
import java.lang.annotation.Annotation;
import java.lang.reflect.Method;
import org.junit.jupiter.api.extension.ExtensionContext;
import org.junit.jupiter.api.extension.ParameterContext;
import org.junit.runner.Description;
import org.jvnet.hudson.test.JenkinsRecipe;
import org.jvnet.hudson.test.JenkinsRule;
import org.jvnet.hudson.test.recipes.LocalData;
import org.jvnet.hudson.test.recipes.WithPlugin;
import org.jvnet.hudson.test.recipes.WithPluginManager;
import org.springframework.security.core.Authentication;

class JUnit5JenkinsRule
extends JenkinsRule {
    private final ParameterContext context;
    private final ExtensionContext extensionContext;

    JUnit5JenkinsRule(@NonNull ParameterContext context, @NonNull ExtensionContext extensionContext) {
        this.context = context;
        this.extensionContext = extensionContext;
        this.testDescription = Description.createTestDescription((String)extensionContext.getTestClass().map(Class::getName).orElse(null), (String)extensionContext.getTestMethod().map(Method::getName).orElse(null), (Annotation[])new Annotation[0]);
    }

    @Override
    public void recipe() throws Exception {
        Method testMethod;
        ACL.as2((Authentication)ACL.SYSTEM2);
        JenkinsRecipe jenkinsRecipe = this.context.findAnnotation(JenkinsRecipe.class).orElse(null);
        if (jenkinsRecipe != null) {
            JenkinsRecipe.Runner<?> runner = jenkinsRecipe.value().getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
            this.recipes.add(runner);
            this.tearDowns.add(() -> runner.tearDown(this, jenkinsRecipe));
        }
        if ((testMethod = (Method)this.extensionContext.getTestMethod().orElse(null)) != null) {
            WithPluginManager withPluginManager;
            WithPlugin withPlugin;
            LocalData localData = testMethod.getAnnotation(LocalData.class);
            if (localData != null) {
                LocalData.RuleRunnerImpl runner = new LocalData.RuleRunnerImpl();
                this.recipes.add(runner);
                runner.setup((JenkinsRule)this, localData);
                this.tearDowns.add(() -> runner.tearDown(this, localData));
            }
            if ((withPlugin = testMethod.getAnnotation(WithPlugin.class)) != null) {
                WithPlugin.RuleRunnerImpl runner = new WithPlugin.RuleRunnerImpl();
                this.recipes.add(runner);
                runner.setup((JenkinsRule)this, withPlugin);
                this.tearDowns.add(() -> runner.tearDown(this, withPlugin));
            }
            if ((withPluginManager = testMethod.getAnnotation(WithPluginManager.class)) != null) {
                WithPluginManager.RuleRunnerImpl runner = new WithPluginManager.RuleRunnerImpl();
                this.recipes.add(runner);
                runner.setup((JenkinsRule)this, withPluginManager);
                this.tearDowns.add(() -> runner.tearDown(this, withPluginManager));
            }
        }
    }
}

