/*
 * Decompiled with CFR 0.152.
 */
package org.jvnet.hudson.test.junit.jupiter;

import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import hudson.Extension;
import hudson.console.LineTransformationOutputStream;
import hudson.model.Run;
import hudson.model.TaskListener;
import hudson.model.listeners.RunListener;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.OutputStream;
import java.io.PrintStream;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import jenkins.model.Jenkins;
import org.junit.jupiter.api.extension.AfterAllCallback;
import org.junit.jupiter.api.extension.BeforeAllCallback;
import org.junit.jupiter.api.extension.ExtensionContext;
import org.jvnet.hudson.test.DeltaSupportLogFormatter;

public final class BuildWatcherExtension
implements BeforeAllCallback,
AfterAllCallback {
    private static boolean active;
    private static final Map<File, RunningBuild> builds;
    private Thread thread;

    @SuppressFBWarnings(value={"ST_WRITE_TO_STATIC_FROM_INSTANCE_METHOD"})
    public void beforeAll(ExtensionContext extensionContext) throws Exception {
        active = true;
        this.thread = new Thread("watching builds"){

            @Override
            public void run() {
                try {
                    while (active) {
                        for (RunningBuild build : builds.values()) {
                            build.copy();
                        }
                        Thread.sleep(50L);
                    }
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
                for (RunningBuild build : builds.values()) {
                    build.copy();
                }
            }
        };
        this.thread.setDaemon(true);
        this.thread.start();
    }

    @SuppressFBWarnings(value={"ST_WRITE_TO_STATIC_FROM_INSTANCE_METHOD"})
    public void afterAll(ExtensionContext extensionContext) throws Exception {
        active = false;
        this.thread.interrupt();
    }

    static {
        builds = new ConcurrentHashMap<File, RunningBuild>();
    }

    private static final class LogLinePrefixOutputFilter
    extends LineTransformationOutputStream {
        private final PrintStream logger;
        private final String prefix;

        LogLinePrefixOutputFilter(PrintStream logger, String prefix) {
            this.logger = logger;
            this.prefix = prefix;
        }

        protected void eol(byte[] b, int len) throws IOException {
            this.logger.append(DeltaSupportLogFormatter.elapsedTime());
            this.logger.write(32);
            this.logger.append(this.prefix);
            this.logger.write(b, 0, len);
        }
    }

    private static final class RunningBuild {
        private final Run<?, ?> r;
        private final OutputStream sink;
        private long pos;

        RunningBuild(Run<?, ?> r) {
            this.r = r;
            this.sink = new LogLinePrefixOutputFilter(System.err, "[" + String.valueOf(r) + "] ");
        }

        synchronized void copy() {
            block3: {
                try {
                    this.pos = this.r.getLogText().writeLogTo(this.pos, this.sink);
                }
                catch (FileNotFoundException fileNotFoundException) {
                }
                catch (Throwable x) {
                    if (Jenkins.getInstanceOrNull() == null) break block3;
                    x.printStackTrace();
                }
            }
        }
    }

    @Extension
    public static final class Listener
    extends RunListener<Run<?, ?>> {
        public void onStarted(Run<?, ?> r, TaskListener listener) {
            if (!active) {
                return;
            }
            RunningBuild build = new RunningBuild(r);
            RunningBuild orig = builds.put(r.getRootDir(), build);
            if (orig != null) {
                System.err.println(String.valueOf(r) + " was started twice?!");
            }
        }

        public void onFinalized(Run<?, ?> r) {
            if (!active) {
                return;
            }
            RunningBuild build = builds.remove(r.getRootDir());
            if (build != null) {
                build.copy();
            } else {
                System.err.println(String.valueOf(r) + " was finalized but never started; assuming it was started earlier using @LocalData");
                new RunningBuild(r).copy();
            }
        }
    }
}

