/*
 * Decompiled with CFR 0.152.
 */
package org.jvnet.hudson.test.jetty;

import jakarta.servlet.ServletContext;
import java.io.File;
import java.util.function.Supplier;
import org.eclipse.jetty.http.HttpCompliance;
import org.eclipse.jetty.http.UriCompliance;
import org.eclipse.jetty.security.LoginService;
import org.eclipse.jetty.server.Connector;
import org.eclipse.jetty.server.Handler;
import org.eclipse.jetty.server.HttpConfiguration;
import org.eclipse.jetty.server.HttpConnectionFactory;
import org.eclipse.jetty.server.Server;
import org.eclipse.jetty.server.ServerConnector;
import org.eclipse.jetty.server.handler.gzip.GzipHandler;
import org.eclipse.jetty.util.thread.QueuedThreadPool;
import org.eclipse.jetty.util.thread.ThreadPool;

public abstract class JettyProvider {
    protected Server server;

    public abstract Context createWebServer(int var1, String var2, Supplier<LoginService> var3) throws Exception;

    protected final void createServer() {
        QueuedThreadPool qtp = new QueuedThreadPool();
        qtp.setName("Jetty (JenkinsRule)");
        this.server = new Server((ThreadPool)qtp);
    }

    protected final ServerConnector createConnector(int localPort) {
        ServerConnector connector = new ServerConnector(this.server);
        HttpConfiguration config = ((HttpConnectionFactory)connector.getConnectionFactory(HttpConnectionFactory.class)).getHttpConfiguration();
        config.setRequestHeaderSize(12288);
        config.setHttpCompliance(HttpCompliance.RFC7230);
        config.setUriCompliance(UriCompliance.LEGACY);
        connector.setHost("localhost");
        if (System.getProperty("port") != null) {
            connector.setPort(Integer.parseInt(System.getProperty("port")));
        } else if (localPort != 0) {
            connector.setPort(localPort);
        }
        this.server.addConnector((Connector)connector);
        return connector;
    }

    protected final void configureCompression(Handler handler) {
        String compression = System.getProperty("jth.compression", "gzip");
        if (compression.equals("gzip")) {
            GzipHandler gzipHandler = new GzipHandler();
            gzipHandler.setHandler(handler);
            this.server.setHandler((Handler)gzipHandler);
        } else if (compression.equals("none")) {
            this.server.setHandler(handler);
        } else {
            throw new IllegalArgumentException("Unexpected compression scheme: " + compression);
        }
    }

    public record Context(ServletContext servletContext, int localPort, Server server, File explodedWarDir) {
    }
}

