/*
 * Decompiled with CFR 0.152.
 */
package org.jvnet.hudson.test.jetty;

import jakarta.servlet.ServletRequest;
import java.io.File;
import java.util.function.Supplier;
import org.eclipse.jetty.ee10.servlet.ServletContextHandler;
import org.eclipse.jetty.ee10.webapp.WebAppContext;
import org.eclipse.jetty.ee10.websocket.server.config.JettyWebSocketServletContainerInitializer;
import org.eclipse.jetty.security.LoginService;
import org.eclipse.jetty.server.Handler;
import org.eclipse.jetty.server.ServerConnector;
import org.eclipse.jetty.util.component.AbstractLifeCycle;
import org.eclipse.jetty.util.component.Container;
import org.eclipse.jetty.util.resource.ResourceFactory;
import org.jvnet.hudson.test.NoListenerConfiguration2;
import org.jvnet.hudson.test.WarExploder;
import org.jvnet.hudson.test.jetty.JettyProvider;

public final class Jetty12EE10Provider
extends JettyProvider {
    public Jetty12EE10Provider() {
        try {
            ServletRequest.class.getDeclaredMethod("getRequestId", new Class[0]);
        }
        catch (NoSuchMethodException e) {
            NoSuchMethodError error = new NoSuchMethodError();
            error.initCause(e);
            throw error;
        }
    }

    @Override
    public JettyProvider.Context createWebServer(int localPort, String contextPath, Supplier<LoginService> loginServiceSupplier) throws Exception {
        this.createServer();
        File explodedWarDir = WarExploder.getExplodedDir();
        WebAppContext context = new WebAppContext(explodedWarDir.getPath(), contextPath){

            public void preConfigure() throws Exception {
                super.preConfigure();
                this.getServletHandler().setDecodeAmbiguousURIs(true);
            }

            protected ClassLoader configureClassLoader(ClassLoader loader) {
                return loader;
            }
        };
        context.setBaseResource(ResourceFactory.of((Container)context).newResource(explodedWarDir.getPath()));
        context.setClassLoader(this.getClass().getClassLoader());
        context.setConfigurationDiscovered(true);
        context.addBean((Object)new NoListenerConfiguration2((AbstractLifeCycle)context));
        context.setServer(this.server);
        context.getSecurityHandler().setLoginService(loginServiceSupplier.get());
        JettyWebSocketServletContainerInitializer.configure((ServletContextHandler)context, null);
        this.configureCompression((Handler)context);
        ServerConnector connector = this.createConnector(localPort);
        this.server.start();
        return new JettyProvider.Context(context.getServletContext(), connector.getLocalPort(), this.server, explodedWarDir);
    }
}

