/*
 * Decompiled with CFR 0.152.
 */
package org.jvnet.hudson.test;

import hudson.PluginManager;
import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.lang.reflect.Method;
import java.net.URISyntaxException;
import java.net.URL;
import java.nio.charset.StandardCharsets;
import java.util.Collection;
import java.util.HashSet;
import java.util.Set;
import java.util.jar.Manifest;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.servlet.ServletContext;
import org.apache.commons.io.FileUtils;
import org.junit.Assert;
import org.jvnet.hudson.test.WarExploder;

public class UnitTestSupportingPluginManager
extends PluginManager {
    private static final Logger LOGGER = Logger.getLogger(UnitTestSupportingPluginManager.class.getName());

    public UnitTestSupportingPluginManager(File rootDir) {
        super((ServletContext)null, rootDir);
    }

    protected Collection<String> loadBundledPlugins() throws Exception {
        try {
            Set<String> set = this.loadBundledPlugins(new File(WarExploder.getExplodedDir(), "WEB-INF/plugins"));
            return set;
        }
        finally {
            try {
                Method loadDetachedPlugins = PluginManager.class.getDeclaredMethod("loadDetachedPlugins", new Class[0]);
                loadDetachedPlugins.setAccessible(true);
                loadDetachedPlugins.invoke((Object)this, new Object[0]);
            }
            catch (NoSuchMethodException noSuchMethodException) {}
        }
    }

    private Set<String> loadBundledPlugins(File fromDir) throws IOException, URISyntaxException {
        URL index;
        HashSet<String> names = new HashSet<String>();
        File[] children = fromDir.listFiles();
        if (children != null) {
            for (File child : children) {
                try {
                    names.add(child.getName());
                    this.copyBundledPlugin(child.toURI().toURL(), child.getName());
                }
                catch (IOException e) {
                    LOGGER.log(Level.SEVERE, "Failed to extract the bundled plugin " + String.valueOf(child), e);
                }
            }
        } else {
            LOGGER.log(Level.FINE, "No plugins loaded from {0}. Directory does not exist.", fromDir);
        }
        URL u = ((Object)((Object)this)).getClass().getClassLoader().getResource("the.jpl");
        if (u == null) {
            u = ((Object)((Object)this)).getClass().getClassLoader().getResource("the.hpl");
        }
        if (u != null) {
            try {
                String thisPlugin;
                try (InputStream is = u.openStream();){
                    thisPlugin = new Manifest(is).getMainAttributes().getValue("Short-Name");
                }
                if (thisPlugin == null) {
                    throw new IOException("malformed " + String.valueOf(u));
                }
                names.add(thisPlugin + ".jpl");
                this.copyBundledPlugin(u, thisPlugin + ".jpl");
            }
            catch (IOException e) {
                LOGGER.log(Level.SEVERE, "Failed to copy the.jpl", e);
            }
        }
        if ((index = ((Object)((Object)this)).getClass().getResource("/test-dependencies/index")) != null) {
            try (BufferedReader r = new BufferedReader(new InputStreamReader(index.openStream(), StandardCharsets.UTF_8));){
                String line;
                while ((line = r.readLine()) != null) {
                    File f;
                    URL url = new URL(index, line + ".jpi");
                    try {
                        f = new File(url.toURI());
                    }
                    catch (IllegalArgumentException x) {
                        if (x.getMessage().equals("URI is not hierarchical")) {
                            throw new IOException("You are probably trying to load plugins from within a jarfile (not possible). If you are running this in your IDE and see this message, it is likely that you have a clean target directory. Try running 'mvn test-compile' from the command line (once only), which will copy the required plugins into target/test-classes/test-dependencies - then retry your test", x);
                        }
                        throw new IOException(String.valueOf(index) + " contains bogus line " + line, x);
                    }
                    if (f.exists()) {
                        this.copyBundledPlugin(url, line + ".jpi");
                        continue;
                    }
                    this.copyBundledPlugin(new URL(index, line + ".hpi"), line + ".jpi");
                }
            }
        }
        return names;
    }

    public void installDetachedPlugin(String shortName) throws Exception {
        URL r = UnitTestSupportingPluginManager.class.getClassLoader().getResource("WEB-INF/detached-plugins/" + shortName + ".hpi");
        Assert.assertNotNull((String)("could not find " + shortName), (Object)r);
        File f = new File(this.rootDir, shortName + ".hpi");
        FileUtils.copyURLToFile((URL)r, (File)f);
        this.dynamicLoad(f);
    }
}

