/*
 * Decompiled with CFR 0.152.
 */
package org.jvnet.hudson.test;

import java.io.File;
import java.io.IOException;
import java.nio.file.DirectoryNotEmptyException;
import java.nio.file.DirectoryStream;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.HashSet;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.stream.Collectors;
import java.util.stream.Stream;

public class TemporaryDirectoryAllocator {
    private static final Logger LOGGER = Logger.getLogger(TemporaryDirectoryAllocator.class.getName());
    private final Set<File> tmpDirectories = new HashSet<File>();
    private final File base;
    private final boolean withoutSpace = Boolean.getBoolean("jenkins.test.noSpaceInTmpDirs");

    @Deprecated
    public TemporaryDirectoryAllocator(File base) {
        this.base = base;
    }

    public TemporaryDirectoryAllocator() {
        this.base = new File(System.getProperty("java.io.tmpdir"));
        this.base.mkdirs();
    }

    public File allocate() throws IOException {
        return this.allocate(this.withoutSpace ? "jkh" : "j h");
    }

    public synchronized File allocate(String name) throws IOException {
        try {
            File f = Files.createTempDirectory(this.base.toPath(), name, new FileAttribute[0]).toFile();
            this.tmpDirectories.add(f);
            return f;
        }
        catch (IOException e) {
            throw new IOException("Failed to create a temporary directory in " + String.valueOf(this.base), e);
        }
    }

    public synchronized void dispose() throws IOException, InterruptedException {
        for (File dir : this.tmpDirectories) {
            LOGGER.info(() -> "deleting " + String.valueOf(dir));
            this.delete(dir.toPath());
        }
        this.tmpDirectories.clear();
    }

    public synchronized void disposeAsync() {
        final HashSet<File> tbr = new HashSet<File>(this.tmpDirectories);
        this.tmpDirectories.clear();
        new Thread("Disposing " + String.valueOf(this.base)){

            @Override
            public void run() {
                for (File dir : tbr) {
                    LOGGER.info(() -> "deleting " + String.valueOf(dir));
                    try {
                        TemporaryDirectoryAllocator.this.delete(dir.toPath());
                    }
                    catch (IOException e) {
                        LOGGER.log(Level.WARNING, null, e);
                    }
                }
            }
        }.start();
    }

    private void delete(Path p) throws IOException {
        LOGGER.fine(() -> "deleting " + String.valueOf(p));
        if (Files.isDirectory(p, LinkOption.NOFOLLOW_LINKS)) {
            try (DirectoryStream<Path> children = Files.newDirectoryStream(p);){
                for (Path child : children) {
                    this.delete(child);
                }
            }
        }
        try {
            if (this.isWindows()) {
                boolean ok = p.toFile().setWritable(true);
                LOGGER.fine(() -> "allow write to " + String.valueOf(p) + ", result: " + ok);
            }
            Files.deleteIfExists(p);
        }
        catch (DirectoryNotEmptyException x) {
            try (Stream<Path> children = Files.list(p);){
                x.addSuppressed(new IOException("These files still exist : " + children.map(p::relativize).map(Path::toString).collect(Collectors.joining(", "))));
            }
            throw x;
        }
    }

    private boolean isWindows() {
        return File.pathSeparatorChar == ';';
    }
}

