/*
 * Decompiled with CFR 0.152.
 */
package org.jvnet.hudson.test;

import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import hudson.console.PlainTextConsoleOutputStream;
import hudson.model.Run;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.PrintStream;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileTime;
import java.time.Duration;
import java.util.concurrent.Semaphore;
import java.util.concurrent.TimeUnit;
import org.apache.commons.io.input.Tailer;
import org.apache.commons.io.input.TailerListener;
import org.apache.commons.io.input.TailerListenerAdapter;
import org.junit.Assert;
import org.jvnet.hudson.test.DeltaSupportLogFormatter;
import org.jvnet.hudson.test.JenkinsRule;
import org.jvnet.hudson.test.PrefixedOutputStream;
import org.jvnet.hudson.test.RealJenkinsRule;
import org.jvnet.hudson.test.junit.jupiter.RealJenkinsExtension;

@SuppressFBWarnings(value={"PATH_TRAVERSAL_IN"}, justification="irrelevant")
public final class TailLog
implements AutoCloseable {
    private final Semaphore finished = new Semaphore(0);
    private final Tailer tailer;
    private final PrefixedOutputStream.Builder prefixedOutputStreamBuilder = PrefixedOutputStream.builder();

    public TailLog(Run<?, ?> b) {
        this(b.getRootDir(), b.getParent().getFullName(), b.getNumber());
    }

    public TailLog(JenkinsRule jr, String job, int number) {
        this(TailLog.runRootDir(jr.jenkins.getRootDir(), job, number), job, number);
    }

    public TailLog(RealJenkinsRule rjr, String job, int number) {
        this(TailLog.runRootDir(rjr.getHome(), job, number), job, number);
    }

    public TailLog(RealJenkinsExtension rje, String job, int number) {
        this(TailLog.runRootDir(rje.getHome(), job, number), job, number);
    }

    private static File runRootDir(File home, String job, int number) {
        return new File(home, "jobs/" + job.replace("/", "/jobs/") + "/builds/" + number);
    }

    public TailLog withColor(PrefixedOutputStream.AnsiColor color) {
        this.prefixedOutputStreamBuilder.withColor(color);
        return this;
    }

    public TailLog(File buildDirectory, final String job, final int number) {
        final Path log = buildDirectory.toPath().resolve("log");
        this.tailer = Tailer.builder().setDelayDuration(Duration.ofMillis(50L)).setTailable(new Tailer.Tailable(){

            public long size() throws IOException {
                return Files.size(log);
            }

            public FileTime lastModifiedFileTime() throws IOException {
                return Files.getLastModifiedTime(log, new LinkOption[0]);
            }

            public boolean isNewer(FileTime fileTime) throws IOException {
                return Files.getLastModifiedTime(log, new LinkOption[0]).compareTo(fileTime) > 0;
            }

            public Tailer.RandomAccessResourceBridge getRandomAccess(String mode) throws FileNotFoundException {
                if (!Files.isRegularFile(log, new LinkOption[0])) {
                    throw new FileNotFoundException(log.toString());
                }
                return new Tailer.RandomAccessResourceBridge(){
                    long ptr;

                    public long getPointer() throws IOException {
                        return this.ptr;
                    }

                    public void seek(long pos) throws IOException {
                        this.ptr = pos;
                    }

                    public int read(byte[] b) throws IOException {
                        try (InputStream is = Files.newInputStream(log, new OpenOption[0]);){
                            is.skipNBytes(this.ptr);
                            int r = is.read(b);
                            if (r > 0) {
                                this.ptr += (long)r;
                            }
                            int n = r;
                            return n;
                        }
                    }

                    public void close() throws IOException {
                    }
                };
            }
        }).setTailerListener((TailerListener)new TailerListenerAdapter(){
            PrintStream ps;

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void handle(String line) {
                if (this.ps == null) {
                    this.ps = new PrintStream((OutputStream)new PlainTextConsoleOutputStream(TailLog.this.prefixedOutputStreamBuilder.withName(job + "#" + number).build(System.err)), false, StandardCharsets.UTF_8);
                }
                PrintStream printStream = System.err;
                synchronized (printStream) {
                    this.ps.append(DeltaSupportLogFormatter.elapsedTime());
                    this.ps.print(' ');
                    this.ps.print(line);
                    this.ps.println();
                    this.ps.flush();
                }
                if (line.startsWith("Finished: ")) {
                    TailLog.this.finished.release();
                }
            }
        }).get();
    }

    public void waitForCompletion() throws InterruptedException {
        Assert.assertTrue((boolean)this.finished.tryAcquire(1L, TimeUnit.MINUTES));
    }

    @Override
    public void close() {
        this.tailer.close();
    }
}

