/*
 * Decompiled with CFR 0.152.
 */
package org.jvnet.hudson.test;

import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import hudson.AbortException;
import hudson.EnvVars;
import hudson.Extension;
import hudson.Util;
import hudson.model.Descriptor;
import hudson.model.Slave;
import hudson.model.TaskListener;
import hudson.slaves.ComputerLauncher;
import hudson.slaves.SlaveComputer;
import hudson.util.ProcessTree;
import hudson.util.StreamCopyThread;
import java.io.OutputStream;
import java.util.HashMap;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.kohsuke.stapler.DataBoundConstructor;

public class SimpleCommandLauncher
extends ComputerLauncher {
    private static final Logger LOGGER = Logger.getLogger(SimpleCommandLauncher.class.getName());
    public final String cmd;
    private final Map<String, String> env;
    private transient Process proc;
    private transient EnvVars cookie;

    @DataBoundConstructor
    public SimpleCommandLauncher(String cmd) {
        this(cmd, null);
    }

    SimpleCommandLauncher(String cmd, EnvVars env) {
        this.cmd = cmd;
        this.env = env != null ? new HashMap(env) : null;
    }

    public void launch(SlaveComputer computer, TaskListener listener) {
        try {
            Slave node = computer.getNode();
            if (node == null) {
                throw new AbortException("Cannot launch commands on deleted nodes");
            }
            listener.getLogger().println("$ " + this.cmd);
            ProcessBuilder pb = new ProcessBuilder(Util.tokenize((String)this.cmd));
            this.cookie = EnvVars.createCookie();
            pb.environment().putAll((Map<String, String>)this.cookie);
            if (this.env != null) {
                pb.environment().putAll(this.env);
            }
            this.proc = pb.start();
            new StreamCopyThread("stderr copier for remote agent on " + computer.getDisplayName(), this.proc.getErrorStream(), (OutputStream)listener.getLogger()).start();
            computer.setChannel(this.proc.getInputStream(), this.proc.getOutputStream(), listener, null);
            LOGGER.log(Level.INFO, "agent launched for {0}", computer.getName());
        }
        catch (Exception x) {
            LOGGER.log(Level.WARNING, null, x);
        }
    }

    @SuppressFBWarnings(value={"IS2_INCONSISTENT_SYNC"}, justification="test code, close enough")
    public synchronized void afterDisconnect(SlaveComputer computer, TaskListener listener) {
        if (this.proc != null) {
            try {
                ProcessTree.get().killAll(this.proc, (Map)this.cookie);
                LOGGER.info(() -> "killed " + String.valueOf(this.proc) + " with " + String.valueOf(this.cookie) + " for " + computer.getName());
            }
            catch (Exception x) {
                LOGGER.log(Level.WARNING, "failed to kill " + String.valueOf(this.proc) + " with " + String.valueOf(this.cookie) + " for " + computer.getName(), x);
            }
            this.proc = null;
            this.cookie = null;
        } else {
            LOGGER.info(() -> "no process for " + computer.getName());
        }
    }

    @Extension
    public static class DescriptorImpl
    extends Descriptor<ComputerLauncher> {
    }
}

