/*
 * Decompiled with CFR 0.152.
 */
package org.jvnet.hudson.test;

import hudson.Extension;
import hudson.model.Action;
import hudson.model.InvisibleAction;
import hudson.model.Run;
import java.io.IOException;
import java.util.Collection;
import java.util.Set;
import java.util.concurrent.Callable;
import java.util.logging.Level;
import java.util.logging.Logger;
import jenkins.model.RunAction2;
import jenkins.model.TransientActionFactory;
import jenkins.model.lazy.LazyBuildMixIn;
import org.kohsuke.accmod.Restricted;
import org.kohsuke.accmod.restrictions.NoExternalUse;

public final class RunLoadCounter {
    private static final Logger LOGGER = Logger.getLogger(RunLoadCounter.class.getName());
    private static LazyBuildMixIn.LazyLoadingJob<?, ?> currProject;
    private static int currCount;
    private static int maxCount;

    @Deprecated
    public static void prepare(LazyBuildMixIn.LazyLoadingJob<?, ?> project) throws IOException {
    }

    public static int countLoads(LazyBuildMixIn.LazyLoadingJob<?, ?> project, Runnable thunk) {
        project.getLazyBuildMixIn()._getRuns().purgeCache();
        currProject = project;
        currCount = 0;
        maxCount = Integer.MAX_VALUE;
        try {
            LOGGER.info("Starting load count");
            thunk.run();
            int n = currCount;
            return n;
        }
        finally {
            LOGGER.info("Ending load count");
            currProject = null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static <T> T assertMaxLoads(LazyBuildMixIn.LazyLoadingJob<?, ?> project, int max, Callable<T> thunk) throws Exception {
        project.getLazyBuildMixIn()._getRuns().purgeCache();
        currProject = project;
        currCount = 0;
        maxCount = max;
        try {
            LOGGER.info("Starting load count");
            T t = thunk.call();
            return t;
        }
        finally {
            LOGGER.info("Ending load count");
            currProject = null;
        }
    }

    private RunLoadCounter() {
    }

    @Restricted(value={NoExternalUse.class})
    @Extension
    public static final class MarkerAdder
    extends TransientActionFactory<Run<?, ?>> {
        public Class<Run<?, ?>> type() {
            return Run.class;
        }

        public Collection<? extends Action> createFor(Run<?, ?> target) {
            return Set.of(new Marker());
        }
    }

    @Restricted(value={NoExternalUse.class})
    public static final class Marker
    extends InvisibleAction
    implements RunAction2 {
        public void onLoad(Run<?, ?> run) {
            if (run.getParent().equals(currProject)) {
                if (++currCount > maxCount) {
                    throw new AssertionError((Object)("More than " + maxCount + " build records loaded: " + String.valueOf(run)));
                }
                LOGGER.log(Level.WARNING, "Loaded " + String.valueOf(run) + " (" + currCount + " \u2264 " + maxCount + ")", new Throwable());
            }
        }

        public void onAttached(Run r) {
        }
    }
}

