/*
 * Decompiled with CFR 0.152.
 */
package org.jvnet.hudson.test;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.nio.ByteBuffer;
import java.nio.charset.CharacterCodingException;
import java.nio.charset.Charset;
import java.nio.charset.CharsetDecoder;
import java.nio.charset.CodingErrorAction;
import java.nio.charset.StandardCharsets;
import java.util.Map;
import java.util.Properties;
import java.util.PropertyResourceBundle;
import junit.framework.Test;
import junit.framework.TestCase;
import junit.framework.TestSuite;
import org.jvnet.hudson.test.JellyTestSuiteBuilder;

public class PropertiesTestSuite
extends TestSuite {
    public PropertiesTestSuite(File resources) throws IOException {
        for (Map.Entry<URL, String> entry : JellyTestSuiteBuilder.scan(resources, "properties").entrySet()) {
            this.addTest((Test)new PropertiesTest(entry.getKey(), entry.getValue()));
        }
    }

    private static boolean isEncoded(byte[] bytes, Charset charset) {
        CharsetDecoder decoder = charset.newDecoder();
        decoder.onMalformedInput(CodingErrorAction.REPORT);
        decoder.onUnmappableCharacter(CodingErrorAction.REPORT);
        ByteBuffer buffer = ByteBuffer.wrap(bytes);
        try {
            decoder.decode(buffer);
            return true;
        }
        catch (CharacterCodingException e) {
            return false;
        }
    }

    private static class PropertiesTest
    extends TestCase {
        private final URL resource;

        private PropertiesTest(URL resource, String name) {
            super(name);
            this.resource = resource;
        }

        protected void runTest() throws Throwable {
            Properties props = new Properties(){

                @Override
                public synchronized Object put(Object key, Object value) {
                    Object old = super.put(key, value);
                    if (old != null) {
                        throw new AssertionError((Object)("Two values for `" + String.valueOf(key) + "` (`" + String.valueOf(old) + "` vs. `" + String.valueOf(value) + "`) in " + String.valueOf(resource)));
                    }
                    return null;
                }
            };
            try (InputStream is = this.resource.openStream();){
                byte[] contents = is.readAllBytes();
                if (!PropertiesTestSuite.isEncoded(contents, StandardCharsets.US_ASCII)) {
                    boolean isUtf8 = PropertiesTestSuite.isEncoded(contents, StandardCharsets.UTF_8);
                    boolean isIso88591 = PropertiesTestSuite.isEncoded(contents, StandardCharsets.ISO_8859_1);
                    if (!isUtf8 && !isIso88591) {
                        throw new AssertionError((Object)(String.valueOf(this.resource) + " must be either valid UTF-8 or valid ISO-8859-1."));
                    }
                }
            }
            is = this.resource.openStream();
            try {
                PropertyResourceBundle propertyResourceBundle = new PropertyResourceBundle(is);
                propertyResourceBundle.getKeys().asIterator().forEachRemaining(key -> props.setProperty((String)key, propertyResourceBundle.getString((String)key)));
            }
            finally {
                if (is != null) {
                    is.close();
                }
            }
        }
    }
}

