/*
 * Decompiled with CFR 0.152.
 */
package org.jvnet.hudson.test;

import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.jar.Attributes;
import java.util.jar.JarEntry;
import java.util.jar.JarOutputStream;
import java.util.jar.Manifest;
import org.jvnet.hudson.test.RealJenkinsRuleInit;

public class PluginUtils {
    public static File createRealJenkinsExtensionPlugin(File destinationDirectory, String baseline) throws IOException {
        return PluginUtils.createRealJenkinsPlugin("RealJenkinsExtension", destinationDirectory, baseline);
    }

    static File createRealJenkinsRulePlugin(File destinationDirectory, String baseline) throws IOException {
        return PluginUtils.createRealJenkinsPlugin("RealJenkinsRule", destinationDirectory, baseline);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SuppressFBWarnings(value={"PATH_TRAVERSAL_IN"}, justification="jth is a test utility, this is package scope code")
    static File createRealJenkinsPlugin(String target, File destinationDirectory, String baseline) throws IOException {
        Class<RealJenkinsRuleInit> pluginClass = RealJenkinsRuleInit.class;
        Manifest mf = new Manifest();
        Attributes mainAttributes = mf.getMainAttributes();
        mainAttributes.put(Attributes.Name.MANIFEST_VERSION, "1.0");
        mainAttributes.putValue("Plugin-Class", pluginClass.getName());
        mainAttributes.putValue("Extension-Name", pluginClass.getSimpleName());
        mainAttributes.putValue("Short-Name", pluginClass.getSimpleName());
        mainAttributes.putValue("Long-Name", target + " initialization wrapper");
        mainAttributes.putValue("Plugin-Version", "0-SNAPSHOT (private rj)");
        mainAttributes.putValue("Support-Dynamic-Loading", "true");
        mainAttributes.putValue("Jenkins-Version", baseline);
        mainAttributes.putValue("Init-Target", target);
        Path tmpClassesJar = Files.createTempFile("rjr", "jar", new FileAttribute[0]);
        try {
            try (FileOutputStream fos = new FileOutputStream(tmpClassesJar.toFile());
                 JarOutputStream classesJarOS = new JarOutputStream((OutputStream)fos, mf);
                 InputStream classIS = pluginClass.getResourceAsStream(pluginClass.getSimpleName() + ".class");){
                String path = pluginClass.getPackageName().replace('.', '/');
                PluginUtils.createJarEntry(classesJarOS, path + "/" + pluginClass.getSimpleName() + ".class", classIS);
            }
            File jpi = new File(destinationDirectory, pluginClass.getSimpleName() + ".jpi");
            try (FileOutputStream fos = new FileOutputStream(jpi);
                 JarOutputStream jos = new JarOutputStream((OutputStream)fos, mf);
                 FileInputStream fis = new FileInputStream(tmpClassesJar.toFile());){
                PluginUtils.createJarEntry(jos, "WEB-INF/lib/" + pluginClass.getSimpleName() + ".jar", fis);
            }
            File file = jpi;
            return file;
        }
        finally {
            Files.delete(tmpClassesJar);
        }
    }

    private static void createJarEntry(JarOutputStream jos, String entryName, InputStream data) throws IOException {
        JarEntry je = new JarEntry(entryName);
        jos.putNextEntry(je);
        data.transferTo(jos);
        jos.closeEntry();
    }
}

