/*
 * Decompiled with CFR 0.152.
 */
package org.jvnet.hudson.test;

import edu.umd.cs.findbugs.annotations.CheckForNull;
import edu.umd.cs.findbugs.annotations.NonNull;
import java.util.List;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.LogRecord;
import java.util.logging.Logger;
import org.hamcrest.Description;
import org.hamcrest.Matcher;
import org.hamcrest.TypeSafeMatcher;
import org.junit.rules.ExternalResource;
import org.jvnet.hudson.test.LogRecorder;

public class LoggerRule
extends ExternalResource {
    private final LogRecorder recorder = new LogRecorder();

    public LoggerRule quiet() {
        this.recorder.quiet();
        return this;
    }

    public String toString() {
        return this.recorder.toString();
    }

    public LoggerRule capture(int maximum) {
        this.recorder.capture(maximum);
        return this;
    }

    public LoggerRule record(Logger logger, Level level) {
        this.recorder.record(logger, level);
        return this;
    }

    public LoggerRule record(String name, Level level) {
        this.recorder.record(Logger.getLogger(name), level);
        return this;
    }

    public LoggerRule record(Class<?> clazz, Level level) {
        this.recorder.record(clazz.getName(), level);
        return this;
    }

    public LoggerRule recordPackage(Class<?> clazz, Level level) {
        this.recorder.record(clazz.getPackage().getName(), level);
        return this;
    }

    Map<String, Level> getRecordedLevels() {
        return this.recorder.getRecordedLevels();
    }

    public List<LogRecord> getRecords() {
        return this.recorder.getRecords();
    }

    public List<String> getMessages() {
        return this.recorder.getMessages();
    }

    protected void after() {
        this.recorder.close();
    }

    public static Matcher<LoggerRule> recorded(final @CheckForNull Level level, final @NonNull Matcher<String> message, final @CheckForNull Matcher<Throwable> thrown) {
        return new TypeSafeMatcher<LoggerRule>(){
            private final LogRecorder.RecordedMatcher matcher;
            {
                this.matcher = new LogRecorder.RecordedMatcher(level, (Matcher<String>)message, (Matcher<Throwable>)thrown);
            }

            public void describeTo(Description description) {
                this.matcher.describeTo(description);
            }

            protected boolean matchesSafely(LoggerRule loggerRule) {
                return this.matcher.matches(loggerRule.recorder);
            }
        };
    }

    public static Matcher<LoggerRule> recorded(@CheckForNull Level level, @NonNull Matcher<String> message) {
        return LoggerRule.recorded(level, message, null);
    }

    public static Matcher<LoggerRule> recorded(@NonNull Matcher<String> message, @CheckForNull Matcher<Throwable> thrown) {
        return LoggerRule.recorded(null, message, thrown);
    }

    public static Matcher<LoggerRule> recorded(@NonNull Matcher<String> message) {
        return LoggerRule.recorded(null, message, null);
    }
}

