/*
 * Decompiled with CFR 0.152.
 */
package org.jvnet.hudson.test;

import edu.umd.cs.findbugs.annotations.CheckForNull;
import edu.umd.cs.findbugs.annotations.NonNull;
import hudson.util.RingBufferLogHandler;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.logging.ConsoleHandler;
import java.util.logging.Formatter;
import java.util.logging.Handler;
import java.util.logging.Level;
import java.util.logging.LogRecord;
import java.util.logging.Logger;
import java.util.logging.SimpleFormatter;
import java.util.stream.Collectors;
import org.hamcrest.Description;
import org.hamcrest.Matcher;
import org.hamcrest.TypeSafeMatcher;
import org.jvnet.hudson.test.DeltaSupportLogFormatter;

public class LogRecorder
implements AutoCloseable {
    private final Handler consoleHandler = new ConsoleHandlerWithMaxLevel();
    private final Map<Logger, Level> loggers = new HashMap<Logger, Level>();
    private RingBufferLogHandler ringHandler;
    private List<String> messages;
    private boolean verbose = true;

    public LogRecorder() {
        this.consoleHandler.setFormatter((Formatter)((Object)new DeltaSupportLogFormatter()));
        this.consoleHandler.setLevel(Level.ALL);
    }

    public LogRecorder quiet() {
        this.verbose = false;
        return this;
    }

    public String toString() {
        return this.getRecords().stream().map(logRecord -> logRecord.getLevel().toString() + "->" + logRecord.getMessage()).collect(Collectors.joining(","));
    }

    public LogRecorder capture(int maximum) {
        this.messages = new ArrayList<String>();
        this.ringHandler = new RingBufferLogHandler(maximum){
            final Formatter f;
            {
                this.f = new SimpleFormatter();
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public synchronized void publish(LogRecord record) {
                super.publish(record);
                String message = this.f.formatMessage(record);
                Throwable x = record.getThrown();
                List<String> list = LogRecorder.this.messages;
                synchronized (list) {
                    LogRecorder.this.messages.add(message == null && x != null ? x.toString() : message);
                }
            }
        };
        this.ringHandler.setLevel(Level.ALL);
        for (Logger logger : this.loggers.keySet()) {
            logger.addHandler((Handler)this.ringHandler);
        }
        return this;
    }

    public LogRecorder record(Logger logger, Level level) {
        this.loggers.put(logger, logger.getLevel());
        logger.setLevel(level);
        if (this.verbose) {
            logger.addHandler(this.consoleHandler);
        }
        if (this.ringHandler != null) {
            logger.addHandler((Handler)this.ringHandler);
        }
        return this;
    }

    public LogRecorder record(String name, Level level) {
        return this.record(Logger.getLogger(name), level);
    }

    public LogRecorder record(Class<?> clazz, Level level) {
        return this.record(clazz.getName(), level);
    }

    public LogRecorder recordPackage(Class<?> clazz, Level level) {
        return this.record(clazz.getPackage().getName(), level);
    }

    Map<String, Level> getRecordedLevels() {
        return this.loggers.keySet().stream().collect(Collectors.toMap(Logger::getName, Logger::getLevel));
    }

    public List<LogRecord> getRecords() {
        return this.ringHandler.getView();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<String> getMessages() {
        List<String> list = this.messages;
        synchronized (list) {
            return List.copyOf(this.messages);
        }
    }

    @Override
    public void close() {
        for (Map.Entry<Logger, Level> entry : this.loggers.entrySet()) {
            Logger logger = entry.getKey();
            logger.setLevel(entry.getValue());
            if (this.verbose) {
                logger.removeHandler(this.consoleHandler);
            }
            if (this.ringHandler == null) continue;
            logger.removeHandler((Handler)this.ringHandler);
        }
        this.loggers.clear();
        if (this.ringHandler != null) {
            this.ringHandler.clear();
            this.messages.clear();
        }
    }

    public static Matcher<LogRecorder> recorded(@CheckForNull Level level, @NonNull Matcher<String> message, @CheckForNull Matcher<Throwable> thrown) {
        return new RecordedMatcher(level, message, thrown);
    }

    public static Matcher<LogRecorder> recorded(@CheckForNull Level level, @NonNull Matcher<String> message) {
        return LogRecorder.recorded(level, message, null);
    }

    public static Matcher<LogRecorder> recorded(@NonNull Matcher<String> message, @CheckForNull Matcher<Throwable> thrown) {
        return LogRecorder.recorded(null, message, thrown);
    }

    public static Matcher<LogRecorder> recorded(@NonNull Matcher<String> message) {
        return LogRecorder.recorded(null, message);
    }

    private static class ConsoleHandlerWithMaxLevel
    extends ConsoleHandler {
        private final Level initialLevel = this.getLevel();

        @Override
        public void publish(LogRecord record) {
            if (record.getLevel().intValue() < this.initialLevel.intValue()) {
                super.publish(record);
            }
        }
    }

    static class RecordedMatcher
    extends TypeSafeMatcher<LogRecorder> {
        @CheckForNull
        Level level;
        @NonNull
        Matcher<String> message;
        @CheckForNull
        Matcher<Throwable> thrown;

        public RecordedMatcher(@CheckForNull Level level, @NonNull Matcher<String> message, @CheckForNull Matcher<Throwable> thrown) {
            this.level = level;
            this.message = message;
            this.thrown = thrown;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        protected boolean matchesSafely(LogRecorder item) {
            LogRecorder logRecorder = item;
            synchronized (logRecorder) {
                for (LogRecord record : item.getRecords()) {
                    if (this.level != null && record.getLevel() != this.level || !this.message.matches((Object)record.getMessage())) continue;
                    if (this.thrown != null) {
                        if (!this.thrown.matches((Object)record.getThrown())) continue;
                        return true;
                    }
                    return true;
                }
            }
            return false;
        }

        public void describeTo(Description description) {
            description.appendText("has LogRecord");
            if (this.level != null) {
                description.appendText(" with level ");
                description.appendValue((Object)this.level.getName());
            }
            description.appendText(" with a message matching ");
            description.appendDescriptionOf(this.message);
            if (this.thrown != null) {
                description.appendText(" with an exception matching ");
                description.appendDescriptionOf(this.thrown);
            }
        }
    }
}

