/*
 * Decompiled with CFR 0.152.
 */
package org.jvnet.hudson.test;

import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import hudson.Util;
import jakarta.servlet.Servlet;
import jakarta.servlet.ServletException;
import jakarta.servlet.ServletRequest;
import jakarta.servlet.http.HttpServlet;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URL;
import java.nio.file.AtomicMoveNotSupportedException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.StandardCopyOption;
import java.nio.file.attribute.FileAttribute;
import java.util.function.Supplier;
import org.eclipse.jetty.ee10.servlet.ServletContextHandler;
import org.eclipse.jetty.ee9.servlet.ServletHolder;
import org.eclipse.jetty.server.Connector;
import org.eclipse.jetty.server.Handler;
import org.eclipse.jetty.server.Server;
import org.eclipse.jetty.server.ServerConnector;
import org.eclipse.jetty.util.thread.QueuedThreadPool;
import org.eclipse.jetty.util.thread.ThreadPool;

public class JavaNetReverseProxy2
extends HttpServlet {
    private final Server server;
    public final int localPort;
    private final File cacheFolder;
    private static volatile JavaNetReverseProxy2 INSTANCE;

    public JavaNetReverseProxy2(File cacheFolder) throws Exception {
        this.cacheFolder = cacheFolder;
        cacheFolder.mkdirs();
        QueuedThreadPool qtp = new QueuedThreadPool();
        qtp.setName("Jetty (JavaNetReverseProxy)");
        this.server = new Server((ThreadPool)qtp);
        if (JavaNetReverseProxy2._isEE10Plus()) {
            context = new ServletContextHandler();
            context.addServlet(new org.eclipse.jetty.ee10.servlet.ServletHolder((Servlet)this), "/");
            this.server.setHandler((Handler)context);
        } else {
            context = new org.eclipse.jetty.ee9.servlet.ServletContextHandler();
            context.addServlet(new ServletHolder((Servlet)this), "/");
            this.server.setHandler((Supplier)context);
        }
        ServerConnector connector = new ServerConnector(this.server);
        this.server.addConnector((Connector)connector);
        this.server.start();
        this.localPort = connector.getLocalPort();
    }

    public void stop() throws Exception {
        this.server.stop();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SuppressFBWarnings(value={"URLCONNECTION_SSRF_FD"}, justification="TODO needs triage")
    protected void service(HttpServletRequest req, HttpServletResponse resp) throws ServletException, IOException {
        Path parent = this.cacheFolder.toPath();
        Files.createDirectories(parent, new FileAttribute[0]);
        String path = req.getServletPath();
        String d = Util.getDigestOf((String)path);
        Path cache = parent.resolve(d);
        if (!Files.exists(cache, new LinkOption[0])) {
            Path tmp = Files.createTempFile(parent, d, null, new FileAttribute[0]);
            try {
                URL url = new URL("https://updates.jenkins.io/" + path);
                try (InputStream is = url.openStream();){
                    Files.copy(is, tmp, StandardCopyOption.REPLACE_EXISTING);
                }
                try {
                    Files.move(tmp, cache, StandardCopyOption.ATOMIC_MOVE);
                }
                catch (AtomicMoveNotSupportedException e) {
                    try {
                        Files.move(tmp, cache, StandardCopyOption.REPLACE_EXISTING);
                    }
                    catch (IOException e2) {
                        e2.addSuppressed(e);
                        throw e2;
                    }
                }
            }
            finally {
                Files.deleteIfExists(tmp);
            }
        }
        resp.setContentType(this.getMimeType(path));
        Files.copy(cache, (OutputStream)resp.getOutputStream());
    }

    private String getMimeType(String path) {
        int idx = path.indexOf(63);
        if (idx >= 0) {
            path = path.substring(0, idx);
        }
        if (path.endsWith(".json")) {
            return "text/javascript";
        }
        return this.getServletContext().getMimeType(path);
    }

    public static synchronized JavaNetReverseProxy2 getInstance() throws Exception {
        if (INSTANCE == null) {
            INSTANCE = new JavaNetReverseProxy2(new File(new File(System.getProperty("java.io.tmpdir")), "jenkins.io-cache2"));
        }
        return INSTANCE;
    }

    private static boolean _isEE10Plus() {
        try {
            ServletRequest.class.getDeclaredMethod("getRequestId", new Class[0]);
            return true;
        }
        catch (NoSuchMethodException e) {
            return false;
        }
    }
}

