/*
 * Decompiled with CFR 0.152.
 */
package org.jvnet.hudson.test;

import edu.umd.cs.findbugs.annotations.CheckForNull;
import edu.umd.cs.findbugs.annotations.NonNull;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import hudson.model.Computer;
import hudson.model.Descriptor;
import hudson.model.Node;
import hudson.model.Slave;
import hudson.remoting.Callable;
import hudson.remoting.VirtualChannel;
import hudson.slaves.ComputerLauncher;
import hudson.slaves.DumbSlave;
import hudson.slaves.JNLPLauncher;
import hudson.slaves.RetentionStrategy;
import hudson.slaves.SlaveComputer;
import hudson.util.ProcessTree;
import hudson.util.StreamCopyThread;
import hudson.util.VersionNumber;
import java.io.File;
import java.io.IOException;
import java.io.Serializable;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.UUID;
import java.util.jar.JarFile;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.io.FileUtils;
import org.apache.tools.ant.util.JavaEnvUtils;
import org.junit.rules.ExternalResource;
import org.jvnet.hudson.test.JenkinsRule;
import org.jvnet.hudson.test.PrefixedOutputStream;
import org.jvnet.hudson.test.RealJenkinsRule;

public final class InboundAgentRule
extends ExternalResource {
    private static final Logger LOGGER = Logger.getLogger(InboundAgentRule.class.getName());
    private final String id = UUID.randomUUID().toString();
    private final Map<String, List<Process>> procs = Collections.synchronizedMap(new HashMap());
    private final Set<String> workDirs = Collections.synchronizedSet(new HashSet());
    private final Set<File> jars = Collections.synchronizedSet(new HashSet());

    public Slave createAgent(@NonNull JenkinsRule r, @CheckForNull String name) throws Exception {
        return this.createAgent(r, Options.newBuilder().name(name).build());
    }

    public Slave createAgent(@NonNull JenkinsRule r, Options options) throws Exception {
        Slave s = InboundAgentRule.createAgentJR(r, options);
        this.workDirs.add(s.getRemoteFS());
        if (options.isStart()) {
            this.start(r, options);
        }
        return s;
    }

    public void createAgent(@NonNull RealJenkinsRule rr, @CheckForNull String name) throws Throwable {
        this.createAgent(rr, Options.newBuilder().name(name).build());
    }

    public void createAgent(@NonNull RealJenkinsRule rr, Options options) throws Throwable {
        String[] nameAndWorkDir = rr.runRemotely(InboundAgentRule::createAgentRJR, options);
        options.name = nameAndWorkDir[0];
        this.workDirs.add(nameAndWorkDir[1]);
        if (options.isStart()) {
            this.start(rr, options);
        }
    }

    public void start(@NonNull JenkinsRule r, @NonNull String name) throws Exception {
        this.start(r, Options.newBuilder().name(name).build());
    }

    public void start(@NonNull JenkinsRule r, Options options) throws Exception {
        String name = options.getName();
        Objects.requireNonNull(name);
        this.stop(r, name);
        AgentArguments args = InboundAgentRule.getAgentArguments(r, name);
        this.jars.add(args.agentJar);
        this.start(args, options);
        InboundAgentRule.waitForAgentOnline(r, name, options.loggers);
    }

    public void start(@NonNull RealJenkinsRule r, Options options) throws Throwable {
        String name = options.getName();
        Objects.requireNonNull(name);
        this.stop(r, name);
        this.startOnly(r, options);
        r.runRemotely(InboundAgentRule::waitForAgentOnline, name, options.loggers);
    }

    public void startOnly(@NonNull RealJenkinsRule r, Options options) throws Throwable {
        Objects.requireNonNull(options.getName());
        AgentArguments args = this.agentArguments(r, options);
        options.computeJavaOptions(r);
        this.start(args, options, false);
    }

    private AgentArguments agentArguments(RealJenkinsRule r, Options options) throws Throwable {
        AgentArguments args = r.runRemotely(InboundAgentRule::getAgentArguments, options.getName());
        this.jars.add(args.agentJar);
        return args;
    }

    public void start(AgentArguments agentArguments, Options options) throws Exception {
        this.start(agentArguments, options, true);
    }

    @SuppressFBWarnings(value={"COMMAND_INJECTION"}, justification="just for test code")
    private void start(AgentArguments agentArguments, Options options, boolean stop) throws InterruptedException, IOException {
        Objects.requireNonNull(options.getName());
        if (stop) {
            this.stop(options.getName());
        }
        ArrayList<String> cmd = new ArrayList<String>(List.of(JavaEnvUtils.getJreExecutable((String)"java"), "-Xmx512m", "-XX:+PrintCommandLineFlags", "-Djava.awt.headless=true"));
        if (JenkinsRule.SLAVE_DEBUG_PORT > 0) {
            cmd.add("-Xdebug");
            cmd.add("Xrunjdwp:transport=dt_socket,server=y,address=" + (JenkinsRule.SLAVE_DEBUG_PORT + agentArguments.numberOfNodes - 1));
        }
        cmd.addAll(options.javaOptions);
        cmd.addAll(List.of("-jar", agentArguments.agentJar.getAbsolutePath()));
        if (InboundAgentRule.remotingVersion(agentArguments.agentJar).isNewerThanOrEqualTo(new VersionNumber("3186.vc3b_7249b_87eb_"))) {
            cmd.addAll(List.of("-url", agentArguments.url));
            cmd.addAll(List.of("-name", agentArguments.name));
            cmd.addAll(List.of("-secret", agentArguments.secret));
            if (options.isWebSocket()) {
                cmd.add("-webSocket");
            }
            if (options.getTunnel() != null) {
                cmd.addAll(List.of("-tunnel", options.getTunnel()));
            }
        } else {
            cmd.addAll(List.of("-jnlpUrl", agentArguments.agentJnlpUrl()));
            if (options.isSecret()) {
                cmd.addAll(List.of("-secret", agentArguments.secret));
            }
        }
        if (options.noCertificateCheck) {
            cmd.add("-noCertificateCheck");
        } else if (options.cert != null) {
            cmd.addAll(List.of("-cert", options.cert));
        }
        cmd.addAll(agentArguments.commandLineArgs);
        ProcessBuilder pb = new ProcessBuilder(cmd);
        pb.redirectErrorStream(true);
        pb.environment().put("INBOUND_AGENT_RULE_ID", this.id);
        pb.environment().put("INBOUND_AGENT_RULE_NAME", options.getName());
        LOGGER.info(() -> "Running: " + String.valueOf(pb.command()));
        Process proc = pb.start();
        this.procs.merge(options.getName(), List.of(proc), (oldValue, newValue) -> {
            ArrayList result = new ArrayList(oldValue);
            result.addAll(newValue);
            return result;
        });
        new StreamCopyThread("inbound-agent-" + options.getName(), proc.getInputStream(), options.prefixedOutputStreamBuilder.build(System.err)).start();
    }

    private static VersionNumber remotingVersion(File agentJar) throws IOException {
        try (JarFile j = new JarFile(agentJar);){
            String v = j.getManifest().getMainAttributes().getValue("Version");
            if (v == null) {
                throw new IOException("no Version in " + String.valueOf(agentJar));
            }
            VersionNumber versionNumber = new VersionNumber(v);
            return versionNumber;
        }
    }

    public void stop(@NonNull JenkinsRule r, @NonNull String name) throws InterruptedException {
        this.stop(name);
        InboundAgentRule.waitForAgentOffline(r, name);
    }

    public void stop(@NonNull RealJenkinsRule rjr, @NonNull String name) throws Throwable {
        this.stop(name);
        if (rjr.isAlive()) {
            rjr.runRemotely(InboundAgentRule::waitForAgentOffline, name);
        } else {
            LOGGER.warning(() -> "Controller seems to have already shut down; not waiting for " + name + " to go offline");
        }
    }

    public void stop(@NonNull String name) {
        this.procs.computeIfPresent(name, (k, v) -> {
            InboundAgentRule.stop(name, v);
            return null;
        });
    }

    private static void stop(String name, List<Process> v) {
        for (Process proc : v) {
            LOGGER.info(() -> "Killing " + name + " agent JVM (but not subprocesses)");
            proc.destroyForcibly();
            try {
                proc.waitFor();
            }
            catch (InterruptedException e) {
                Thread.currentThread().interrupt();
                throw new RuntimeException("Interrupted while waiting for process to terminate", e);
            }
        }
    }

    public boolean isAlive(String name) {
        return this.procs.get(name).stream().anyMatch(Process::isAlive);
    }

    @SuppressFBWarnings(value={"PATH_TRAVERSAL_IN"}, justification="test code")
    protected void after() {
        for (Map.Entry<String, List<Process>> entry : this.procs.entrySet()) {
            String name = entry.getKey();
            InboundAgentRule.stop(name, entry.getValue());
            try {
                LOGGER.info(() -> "Cleaning up " + name + " agent JVM and/or any subprocesses");
                ProcessTree.get().killAll(null, Map.of("INBOUND_AGENT_RULE_ID", this.id, "INBOUND_AGENT_RULE_NAME", name));
            }
            catch (InterruptedException e) {
                e.printStackTrace();
                Thread.currentThread().interrupt();
            }
        }
        this.procs.clear();
        for (String workDir : this.workDirs) {
            LOGGER.info(() -> "Deleting " + workDir);
            try {
                FileUtils.deleteDirectory((File)new File(workDir));
            }
            catch (IOException x) {
                LOGGER.log(Level.WARNING, null, x);
            }
        }
        for (File jar : this.jars) {
            LOGGER.info(() -> "Deleting " + String.valueOf(jar));
            try {
                Files.deleteIfExists(jar.toPath());
            }
            catch (IOException x) {
                LOGGER.log(Level.WARNING, null, x);
            }
        }
    }

    private static AgentArguments getAgentArguments(JenkinsRule r, String name) throws IOException {
        Node node = r.jenkins.getNode(name);
        if (node == null) {
            throw new AssertionError((Object)("no such agent: " + name));
        }
        SlaveComputer c = (SlaveComputer)node.toComputer();
        if (c == null) {
            throw new AssertionError((Object)("agent " + String.valueOf(node) + " has no executor"));
        }
        JNLPLauncher launcher = (JNLPLauncher)c.getLauncher();
        List commandLineArgs = List.of();
        if (!launcher.getWorkDirSettings().isDisabled()) {
            commandLineArgs = launcher.getWorkDirSettings().toCommandLineArgs(c);
        }
        File agentJar = Files.createTempFile(Path.of(System.getProperty("java.io.tmpdir"), new String[0]), "agent", ".jar", new FileAttribute[0]).toFile();
        FileUtils.copyURLToFile((URL)new Slave.JnlpJar("agent.jar").getURL(), (File)agentJar);
        return new AgentArguments(agentJar, r.jenkins.getRootUrl(), name, c.getJnlpMac(), r.jenkins.getNodes().size(), commandLineArgs);
    }

    private static void waitForAgentOnline(JenkinsRule r, String name, Map<String, Level> loggers) throws Exception {
        Node node = r.jenkins.getNode(name);
        if (node == null) {
            throw new AssertionError((Object)("no such agent: " + name));
        }
        if (!(node instanceof Slave)) {
            throw new AssertionError((Object)("agent is not a Slave: " + name));
        }
        r.waitOnline((Slave)node);
        if (!loggers.isEmpty()) {
            VirtualChannel channel = node.getChannel();
            assert (channel != null);
            channel.call((Callable)new JenkinsRule.RemoteLogDumper(null, loggers, false));
        }
    }

    private static void waitForAgentOffline(JenkinsRule r, String name) throws InterruptedException {
        Computer c = r.jenkins.getComputer(name);
        if (c != null) {
            while (c.isOnline()) {
                Thread.sleep(100L);
            }
        }
    }

    private static String[] createAgentRJR(JenkinsRule r, Options options) throws Throwable {
        Slave agent = InboundAgentRule.createAgentJR(r, options);
        return new String[]{options.getName(), agent.getRemoteFS()};
    }

    @SuppressFBWarnings(value={"PATH_TRAVERSAL_IN"}, justification="just for test code")
    private static Slave createAgentJR(JenkinsRule r, Options options) throws Descriptor.FormException, IOException, InterruptedException {
        if (options.getName() == null) {
            options.name = "agent" + r.jenkins.getNodes().size();
        }
        JNLPLauncher launcher = new JNLPLauncher(options.getTunnel());
        DumbSlave s = new DumbSlave(options.getName(), Files.createTempDirectory(Path.of(System.getProperty("java.io.tmpdir"), new String[0]), options.getName() + "-work", new FileAttribute[0]).toString(), (ComputerLauncher)launcher);
        s.setLabelString(options.getLabel());
        s.setRetentionStrategy(RetentionStrategy.NOOP);
        r.jenkins.addNode((Node)s);
        Computer computer = s.toComputer();
        while (computer == null || computer.getOfflineCause() == null) {
            Thread.sleep(100L);
            computer = s.toComputer();
        }
        return s;
    }

    public static final class Options
    implements Serializable {
        @CheckForNull
        private String name;
        @Deprecated
        private boolean secret;
        private boolean webSocket;
        @CheckForNull
        private String tunnel;
        private List<String> javaOptions = new ArrayList<String>();
        private boolean start = true;
        private final LinkedHashMap<String, Level> loggers = new LinkedHashMap();
        private String label;
        private final PrefixedOutputStream.Builder prefixedOutputStreamBuilder = PrefixedOutputStream.builder();
        private String trustStorePath;
        private String trustStorePassword;
        private String cert;
        private boolean noCertificateCheck;

        public String getName() {
            return this.name;
        }

        @Deprecated
        public boolean isSecret() {
            return this.secret;
        }

        public boolean isWebSocket() {
            return this.webSocket;
        }

        public String getTunnel() {
            return this.tunnel;
        }

        public boolean isStart() {
            return this.start;
        }

        public String getLabel() {
            return this.label;
        }

        private void computeJavaOptions(RealJenkinsRule r) {
            if (this.cert != null || this.noCertificateCheck) {
                return;
            }
            if (this.trustStorePath != null && this.trustStorePassword != null) {
                this.javaOptions.addAll(List.of("-Djavax.net.ssl.trustStore=" + this.trustStorePath, "-Djavax.net.ssl.trustStorePassword=" + this.trustStorePassword));
            } else {
                this.javaOptions.addAll(List.of(r.getTruststoreJavaOptions()));
            }
        }

        public static Builder newBuilder() {
            return new Builder();
        }

        public static final class Builder {
            private final Options options = new Options();

            private Builder() {
            }

            public Builder name(String name) {
                this.options.name = name;
                return this;
            }

            public Builder color(PrefixedOutputStream.AnsiColor color) {
                this.options.prefixedOutputStreamBuilder.withColor(color);
                return this;
            }

            @Deprecated
            public Builder secret() {
                this.options.secret = true;
                return this;
            }

            public Builder webSocket() {
                return this.webSocket(true);
            }

            public Builder webSocket(boolean websocket) {
                this.options.webSocket = websocket;
                return this;
            }

            public Builder tunnel(String tunnel) {
                this.options.tunnel = tunnel;
                return this;
            }

            public Builder javaOptions(String ... opts) {
                this.options.javaOptions.addAll(List.of(opts));
                return this;
            }

            public Builder trustStore(String path, String password) {
                this.options.trustStorePath = path;
                this.options.trustStorePassword = password;
                return this;
            }

            public Builder cert(String cert) {
                this.options.cert = cert;
                return this;
            }

            public Builder noCertificateCheck() {
                this.options.noCertificateCheck = true;
                return this;
            }

            public Builder skipStart() {
                this.options.start = false;
                return this;
            }

            public Builder label(String label) {
                this.options.label = label;
                return this;
            }

            public Builder withLogger(Class<?> clazz, Level level) {
                return this.withLogger(clazz.getName(), level);
            }

            public Builder withPackageLogger(Class<?> clazz, Level level) {
                return this.withLogger(clazz.getPackageName(), level);
            }

            public Builder withLogger(String logger, Level level) {
                this.options.loggers.put(logger, level);
                return this;
            }

            public Options build() {
                return this.options;
            }
        }
    }

    public record AgentArguments(@NonNull File agentJar, @NonNull String url, @NonNull String name, @NonNull String secret, int numberOfNodes, @NonNull List<String> commandLineArgs) implements Serializable
    {
        @Deprecated
        public AgentArguments(@NonNull String agentJnlpUrl, @NonNull File agentJar, @NonNull String secret, int numberOfNodes, @NonNull List<String> commandLineArgs) {
            this(agentJar, AgentArguments.parseUrlAndName(agentJnlpUrl), secret, numberOfNodes, commandLineArgs);
        }

        @Deprecated
        private AgentArguments(@NonNull File agentJar, @NonNull String[] urlAndName, @NonNull String secret, int numberOfNodes, @NonNull List<String> commandLineArgs) {
            this(agentJar, urlAndName[0], urlAndName[1], secret, numberOfNodes, commandLineArgs);
        }

        @Deprecated
        private static String[] parseUrlAndName(@NonNull String agentJnlpUrl) {
            Matcher m = Pattern.compile("(.+)computer/([^/]+)/slave-agent[.]jnlp").matcher(agentJnlpUrl);
            if (!m.matches()) {
                throw new IllegalArgumentException(agentJnlpUrl);
            }
            return new String[]{m.group(1), URI.create(m.group(2)).getPath()};
        }

        @Deprecated
        public String agentJnlpUrl() {
            try {
                return this.url + "computer/" + new URI(null, this.name, null).toString() + "/slave-agent.jnlp";
            }
            catch (URISyntaxException x) {
                throw new RuntimeException(x);
            }
        }
    }
}

