/*
 * Decompiled with CFR 0.152.
 */
package org.jvnet.hudson.test;

import edu.umd.cs.findbugs.annotations.NonNull;
import hudson.AbortException;
import hudson.Extension;
import hudson.FilePath;
import hudson.Launcher;
import hudson.model.AbstractBuild;
import hudson.model.BuildListener;
import hudson.model.Descriptor;
import hudson.tasks.Builder;
import java.io.IOException;
import net.sf.json.JSONObject;
import org.kohsuke.stapler.StaplerRequest2;

public class CreateFileBuilder
extends Builder {
    @NonNull
    private final String fileName;
    @NonNull
    private final String fileContent;

    public CreateFileBuilder(@NonNull String fileName, @NonNull String fileContent) {
        this.fileName = fileName;
        this.fileContent = fileContent;
    }

    @NonNull
    public String getFileName() {
        return this.fileName;
    }

    @NonNull
    public String getFileContent() {
        return this.fileContent;
    }

    public boolean perform(AbstractBuild<?, ?> build, Launcher launcher, BuildListener listener) throws InterruptedException, IOException {
        listener.getLogger().println("Creating a file " + this.fileName);
        FilePath workspace = build.getWorkspace();
        if (workspace == null) {
            throw new AbortException("Cannot get the workspace of the build");
        }
        workspace.child(this.fileName).write(this.fileContent, "UTF-8");
        return true;
    }

    public Descriptor<Builder> getDescriptor() {
        return new DescriptorImpl();
    }

    @Extension
    public static final class DescriptorImpl
    extends Descriptor<Builder> {
        public Builder newInstance(StaplerRequest2 req, @NonNull JSONObject data) {
            throw new UnsupportedOperationException("This is a temporary test class, which should not be configured from UI");
        }

        @NonNull
        public String getDisplayName() {
            return "Create a file";
        }
    }
}

