/*
 * Decompiled with CFR 0.152.
 */
package org.htmlunit.html;

import java.io.IOException;
import java.util.List;
import org.htmlunit.ElementNotFoundException;
import org.htmlunit.Page;
import org.htmlunit.WebClient;
import org.htmlunit.WebClientUtil;
import org.htmlunit.html.HtmlButton;
import org.htmlunit.html.HtmlElement;
import org.htmlunit.html.HtmlElementUtil;
import org.htmlunit.html.HtmlForm;
import org.htmlunit.html.HtmlPage;
import org.htmlunit.html.SubmittableElement;

public class HtmlFormUtil {
    public static Page submit(HtmlForm htmlForm) throws IOException {
        HtmlElement submitElement = HtmlFormUtil.getSubmitButton(htmlForm);
        return HtmlFormUtil.submit(htmlForm, submitElement);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Page submit(HtmlForm htmlForm, HtmlElement submitElement) throws IOException {
        HtmlPage htmlPage = (HtmlPage)htmlForm.getPage();
        WebClient webClient = htmlPage.getWebClient();
        try {
            if (submitElement != null && !(submitElement instanceof SubmittableElement)) {
                Page page = submitElement.click();
                return page;
            }
            htmlForm.submit((SubmittableElement)submitElement);
            webClient.loadDownloadedResponses();
            Page resultPage = webClient.getCurrentWindow().getEnclosedPage();
            if (resultPage == htmlPage) {
                Page page = HtmlElementUtil.click(submitElement);
                return page;
            }
            Page page = resultPage;
            return page;
        }
        finally {
            WebClientUtil.waitForJSExec(webClient);
        }
    }

    public static List<HtmlElement> getSubmitButtons(HtmlForm htmlForm) throws ElementNotFoundException {
        return htmlForm.getElementsByAttribute("input", "type", "submit");
    }

    public static HtmlElement getSubmitButton(HtmlForm htmlForm) throws ElementNotFoundException {
        HtmlElement submitButton = (HtmlElement)htmlForm.getFirstByXPath("//button[contains(@class, 'jenkins-submit-button')]");
        if (submitButton != null) {
            return submitButton;
        }
        for (HtmlElement element : htmlForm.getElementsByAttribute("button", "name", "Submit")) {
            if (!(element instanceof HtmlButton)) continue;
            return element;
        }
        List<HtmlElement> submitButtons = HtmlFormUtil.getSubmitButtons(htmlForm);
        if (!submitButtons.isEmpty()) {
            return submitButtons.get(0);
        }
        for (HtmlElement element : htmlForm.getElementsByTagName("button")) {
            if (!(element instanceof HtmlButton)) continue;
            return element;
        }
        return null;
    }

    public static HtmlButton getButtonByCaption(HtmlForm htmlForm, String caption) throws ElementNotFoundException {
        for (HtmlElement b : htmlForm.getElementsByTagName("button")) {
            if (!(b instanceof HtmlButton) || !b.getTextContent().trim().equals(caption)) continue;
            return (HtmlButton)b;
        }
        throw new ElementNotFoundException("button", "caption", caption);
    }

    private HtmlFormUtil() {
    }
}

