/*
 * Decompiled with CFR 0.152.
 */
package jenkins.test.https;

import edu.umd.cs.findbugs.annotations.CheckForNull;
import edu.umd.cs.findbugs.annotations.NonNull;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.lang.invoke.CallSite;
import java.net.URL;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.security.KeyManagementException;
import java.security.KeyStore;
import java.security.KeyStoreException;
import java.security.NoSuchAlgorithmException;
import java.security.PrivateKey;
import java.security.UnrecoverableKeyException;
import java.security.cert.Certificate;
import java.security.cert.CertificateException;
import java.security.cert.X509Certificate;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import javax.net.ssl.KeyManager;
import javax.net.ssl.KeyManagerFactory;
import javax.net.ssl.SSLContext;
import javax.net.ssl.TrustManager;
import javax.net.ssl.TrustManagerFactory;
import javax.net.ssl.X509TrustManager;
import org.htmlunit.WebClient;

public final class KeyStoreManager {
    @NonNull
    private final Path path;
    @NonNull
    private final URL url;
    @CheckForNull
    private final char[] password;
    @NonNull
    private final KeyStore keyStore;
    @NonNull
    private final String type;

    public KeyStoreManager(@NonNull Path path) throws CertificateException, KeyStoreException, IOException, NoSuchAlgorithmException {
        this(path, null, KeyStore.getDefaultType());
    }

    public KeyStoreManager(@NonNull Path path, @CheckForNull String password) throws CertificateException, KeyStoreException, IOException, NoSuchAlgorithmException {
        this(path, password, KeyStore.getDefaultType());
    }

    public KeyStoreManager(@NonNull Path path, @CheckForNull String password, @NonNull String type) throws CertificateException, KeyStoreException, IOException, NoSuchAlgorithmException {
        this.path = path;
        this.url = path.toUri().toURL();
        this.password = password == null ? null : password.toCharArray();
        this.type = type;
        KeyStore tmpKeyStore = KeyStore.getInstance(type);
        if (Files.exists(path, new LinkOption[0])) {
            try (InputStream is = Files.newInputStream(path, new OpenOption[0]);){
                tmpKeyStore.load(is, this.password);
            }
        } else {
            tmpKeyStore.load(null);
        }
        this.keyStore = tmpKeyStore;
    }

    @NonNull
    private static X509TrustManager getDefaultX509CertificateTrustManager(TrustManagerFactory trustManagerFactory) {
        return Arrays.stream(trustManagerFactory.getTrustManagers()).filter(X509TrustManager.class::isInstance).map(X509TrustManager.class::cast).findFirst().orElseThrow(() -> new IllegalStateException("Could not load default trust manager"));
    }

    public String getPassword() {
        return this.password == null ? null : new String(this.password);
    }

    public Path getPath() {
        return this.path;
    }

    public String getType() {
        return this.type;
    }

    public URL getURL() {
        return this.url;
    }

    public void save() throws IOException, KeyStoreException, NoSuchAlgorithmException, CertificateException {
        try (OutputStream os = Files.newOutputStream(this.path, new OpenOption[0]);){
            this.keyStore.store(os, this.password);
        }
    }

    @NonNull
    public SSLContext buildClientSSLContext() throws NoSuchAlgorithmException, KeyStoreException, IOException, CertificateException, KeyManagementException {
        X509TrustManager result;
        try (InputStream myKeysInputStream = Files.newInputStream(this.path, new OpenOption[0]);){
            KeyStore myTrustStore = KeyStore.getInstance(this.type);
            myTrustStore.load(myKeysInputStream, this.password);
            TrustManagerFactory trustManagerFactory = TrustManagerFactory.getInstance(TrustManagerFactory.getDefaultAlgorithm());
            trustManagerFactory.init(myTrustStore);
            result = KeyStoreManager.getDefaultX509CertificateTrustManager(trustManagerFactory);
        }
        TrustManagerFactory trustManagerFactory = TrustManagerFactory.getInstance(TrustManagerFactory.getDefaultAlgorithm());
        trustManagerFactory.init((KeyStore)null);
        MergedTrustManager wrapper = new MergedTrustManager(KeyStoreManager.getDefaultX509CertificateTrustManager(trustManagerFactory), result);
        SSLContext context = SSLContext.getInstance("TLS");
        context.init(null, new TrustManager[]{wrapper}, null);
        return context;
    }

    public SSLContext buildServerSSLContext() {
        TrustManager[] trustManagers;
        KeyManager[] keyManagers;
        try {
            KeyManagerFactory keyManagerFactory = KeyManagerFactory.getInstance(KeyManagerFactory.getDefaultAlgorithm());
            keyManagerFactory.init(this.keyStore, this.password);
            keyManagers = keyManagerFactory.getKeyManagers();
        }
        catch (KeyStoreException | NoSuchAlgorithmException | UnrecoverableKeyException e) {
            throw new RuntimeException("Unable to initialise KeyManager[]", e);
        }
        try {
            TrustManagerFactory trustManagerFactory = TrustManagerFactory.getInstance(KeyManagerFactory.getDefaultAlgorithm());
            trustManagerFactory.init(this.keyStore);
            trustManagers = trustManagerFactory.getTrustManagers();
        }
        catch (KeyStoreException | NoSuchAlgorithmException e) {
            throw new RuntimeException("Unable to initialise TrustManager[]", e);
        }
        try {
            SSLContext sslContext = SSLContext.getInstance("TLS");
            sslContext.init(keyManagers, trustManagers, null);
            return sslContext;
        }
        catch (KeyManagementException | NoSuchAlgorithmException e) {
            throw new RuntimeException("Unable to create and initialise the SSLContext", e);
        }
    }

    public void setCertificateEntry(String alias, X509Certificate certificate) throws KeyStoreException {
        this.keyStore.setCertificateEntry(alias, certificate);
    }

    public void setKeyEntry(String host, PrivateKey privateKey, Certificate[] certificates) throws KeyStoreException {
        this.keyStore.setKeyEntry(host, privateKey, this.password, certificates);
    }

    public String[] getTruststoreJavaOptions() {
        ArrayList<CallSite> list = new ArrayList<CallSite>();
        list.add((CallSite)((Object)("-Djavax.net.ssl.trustStore=" + String.valueOf(this.getPath().toAbsolutePath()))));
        if (this.password != null) {
            list.add((CallSite)((Object)("-Djavax.net.ssl.trustStorePassword=" + new String(this.password))));
        }
        return list.toArray(new String[0]);
    }

    public void configureWebClient(WebClient wc) {
        wc.getOptions().setSSLTrustStore(this.getURL(), this.getPassword(), this.getType());
    }

    private static class MergedTrustManager
    implements X509TrustManager {
        private final X509TrustManager defaultTrustManager;
        private final List<X509TrustManager> trustManagers;

        public MergedTrustManager(X509TrustManager defaultTrustManager, X509TrustManager ... trustManagers) {
            this.defaultTrustManager = defaultTrustManager;
            this.trustManagers = List.of(trustManagers);
        }

        @Override
        public X509Certificate[] getAcceptedIssuers() {
            return (X509Certificate[])this.trustManagers.stream().map(X509TrustManager::getAcceptedIssuers).flatMap(Arrays::stream).toArray(X509Certificate[]::new);
        }

        @Override
        public void checkServerTrusted(X509Certificate[] chain, String authType) throws CertificateException {
            CertificateException exceptionResult = null;
            for (X509TrustManager trustManager : this.trustManagers) {
                try {
                    trustManager.checkServerTrusted(chain, authType);
                    return;
                }
                catch (CertificateException e) {
                    if (exceptionResult == null) {
                        exceptionResult = e;
                        continue;
                    }
                    exceptionResult.addSuppressed(e);
                }
            }
            if (exceptionResult != null) {
                throw exceptionResult;
            }
        }

        @Override
        public void checkClientTrusted(X509Certificate[] chain, String authType) throws CertificateException {
            this.defaultTrustManager.checkClientTrusted((X509Certificate[])this.trustManagers.stream().map(X509TrustManager::getAcceptedIssuers).flatMap(Arrays::stream).toArray(X509Certificate[]::new), authType);
        }
    }
}

