/*
 * Decompiled with CFR 0.152.
 */
package jenkins.test;

import edu.umd.cs.findbugs.annotations.NonNull;
import hudson.model.Result;
import hudson.model.Run;
import java.io.IOException;
import org.hamcrest.Description;
import org.hamcrest.Matcher;
import org.hamcrest.TypeSafeMatcher;
import org.jvnet.hudson.test.JenkinsRule;

public final class RunMatchers {
    private RunMatchers() {
    }

    public static Matcher<Run<?, ?>> isSuccessful() {
        return new RunResultMatcher(Result.SUCCESS);
    }

    public static Matcher<Run<?, ?>> hasStatus(Result result) {
        return new RunResultMatcher(result);
    }

    public static Matcher<Run<?, ?>> logContains(String message) {
        return new RunLogMatcher(message);
    }

    public static Matcher<Run<?, ?>> completed() {
        return new CompletedRunMatcher();
    }

    private static class RunResultMatcher
    extends TypeSafeMatcher<Run<?, ?>> {
        @NonNull
        private final Result expectedResult;

        public RunResultMatcher(@NonNull Result expectedResult) {
            this.expectedResult = expectedResult;
        }

        public void describeTo(Description description) {
            description.appendText("a build with result " + String.valueOf(this.expectedResult));
        }

        protected boolean matchesSafely(Run run) {
            return run.getResult() == this.expectedResult;
        }

        protected void describeMismatchSafely(Run<?, ?> item, Description mismatchDescription) {
            mismatchDescription.appendText("was ").appendValue((Object)item.getResult());
        }
    }

    private static class RunLogMatcher
    extends TypeSafeMatcher<Run<?, ?>> {
        @NonNull
        private final String message;

        private RunLogMatcher(@NonNull String message) {
            this.message = message;
        }

        protected boolean matchesSafely(Run<?, ?> run) {
            try {
                return JenkinsRule.getLog(run).contains(this.message);
            }
            catch (IOException x) {
                return false;
            }
        }

        protected void describeMismatchSafely(Run<?, ?> item, Description mismatchDescription) {
            mismatchDescription.appendText("was \n");
            try {
                mismatchDescription.appendText(JenkinsRule.getLog(item));
            }
            catch (IOException e) {
                mismatchDescription.appendText("<unreadable>");
            }
        }

        public void describeTo(Description description) {
            description.appendText("log containing ").appendValue((Object)this.message);
        }
    }

    private static class CompletedRunMatcher
    extends TypeSafeMatcher<Run<?, ?>> {
        private CompletedRunMatcher() {
        }

        protected boolean matchesSafely(Run<?, ?> run) {
            return !run.isLogUpdated();
        }

        public void describeTo(Description description) {
            description.appendText("a completed build");
        }
    }
}

