/*
 * Decompiled with CFR 0.152.
 */
package hudson.security.pages;

import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.hamcrest.Matchers;
import org.htmlunit.html.HtmlForm;
import org.htmlunit.html.HtmlPage;
import org.junit.Assert;
import org.jvnet.hudson.test.JenkinsRule;

public class SignupPage {
    public HtmlForm signupForm;
    public final HtmlPage signupPage;

    public SignupPage(HtmlPage signupPage) {
        this.signupPage = signupPage;
        Assert.assertNotNull((String)"The sign up page has a username field.", (Object)this.signupPage.getElementById("username"));
        for (HtmlForm signupForm : this.signupPage.getForms()) {
            if (signupForm.getInputsByName("username").size() == 0) continue;
            this.signupForm = signupForm;
        }
    }

    public void enterUsername(String username) {
        this.signupForm.getInputByName("username").setValue(username);
    }

    public void enterPassword(String password) {
        this.signupForm.getInputByName("password1").setValue(password);
        this.signupForm.getInputByName("password2").setValue(password);
    }

    public void enterPassword2(String password2) {
        this.signupForm.getInputByName("password2").setValue(password2);
    }

    public void enterFullName(String fullName) {
        this.signupForm.getInputByName("fullname").setValue(fullName);
    }

    public void enterEmail(String email) {
        this.signupForm.getInputByName("email").setValue(email);
    }

    public HtmlPage submit(JenkinsRule rule) throws Exception {
        return rule.submit(this.signupForm);
    }

    public void assertErrorContains(String msg) {
        MatcherAssert.assertThat((Object)this.signupForm.getPage().getElementById("main-panel").getTextContent(), (Matcher)Matchers.containsString((String)msg));
    }
}

