/*
 * Decompiled with CFR 0.152.
 */
package org.jvnet.hudson.test;

import hudson.Extension;
import hudson.ExtensionFinder;
import java.lang.annotation.AnnotationTypeMismatchException;
import java.lang.reflect.AnnotatedElement;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.util.Arrays;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.junit.runner.Description;
import org.jvnet.hudson.test.TestEnvironment;
import org.jvnet.hudson.test.TestExtension;

@Extension
public class TestExtensionLoader
extends ExtensionFinder.GuiceExtensionAnnotation<TestExtension> {
    private static final Logger LOGGER = Logger.getLogger(TestExtensionLoader.class.getName());

    public TestExtensionLoader() {
        super(TestExtension.class);
    }

    protected boolean isOptional(TestExtension annotation) {
        return false;
    }

    protected double getOrdinal(TestExtension annotation) {
        return 0.0;
    }

    protected boolean isActive(AnnotatedElement e) {
        List<String> testNameList;
        TestEnvironment env = TestEnvironment.get();
        if (env == null) {
            return false;
        }
        TestExtension a = e.getAnnotation(TestExtension.class);
        if (a == null) {
            return false;
        }
        try {
            testNameList = Arrays.asList(a.value());
        }
        catch (AnnotationTypeMismatchException x) {
            LOGGER.log(Level.WARNING, "ignoring {0} compiled against jenkins-test-harness older than 2.16", e);
            return false;
        }
        Description description = env.description();
        if (!testNameList.isEmpty() && !testNameList.contains(description.getMethodName())) {
            return false;
        }
        String className = description.getClassName();
        if (e instanceof Class) {
            for (Class<?> outer = (Class<?>)e; outer != null; outer = outer.getEnclosingClass()) {
                if (!outer.getName().equals(className)) continue;
                return true;
            }
            return false;
        }
        if (e instanceof Field) {
            Field f = (Field)e;
            return f.getDeclaringClass().getName().equals(className);
        }
        if (e instanceof Method) {
            Method m = (Method)e;
            return m.getDeclaringClass().getName().equals(className);
        }
        return false;
    }
}

