/*
 * Decompiled with CFR 0.152.
 */
package org.jvnet.hudson.test;

import java.io.IOException;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.annotation.CheckForNull;
import javax.annotation.Nonnull;
import org.junit.runner.Description;
import org.jvnet.hudson.test.HudsonTestCase;
import org.jvnet.hudson.test.TemporaryDirectoryAllocator;

public class TestEnvironment {
    private static final Logger LOGGER = Logger.getLogger(TestEnvironment.class.getName());
    @CheckForNull
    public final HudsonTestCase testCase;
    @CheckForNull
    private final Description description;
    public final TemporaryDirectoryAllocator temporaryDirectoryAllocator = new TemporaryDirectoryAllocator();
    private static TestEnvironment CURRENT;

    public TestEnvironment(@Nonnull HudsonTestCase testCase) {
        this.testCase = testCase;
        this.description = null;
    }

    public TestEnvironment(@Nonnull Description description) {
        this.testCase = null;
        this.description = description;
    }

    @Nonnull
    public Description description() {
        if (this.description != null) {
            return this.description;
        }
        assert (this.testCase != null);
        return Description.createTestDescription(((Object)((Object)this.testCase)).getClass(), (String)this.testCase.getName());
    }

    public void pin() {
        CURRENT = this;
        LOGGER.log(Level.FINE, "pinned to {0}", this);
    }

    public void dispose() throws IOException, InterruptedException {
        this.temporaryDirectoryAllocator.dispose();
        if (CURRENT == this) {
            LOGGER.log(Level.FINE, "disposed {0}", this);
            CURRENT = null;
        } else {
            LOGGER.log(Level.WARNING, "did not dispose {0} because current is{1}", new Object[]{this, CURRENT});
        }
    }

    public String toString() {
        return "TestEnvironment:" + this.description();
    }

    public static TestEnvironment get() {
        return CURRENT;
    }
}

