/*
 * Decompiled with CFR 0.152.
 */
package org.jvnet.hudson.test;

import hudson.model.UnprotectedRootAction;
import hudson.security.ACL;
import hudson.security.ACLContext;
import hudson.security.csrf.CrumbExclusion;
import hudson.util.StreamCopyThread;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.ObjectStreamClass;
import java.io.OutputStream;
import java.io.Serializable;
import java.lang.annotation.Annotation;
import java.net.HttpURLConnection;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URL;
import java.net.URLClassLoader;
import java.nio.charset.StandardCharsets;
import java.nio.file.CopyOption;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.security.MessageDigest;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Enumeration;
import java.util.List;
import java.util.Random;
import java.util.Set;
import java.util.TreeSet;
import java.util.UUID;
import java.util.concurrent.TimeUnit;
import java.util.jar.Manifest;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.servlet.FilterChain;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import jenkins.model.Jenkins;
import jenkins.model.JenkinsLocationConfiguration;
import jenkins.util.Timer;
import org.acegisecurity.Authentication;
import org.apache.commons.io.FileUtils;
import org.apache.commons.io.IOUtils;
import org.junit.rules.DisableOnDebug;
import org.junit.rules.TestRule;
import org.junit.runner.Description;
import org.junit.runners.model.Statement;
import org.jvnet.hudson.test.JenkinsRule;
import org.jvnet.hudson.test.JenkinsSessionRule;
import org.jvnet.hudson.test.TemporaryDirectoryAllocator;
import org.jvnet.hudson.test.TestEnvironment;
import org.jvnet.hudson.test.WarExploder;
import org.kohsuke.stapler.HttpResponse;
import org.kohsuke.stapler.HttpResponses;
import org.kohsuke.stapler.QueryParameter;
import org.kohsuke.stapler.StaplerRequest;
import org.kohsuke.stapler.StaplerResponse;
import org.kohsuke.stapler.verb.POST;

public final class RealJenkinsRule
implements TestRule {
    private static final Logger LOGGER = Logger.getLogger(JenkinsSessionRule.class.getName());
    private Description description;
    private final TemporaryDirectoryAllocator tmp = new TemporaryDirectoryAllocator();
    private File home;
    private int port;
    private final String token = UUID.randomUUID().toString();
    private final Set<String> skippedPlugins = new TreeSet<String>();
    private final List<String> javaOptions = new ArrayList<String>();
    private int timeout = Integer.getInteger("jenkins.test.timeout", new DisableOnDebug(null).isDebugging() ? 0 : 600);
    private String host = "localhost";
    private Process proc;
    private static final Pattern SNAPSHOT_INDEX_JELLY = Pattern.compile("(file:/.+/target)/classes/index.jelly");

    public RealJenkinsRule omitPlugins(String ... plugins) {
        this.skippedPlugins.addAll(Arrays.asList(plugins));
        return this;
    }

    public RealJenkinsRule javaOptions(String ... options) {
        this.javaOptions.addAll(Arrays.asList(options));
        return this;
    }

    public RealJenkinsRule withTimeout(int timeout) {
        this.timeout = timeout;
        return this;
    }

    public RealJenkinsRule withHost(String host) {
        this.host = host;
        return this;
    }

    public Statement apply(final Statement base, final Description description) {
        this.description = description;
        return new Statement(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void evaluate() throws Throwable {
                System.out.println("=== Starting " + description);
                try {
                    RealJenkinsRule.this.home = RealJenkinsRule.this.tmp.allocate();
                    RealJenkinsRule.this.port = new Random().nextInt(16384) + 49152;
                    File plugins = new File(RealJenkinsRule.this.home, "plugins");
                    plugins.mkdir();
                    FileUtils.copyURLToFile((URL)RealJenkinsRule.class.getResource("RealJenkinsRuleInit.jpi"), (File)new File(plugins, "RealJenkinsRuleInit.jpi"));
                    TreeSet<String> snapshotPlugins = new TreeSet<String>();
                    Enumeration<URL> indexJellies = RealJenkinsRule.class.getClassLoader().getResources("index.jelly");
                    while (indexJellies.hasMoreElements()) {
                        String indexJelly = indexJellies.nextElement().toString();
                        Matcher m = SNAPSHOT_INDEX_JELLY.matcher(indexJelly);
                        if (!m.matches()) continue;
                        Path snapshotManifest = Paths.get(URI.create(m.group(1) + "/test-classes/the.jpl"));
                        if (!Files.exists(snapshotManifest, new LinkOption[0])) {
                            snapshotManifest = Paths.get(URI.create(m.group(1) + "/test-classes/the.hpl"));
                        }
                        if (Files.exists(snapshotManifest, new LinkOption[0])) {
                            String shortName;
                            try (InputStream is = Files.newInputStream(snapshotManifest, new OpenOption[0]);){
                                shortName = new Manifest(is).getMainAttributes().getValue("Short-Name");
                            }
                            if (shortName == null) {
                                throw new IOException("malformed " + snapshotManifest);
                            }
                            if (RealJenkinsRule.this.skippedPlugins.contains(shortName)) continue;
                            Files.copy(snapshotManifest, plugins.toPath().resolve(shortName + ".jpl"), new CopyOption[0]);
                            snapshotPlugins.add(shortName);
                            continue;
                        }
                        System.out.println("Warning: found " + indexJelly + " but did not find corresponding ../test-classes/the.[hj]pl");
                    }
                    URL index = RealJenkinsRule.class.getResource("/test-dependencies/index");
                    if (index != null) {
                        try (BufferedReader r = new BufferedReader(new InputStreamReader(index.openStream(), StandardCharsets.UTF_8));){
                            String line;
                            while ((line = r.readLine()) != null) {
                                File f;
                                if (snapshotPlugins.contains(line) || RealJenkinsRule.this.skippedPlugins.contains(line)) continue;
                                URL url = new URL(index, line + ".jpi");
                                try {
                                    f = new File(url.toURI());
                                }
                                catch (IllegalArgumentException x) {
                                    if (x.getMessage().equals("URI is not hierarchical")) {
                                        throw new IOException("You are probably trying to load plugins from within a jarfile (not possible). If you are running this in your IDE and see this message, it is likely that you have a clean target directory. Try running 'mvn test-compile' from the command line (once only), which will copy the required plugins into target/test-classes/test-dependencies - then retry your test", x);
                                    }
                                    throw new IOException(index + " contains bogus line " + line, x);
                                }
                                if (f.exists()) {
                                    FileUtils.copyURLToFile((URL)url, (File)new File(plugins, line + ".jpi"));
                                    continue;
                                }
                                FileUtils.copyURLToFile((URL)new URL(index, line + ".hpi"), (File)new File(plugins, line + ".jpi"));
                            }
                        }
                    }
                    System.out.println("Will load plugins: " + Stream.of(plugins.list()).filter(n -> n.matches(".+[.][hj]p[il]")).sorted().collect(Collectors.joining(" ")));
                    base.evaluate();
                }
                finally {
                    if (RealJenkinsRule.this.proc != null) {
                        RealJenkinsRule.this.stopJenkins();
                    }
                    try {
                        RealJenkinsRule.this.tmp.dispose();
                    }
                    catch (Exception x) {
                        LOGGER.log(Level.WARNING, null, x);
                    }
                }
            }
        };
    }

    public void then(Step s) throws Throwable {
        this.startJenkins();
        try {
            this.runRemotely(s);
        }
        finally {
            this.stopJenkins();
        }
    }

    public URL getUrl() throws MalformedURLException {
        return new URL("http://" + this.host + ":" + this.port + "/jenkins/");
    }

    private URL endpoint(String method) throws MalformedURLException {
        return new URL(this.getUrl(), "RealJenkinsRule/" + method + "?token=" + this.token);
    }

    public void startJenkins() throws Throwable {
        if (this.proc != null) {
            throw new IllegalStateException("Jenkins is (supposedly) already running");
        }
        String cp = System.getProperty("java.class.path");
        ArrayList<String> argv = new ArrayList<String>(Arrays.asList(new File(System.getProperty("java.home"), "bin/java").getAbsolutePath(), "-ea", "-Dhudson.Main.development=true", "-DRealJenkinsRule.location=" + RealJenkinsRule.class.getProtectionDomain().getCodeSource().getLocation(), "-DRealJenkinsRule.cp=" + cp, "-DRealJenkinsRule.url=" + this.getUrl(), "-DRealJenkinsRule.description=" + this.description, "-DRealJenkinsRule.token=" + this.token));
        if (new DisableOnDebug(null).isDebugging()) {
            argv.add("-agentlib:jdwp=transport=dt_socket,server=y");
        }
        argv.addAll(this.javaOptions);
        argv.addAll(Arrays.asList("-jar", WarExploder.findJenkinsWar().getAbsolutePath(), "--httpPort=" + this.port, "--httpListenAddress=127.0.0.1", "--prefix=/jenkins"));
        ProcessBuilder pb = new ProcessBuilder(argv);
        System.out.println("Launching: " + pb.command().toString().replace(cp, "\u2026"));
        pb.environment().put("JENKINS_HOME", this.home.getAbsolutePath());
        this.proc = pb.start();
        new StreamCopyThread(this.description.toString(), this.proc.getInputStream(), (OutputStream)System.out).start();
        new StreamCopyThread(this.description.toString(), this.proc.getErrorStream(), (OutputStream)System.err).start();
        URL status = this.endpoint("status");
        int tries = 0;
        while (true) {
            try {
                HttpURLConnection conn = (HttpURLConnection)status.openConnection();
                int code = conn.getResponseCode();
                if (code != 200) {
                    String err = "?";
                    try (InputStream is = conn.getErrorStream();){
                        if (is != null) {
                            err = IOUtils.toString((InputStream)is);
                        }
                    }
                    catch (Exception x) {
                        x.printStackTrace();
                    }
                    throw new IOException("Response code " + code + " for " + status + ": " + err + " " + conn.getHeaderFields());
                }
                conn.getInputStream().close();
            }
            catch (Exception x) {
                if (++tries == 1800) {
                    throw new AssertionError((Object)"Jenkins did not start after 3m");
                }
                if (tries % 600 == 0) {
                    x.printStackTrace();
                }
                Thread.sleep(100L);
                continue;
            }
            break;
        }
        if (this.timeout > 0) {
            Timer.get().schedule(() -> {
                if (this.proc != null) {
                    System.err.println("Test timeout expired, killing Jenkins process");
                    this.proc.destroyForcibly();
                    this.proc = null;
                }
            }, (long)this.timeout, TimeUnit.SECONDS);
        }
    }

    public void stopJenkins() throws Throwable {
        this.endpoint("exit").openStream().close();
        if (!this.proc.waitFor(60L, TimeUnit.SECONDS)) {
            System.err.println("Jenkins failed to stop within 60 seconds, attempting to kill the Jenkins process");
            this.proc.destroyForcibly();
            throw new AssertionError((Object)"Jenkins failed to terminate within 60 seconds");
        }
        int exitValue = this.proc.exitValue();
        if (exitValue != 0) {
            throw new AssertionError((Object)("nonzero exit code: " + exitValue));
        }
        this.proc = null;
    }

    public void runRemotely(Step s) throws Throwable {
        HttpURLConnection conn = (HttpURLConnection)this.endpoint("step").openConnection();
        conn.setDoOutput(true);
        Init2.writeSer(conn.getOutputStream(), Arrays.asList(this.token, s));
        Throwable error = (Throwable)Init2.readSer(conn.getInputStream(), null);
        if (error != null) {
            throw error;
        }
    }

    public static final class ProxyException
    extends IOException {
        ProxyException(Throwable cause) {
            super(cause.toString());
            this.setStackTrace(cause.getStackTrace());
            if (cause.getCause() != null) {
                this.initCause(new ProxyException(cause.getCause()));
            }
            for (Throwable suppressed : cause.getSuppressed()) {
                this.addSuppressed(new ProxyException(suppressed));
            }
        }

        @Override
        public String toString() {
            return this.getMessage();
        }
    }

    public static final class CustomJenkinsRule
    extends JenkinsRule
    implements AutoCloseable {
        public CustomJenkinsRule() throws Exception {
            this.jenkins = Jenkins.get();
            this.jenkins.setNoUsageStatistics(Boolean.valueOf(true));
            JenkinsLocationConfiguration.get().setUrl(this.getURL().toString());
            this.testDescription = Description.createSuiteDescription((String)System.getProperty("RealJenkinsRule.description"), (Annotation[])new Annotation[0]);
            this.env = new TestEnvironment(this.testDescription);
            this.env.pin();
        }

        @Override
        public URL getURL() throws IOException {
            return new URL(System.getProperty("RealJenkinsRule.url"));
        }

        @Override
        public void close() throws Exception {
            this.env.dispose();
        }
    }

    public static final class Endpoint
    implements UnprotectedRootAction {
        private final byte[] actualToken = System.getProperty("RealJenkinsRule.token").getBytes(StandardCharsets.US_ASCII);

        public static void register() throws Exception {
            Jenkins j = Jenkins.get();
            j.getActions().add(new Endpoint());
            CrumbExclusion.all().add((Object)new CrumbExclusion(){

                public boolean process(HttpServletRequest request, HttpServletResponse response, FilterChain chain) throws IOException, ServletException {
                    if (request.getPathInfo().startsWith("/RealJenkinsRule/")) {
                        chain.doFilter((ServletRequest)request, (ServletResponse)response);
                        return true;
                    }
                    return false;
                }
            });
            JenkinsRule._configureUpdateCenter(j);
            System.err.println("RealJenkinsRule ready");
            if (!new DisableOnDebug(null).isDebugging()) {
                Timer.get().scheduleAtFixedRate(JenkinsRule::dumpThreads, 2L, 2L, TimeUnit.MINUTES);
            }
        }

        public String getUrlName() {
            return "RealJenkinsRule";
        }

        public String getIconFileName() {
            return null;
        }

        public String getDisplayName() {
            return null;
        }

        private void checkToken(String token) {
            if (!MessageDigest.isEqual(this.actualToken, token.getBytes(StandardCharsets.US_ASCII))) {
                throw HttpResponses.forbidden();
            }
        }

        public void doStatus(@QueryParameter String token) {
            System.err.println("Checking status");
            this.checkToken(token);
        }

        @POST
        public void doStep(StaplerRequest req, StaplerResponse rsp) throws Throwable {
            List tokenAndStep = (List)Init2.readSer((InputStream)req.getInputStream(), Endpoint.class.getClassLoader());
            this.checkToken((String)tokenAndStep.get(0));
            Step s = (Step)tokenAndStep.get(1);
            Throwable err = null;
            try (CustomJenkinsRule rule = new CustomJenkinsRule();
                 ACLContext ctx = ACL.as((Authentication)ACL.SYSTEM);){
                s.run(rule);
            }
            catch (Throwable t) {
                err = t;
            }
            Init2.writeSer((OutputStream)rsp.getOutputStream(), (Object)(err != null ? new ProxyException(err) : null));
        }

        public HttpResponse doExit(@QueryParameter String token) throws IOException {
            this.checkToken(token);
            try (ACLContext ctx = ACL.as((Authentication)ACL.SYSTEM);){
                HttpResponse httpResponse = Jenkins.get().doSafeExit(null);
                return httpResponse;
            }
        }
    }

    public static final class Init2 {
        public static void run(Object jenkins) throws Exception {
            Object pluginManager = jenkins.getClass().getField("pluginManager").get(jenkins);
            ClassLoader uberClassLoader = (ClassLoader)pluginManager.getClass().getField("uberClassLoader").get(pluginManager);
            URLClassLoader tests = new URLClassLoader((URL[])Stream.of(System.getProperty("RealJenkinsRule.cp").split(File.pathSeparator)).map(Init2::pathToURL).toArray(URL[]::new), uberClassLoader);
            tests.loadClass("org.jvnet.hudson.test.RealJenkinsRule$Endpoint").getMethod("register", new Class[0]).invoke(null, new Object[0]);
        }

        private static URL pathToURL(String path) {
            try {
                return Paths.get(path, new String[0]).toUri().toURL();
            }
            catch (MalformedURLException x) {
                throw new IllegalArgumentException(x);
            }
        }

        static void writeSer(File f, Object o) throws Exception {
            try (FileOutputStream os = new FileOutputStream(f);){
                Init2.writeSer(os, o);
            }
        }

        static void writeSer(OutputStream os, Object o) throws Exception {
            try (ObjectOutputStream oos = new ObjectOutputStream(os);){
                oos.writeObject(o);
            }
        }

        static Object readSer(File f, ClassLoader loader) throws Exception {
            try (FileInputStream is = new FileInputStream(f);){
                Object object = Init2.readSer(is, loader);
                return object;
            }
        }

        static Object readSer(InputStream is, final ClassLoader loader) throws Exception {
            try (ObjectInputStream ois = new ObjectInputStream(is){

                @Override
                protected Class<?> resolveClass(ObjectStreamClass desc) throws IOException, ClassNotFoundException {
                    if (loader != null) {
                        try {
                            return loader.loadClass(desc.getName());
                        }
                        catch (ClassNotFoundException classNotFoundException) {
                            // empty catch block
                        }
                    }
                    return super.resolveClass(desc);
                }
            };){
                Object object = ois.readObject();
                return object;
            }
        }

        private Init2() {
        }
    }

    @FunctionalInterface
    public static interface Step
    extends Serializable {
        public void run(JenkinsRule var1) throws Throwable;
    }
}

