/*
 * Decompiled with CFR 0.152.
 */
package com.gargoylesoftware.htmlunit.html;

import com.gargoylesoftware.htmlunit.Page;
import com.gargoylesoftware.htmlunit.WebClient;
import com.gargoylesoftware.htmlunit.WebClientUtil;
import com.gargoylesoftware.htmlunit.html.HtmlElement;
import java.io.IOException;
import java.util.Arrays;
import java.util.HashSet;

public class HtmlElementUtil {
    public static Page click(HtmlElement element) throws IOException {
        if (element == null) {
            return null;
        }
        try {
            Page page = element.click();
            return page;
        }
        finally {
            WebClient webClient = element.getPage().getWebClient();
            WebClientUtil.waitForJSExec(webClient);
        }
    }

    public static boolean hasClassName(HtmlElement element, String className) {
        String classAttribute = element.getAttribute("class");
        HashSet<String> classes = new HashSet<String>(Arrays.asList(classAttribute.split(" ")));
        return classes.contains(className);
    }
}

