/*
 * Decompiled with CFR 0.152.
 */
package org.htmlunit.xpath.axes;

import javax.xml.transform.TransformerException;
import org.htmlunit.xpath.Expression;
import org.htmlunit.xpath.XPathVisitor;
import org.htmlunit.xpath.axes.FilterExprWalker;
import org.htmlunit.xpath.axes.HasPositionalPredChecker;
import org.htmlunit.xpath.axes.LocPathIterator;
import org.htmlunit.xpath.axes.PathComponent;
import org.htmlunit.xpath.axes.UnionChildIterator;
import org.htmlunit.xpath.axes.WalkerFactory;
import org.htmlunit.xpath.axes.WalkingIterator;
import org.htmlunit.xpath.compiler.Compiler;
import org.htmlunit.xpath.compiler.OpMap;
import org.htmlunit.xpath.xml.dtm.DTM;
import org.htmlunit.xpath.xml.dtm.DTMIterator;
import org.htmlunit.xpath.xml.utils.WrappedRuntimeException;

public class UnionPathIterator
extends LocPathIterator
implements Cloneable,
DTMIterator,
PathComponent {
    protected LocPathIterator[] exprs_;
    protected DTMIterator[] iterators_;

    @Override
    public void setRoot(int context, Object environment) {
        super.setRoot(context, environment);
        try {
            if (null != this.exprs_) {
                int n = this.exprs_.length;
                DTMIterator[] newIters = new DTMIterator[n];
                for (int i = 0; i < n; ++i) {
                    DTMIterator iter;
                    newIters[i] = iter = this.exprs_[i].asIterator(this.m_execContext, context);
                    iter.nextNode();
                }
                this.iterators_ = newIters;
            }
        }
        catch (Exception e) {
            throw new WrappedRuntimeException(e);
        }
    }

    @Override
    public void detach() {
        if (null != this.iterators_) {
            for (DTMIterator iterator : this.iterators_) {
                iterator.detach();
            }
            this.iterators_ = null;
        }
    }

    public UnionPathIterator(Compiler compiler, int opPos) throws TransformerException {
        opPos = OpMap.getFirstChildPos(opPos);
        this.loadLocationPaths(compiler, opPos, 0);
    }

    public static LocPathIterator createUnionIterator(Compiler compiler, int opPos) throws TransformerException {
        UnionPathIterator upi = new UnionPathIterator(compiler, opPos);
        int nPaths = upi.exprs_.length;
        boolean isAllChildIterators = true;
        for (int i = 0; i < nPaths; ++i) {
            LocPathIterator lpi = upi.exprs_[i];
            if (lpi.getAxis() != 3) {
                isAllChildIterators = false;
                break;
            }
            if (!HasPositionalPredChecker.check(lpi)) continue;
            isAllChildIterators = false;
            break;
        }
        if (isAllChildIterators) {
            UnionChildIterator uci = new UnionChildIterator();
            for (int i = 0; i < nPaths; ++i) {
                LocPathIterator lpi = upi.exprs_[i];
                uci.addNodeTest(lpi);
            }
            return uci;
        }
        return upi;
    }

    @Override
    public int getAnalysisBits() {
        int bits = 0;
        if (this.exprs_ != null) {
            for (LocPathIterator expr : this.exprs_) {
                int bit = expr.getAnalysisBits();
                bits |= bit;
            }
        }
        return bits;
    }

    @Override
    public Object clone() throws CloneNotSupportedException {
        UnionPathIterator clone = (UnionPathIterator)super.clone();
        if (this.iterators_ != null) {
            int n = this.iterators_.length;
            clone.iterators_ = new DTMIterator[n];
            for (int i = 0; i < n; ++i) {
                clone.iterators_[i] = (DTMIterator)this.iterators_[i].clone();
            }
        }
        return clone;
    }

    protected LocPathIterator createDTMIterator(Compiler compiler, int opPos) throws TransformerException {
        return (LocPathIterator)WalkerFactory.newDTMIterator(compiler, opPos, compiler.getLocationPathDepth() <= 0);
    }

    protected void loadLocationPaths(Compiler compiler, int opPos, int count) throws TransformerException {
        int steptype = compiler.getOp(opPos);
        if (steptype == 28) {
            this.loadLocationPaths(compiler, compiler.getNextOpPos(opPos), count + 1);
            this.exprs_[count] = this.createDTMIterator(compiler, opPos);
            this.exprs_[count].exprSetParent(this);
        } else {
            switch (steptype) {
                case 22: 
                case 23: 
                case 24: {
                    this.loadLocationPaths(compiler, compiler.getNextOpPos(opPos), count + 1);
                    WalkingIterator iter = new WalkingIterator(compiler.getNamespaceContext());
                    iter.exprSetParent(this);
                    if (compiler.getLocationPathDepth() <= 0) {
                        iter.setIsTopLevel(true);
                    }
                    iter.m_firstWalker = new FilterExprWalker(iter);
                    iter.m_firstWalker.init(compiler, opPos, steptype);
                    this.exprs_[count] = iter;
                    break;
                }
                default: {
                    this.exprs_ = new LocPathIterator[count];
                }
            }
        }
    }

    @Override
    public int nextNode() {
        if (this.m_foundLast) {
            return -1;
        }
        int earliestNode = -1;
        if (null != this.iterators_) {
            int n = this.iterators_.length;
            int iteratorUsed = -1;
            for (int i = 0; i < n; ++i) {
                int node = this.iterators_[i].getCurrentNode();
                if (-1 == node) continue;
                if (-1 == earliestNode) {
                    iteratorUsed = i;
                    earliestNode = node;
                    continue;
                }
                if (node == earliestNode) {
                    this.iterators_[i].nextNode();
                    continue;
                }
                DTM dtm = this.getDTM(node);
                if (!dtm.isNodeAfter(node, earliestNode)) continue;
                iteratorUsed = i;
                earliestNode = node;
            }
            if (-1 != earliestNode) {
                this.iterators_[iteratorUsed].nextNode();
                this.incrementCurrentPos();
            } else {
                this.m_foundLast = true;
            }
        }
        this.m_lastFetched = earliestNode;
        return earliestNode;
    }

    @Override
    public int getAxis() {
        return -1;
    }

    @Override
    public void callVisitors(XPathVisitor visitor) {
        if (visitor.visitUnionPath() && null != this.exprs_) {
            for (LocPathIterator expr : this.exprs_) {
                expr.callVisitors(visitor);
            }
        }
    }

    @Override
    public boolean deepEquals(Expression expr) {
        if (!super.deepEquals(expr)) {
            return false;
        }
        UnionPathIterator upi = (UnionPathIterator)expr;
        if (null != this.exprs_) {
            int n = this.exprs_.length;
            if (null == upi.exprs_ || upi.exprs_.length != n) {
                return false;
            }
            for (int i = 0; i < n; ++i) {
                if (this.exprs_[i].deepEquals(upi.exprs_[i])) continue;
                return false;
            }
        } else {
            return null == upi.exprs_;
        }
        return true;
    }
}

