/*
 * Decompiled with CFR 0.152.
 */
package org.htmlunit.javascript.host.intl;

import hidden.jth.org.apache.commons.lang3.StringUtils;
import java.text.DecimalFormat;
import java.text.DecimalFormatSymbols;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.htmlunit.BrowserVersion;
import org.htmlunit.corejs.javascript.Context;
import org.htmlunit.corejs.javascript.Function;
import org.htmlunit.corejs.javascript.FunctionObject;
import org.htmlunit.corejs.javascript.NativeArray;
import org.htmlunit.corejs.javascript.Scriptable;
import org.htmlunit.javascript.HtmlUnitScriptable;
import org.htmlunit.javascript.JavaScriptEngine;
import org.htmlunit.javascript.configuration.JsxClass;
import org.htmlunit.javascript.configuration.JsxConstructor;
import org.htmlunit.javascript.configuration.JsxFunction;
import org.htmlunit.javascript.host.Window;

@JsxClass
public class NumberFormat
extends HtmlUnitScriptable {
    private static final ConcurrentHashMap<String, String> CHROME_FORMATS_ = new ConcurrentHashMap();
    private static final ConcurrentHashMap<String, String> EDGE_FORMATS_ = new ConcurrentHashMap();
    private static final ConcurrentHashMap<String, String> FF_FORMATS_ = new ConcurrentHashMap();
    private static final ConcurrentHashMap<String, String> FF_ESR_FORMATS_ = new ConcurrentHashMap();
    private transient NumberFormatHelper formatter_;

    public NumberFormat() {
    }

    private NumberFormat(String[] locales, BrowserVersion browserVersion) {
        ConcurrentHashMap<String, String> formats = browserVersion.isChrome() ? CHROME_FORMATS_ : (browserVersion.isEdge() ? EDGE_FORMATS_ : (browserVersion.isFirefoxESR() ? FF_ESR_FORMATS_ : FF_FORMATS_));
        String locale = "";
        String pattern = null;
        for (String l : locales) {
            pattern = NumberFormat.getPattern(formats, l);
            if (pattern == null) continue;
            locale = l;
        }
        if (pattern == null) {
            pattern = (String)formats.get("");
            if (locales.length > 0) {
                locale = locales[0];
            }
        }
        this.formatter_ = new NumberFormatHelper(locale, browserVersion, pattern);
    }

    private static String getPattern(Map<String, String> formats, String locale) {
        if ("no-NO-NY".equals(locale)) {
            throw JavaScriptEngine.rangeError("Invalid language tag: " + locale);
        }
        String pattern = formats.get(locale);
        if (pattern == null && locale.indexOf(45) != -1) {
            pattern = formats.get(locale.substring(0, locale.indexOf(45)));
        }
        return pattern;
    }

    @JsxConstructor
    public static Scriptable jsConstructor(Context cx, Scriptable scope, Object[] args, Function ctorObj, boolean inNewExpr) {
        String[] locales;
        if (args.length == 0) {
            locales = new String[]{""};
        } else if (args[0] instanceof NativeArray) {
            NativeArray array = (NativeArray)args[0];
            locales = new String[(int)array.getLength()];
            for (int i = 0; i < locales.length; ++i) {
                locales[i] = JavaScriptEngine.toString(array.get(i));
            }
        } else {
            locales = new String[]{JavaScriptEngine.toString(args[0])};
        }
        Window window = NumberFormat.getWindow(ctorObj);
        NumberFormat format = new NumberFormat(locales, window.getBrowserVersion());
        format.setParentScope(window);
        format.setPrototype(((FunctionObject)ctorObj).getClassPrototype());
        return format;
    }

    @JsxFunction
    public String format(Object object) {
        double number = JavaScriptEngine.toNumber(object);
        return this.formatter_.format(number);
    }

    @JsxFunction
    public Scriptable resolvedOptions() {
        return Context.getCurrentContext().newObject(this.getParentScope());
    }

    static {
        HashMap<String, String> commonFormats = new HashMap<String, String>();
        commonFormats.put("", "");
        commonFormats.put("ar", "\u066c\u066b\u0660");
        commonFormats.put("ar-DZ", ".,");
        commonFormats.put("ar-LY", ".,");
        commonFormats.put("ar-MA", ".,");
        commonFormats.put("ar-TN", ".,");
        commonFormats.put("id", ".,");
        commonFormats.put("de-AT", "\u00a0");
        commonFormats.put("de-CH", "\u2019");
        commonFormats.put("en-ZA", "\u00a0,");
        commonFormats.put("es-CR", "\u00a0,");
        commonFormats.put("fr-LU", ".,");
        commonFormats.put("hi-IN", ",.0");
        commonFormats.put("it-CH", "\u2019");
        commonFormats.put("pt-PT", "\u00a0,");
        commonFormats.put("sq", "\u00a0,");
        commonFormats.put("ar-AE", ",.0");
        commonFormats.put("fr", "\u202f,");
        commonFormats.put("fr-CA", "\u00a0,");
        FF_ESR_FORMATS_.putAll(commonFormats);
        commonFormats.put("ar", ",.0");
        commonFormats.put("ar-BH", "\u066c\u066b\u0660");
        commonFormats.put("ar-EG", "\u066c\u066b\u0660");
        commonFormats.put("ar-IQ", "\u066c\u066b\u0660");
        commonFormats.put("ar-JO", "\u066c\u066b\u0660");
        commonFormats.put("ar-KW", "\u066c\u066b\u0660");
        commonFormats.put("ar-LB", "\u066c\u066b\u0660");
        commonFormats.put("ar-OM", "\u066c\u066b\u0660");
        commonFormats.put("ar-QA", "\u066c\u066b\u0660");
        commonFormats.put("ar-SA", "\u066c\u066b\u0660");
        commonFormats.put("ar-SD", "\u066c\u066b\u0660");
        commonFormats.put("ar-SY", "\u066c\u066b\u0660");
        commonFormats.put("ar-YE", "\u066c\u066b\u0660");
        FF_FORMATS_.putAll(commonFormats);
        commonFormats.put("be", ",.");
        commonFormats.put("en-ZA", ",.");
        commonFormats.put("mk", ",.");
        commonFormats.put("is", ",.");
        CHROME_FORMATS_.putAll(commonFormats);
        CHROME_FORMATS_.put("sq", ",.");
        EDGE_FORMATS_.putAll(commonFormats);
    }

    static final class NumberFormatHelper {
        private final DecimalFormat formatter_;

        NumberFormatHelper(String localeName, BrowserVersion browserVersion, String pattern) {
            Locale locale = browserVersion.getBrowserLocale();
            if (StringUtils.isNotEmpty(localeName)) {
                locale = Locale.forLanguageTag(localeName);
            }
            DecimalFormatSymbols symbols = new DecimalFormatSymbols(locale);
            if (pattern.length() > 0) {
                char groupingSeparator = pattern.charAt(0);
                if (groupingSeparator != ' ') {
                    symbols.setGroupingSeparator(groupingSeparator);
                }
                if (pattern.length() > 1) {
                    char zeroDigit;
                    char decimalSeparator = pattern.charAt(1);
                    if (decimalSeparator != ' ') {
                        symbols.setDecimalSeparator(decimalSeparator);
                    }
                    if (pattern.length() > 2 && (zeroDigit = pattern.charAt(2)) != ' ') {
                        symbols.setZeroDigit(zeroDigit);
                    }
                }
            }
            this.formatter_ = new DecimalFormat("#,##0.###", symbols);
        }

        String format(double number) {
            return this.formatter_.format(number);
        }
    }
}

