/*
 * Decompiled with CFR 0.152.
 */
package org.htmlunit.javascript.host.html;

import org.htmlunit.corejs.javascript.NativePromise;
import org.htmlunit.html.HtmlMedia;
import org.htmlunit.javascript.configuration.JsxClass;
import org.htmlunit.javascript.configuration.JsxConstant;
import org.htmlunit.javascript.configuration.JsxConstructor;
import org.htmlunit.javascript.configuration.JsxFunction;
import org.htmlunit.javascript.configuration.JsxGetter;
import org.htmlunit.javascript.configuration.JsxSetter;
import org.htmlunit.javascript.host.dom.DOMException;
import org.htmlunit.javascript.host.html.HTMLElement;

@JsxClass
public class HTMLMediaElement
extends HTMLElement {
    @JsxConstant
    public static final int HAVE_NOTHING = 0;
    @JsxConstant
    public static final int HAVE_METADATA = 1;
    @JsxConstant
    public static final int HAVE_CURRENT_DATA = 2;
    @JsxConstant
    public static final int HAVE_FUTURE_DATA = 3;
    @JsxConstant
    public static final int HAVE_ENOUGH_DATA = 4;
    @JsxConstant
    public static final int NETWORK_EMPTY = 0;
    @JsxConstant
    public static final int NETWORK_IDLE = 1;
    @JsxConstant
    public static final int NETWORK_LOADING = 2;
    @JsxConstant
    public static final int NETWORK_NO_SOURCE = 3;

    @Override
    @JsxConstructor
    public void jsConstructor() {
        super.jsConstructor();
    }

    @JsxFunction
    public String canPlayType(String type) {
        HtmlMedia element = (HtmlMedia)this.getDomNodeOrNull();
        if (element == null) {
            return "maybe";
        }
        return element.canPlayType(type);
    }

    @JsxFunction
    public NativePromise play() {
        return this.setupRejectedPromise(() -> new DOMException("HtmlUnit does not support media play().", 8));
    }

    @JsxFunction
    public void pause() {
    }

    @JsxFunction
    public void load() {
    }

    @Override
    @JsxGetter
    public int getNodeType() {
        HtmlMedia element = (HtmlMedia)this.getDomNodeOrNull();
        if (element == null) {
            return 1;
        }
        return element.getNodeType();
    }

    @Override
    @JsxGetter
    public String getNodeName() {
        return this.getNodeNameCustomize();
    }

    protected String getNodeNameCustomize() {
        HtmlMedia element = (HtmlMedia)this.getDomNodeOrNull();
        if (element == null) {
            return "MEDIA";
        }
        return element.getNodeName();
    }

    @JsxGetter
    public String getSrc() {
        HtmlMedia media = (HtmlMedia)this.getDomNodeOrDie();
        return media.getSrc();
    }

    @JsxSetter
    public void setSrc(String src) {
        HtmlMedia media = (HtmlMedia)this.getDomNodeOrDie();
        media.setSrc(src);
    }

    @JsxGetter
    public String getCurrentSrc() {
        HtmlMedia media = (HtmlMedia)this.getDomNodeOrDie();
        return media.getCurrentSrc();
    }
}

