/*
 * Decompiled with CFR 0.152.
 */
package org.htmlunit.javascript.host.html;

import org.htmlunit.BrowserVersionFeatures;
import org.htmlunit.html.BaseFrameElement;
import org.htmlunit.html.FrameWindow;
import org.htmlunit.html.HtmlInlineFrame;
import org.htmlunit.javascript.configuration.JsxClass;
import org.htmlunit.javascript.configuration.JsxConstructor;
import org.htmlunit.javascript.configuration.JsxGetter;
import org.htmlunit.javascript.configuration.JsxSetter;
import org.htmlunit.javascript.host.Window;
import org.htmlunit.javascript.host.WindowProxy;
import org.htmlunit.javascript.host.event.Event;
import org.htmlunit.javascript.host.html.DocumentProxy;
import org.htmlunit.javascript.host.html.HTMLElement;

@JsxClass(domClass=HtmlInlineFrame.class)
public class HTMLIFrameElement
extends HTMLElement {
    private boolean isAttachedToPageDuringOnload_;

    @Override
    @JsxConstructor
    public void jsConstructor() {
        super.jsConstructor();
    }

    @JsxGetter
    public String getSrc() {
        return this.getFrame().getSrcAttribute();
    }

    @JsxSetter
    public void setSrc(String src) {
        this.getFrame().setSrcAttribute(src);
        this.isAttachedToPageDuringOnload_ = false;
    }

    @JsxGetter
    public DocumentProxy getContentDocument() {
        FrameWindow frameWindow = this.getFrame().getEnclosedWindow();
        if (FrameWindow.PageDenied.NONE != frameWindow.getPageDenied()) {
            return null;
        }
        return ((Window)frameWindow.getScriptableObject()).getDocument_js();
    }

    @JsxGetter
    public WindowProxy getContentWindow() {
        FrameWindow frameWin = this.getFrame().getEnclosedWindow();
        if (frameWin.isClosed()) {
            return null;
        }
        return Window.getProxy(frameWin);
    }

    @Override
    @JsxGetter
    public String getName() {
        return this.getFrame().getNameAttribute();
    }

    @Override
    @JsxSetter
    public void setName(String name) {
        this.getFrame().setNameAttribute(name);
    }

    private BaseFrameElement getFrame() {
        return (BaseFrameElement)this.getDomNodeOrDie();
    }

    @Override
    public void setOnload(Object eventHandler) {
        super.setOnload(eventHandler);
        this.isAttachedToPageDuringOnload_ = this.getDomNodeOrDie().isAttachedToPage();
    }

    @JsxGetter
    public String getAlign() {
        return this.getAlign(true);
    }

    @JsxSetter
    public void setAlign(String align) {
        this.setAlign(align, false);
    }

    @JsxGetter(propertyName="width")
    public String getWidth_js() {
        return this.getWidthOrHeight("width", Boolean.TRUE);
    }

    @JsxSetter(propertyName="width")
    public void setWidth_js(String width) {
        this.setWidthOrHeight("width", width, true);
    }

    @JsxGetter(propertyName="height")
    public String getHeight_js() {
        return this.getWidthOrHeight("height", Boolean.TRUE);
    }

    @JsxSetter(propertyName="height")
    public void setHeight_js(String height) {
        this.setWidthOrHeight("height", height, true);
    }

    @Override
    public void executeEventLocally(Event event) {
        if ("load" != event.getType() || !this.isAttachedToPageDuringOnload_ || this.getBrowserVersion().hasFeature(BrowserVersionFeatures.JS_IFRAME_ALWAYS_EXECUTE_ONLOAD)) {
            super.executeEventLocally(event);
        }
    }

    public void onRefresh() {
        this.isAttachedToPageDuringOnload_ = false;
    }
}

