/*
 * Decompiled with CFR 0.152.
 */
package org.htmlunit.javascript.host.html;

import java.util.ArrayList;
import java.util.List;
import org.htmlunit.corejs.javascript.Callable;
import org.htmlunit.corejs.javascript.Context;
import org.htmlunit.corejs.javascript.Scriptable;
import org.htmlunit.html.DomElement;
import org.htmlunit.html.DomNode;
import org.htmlunit.html.HtmlForm;
import org.htmlunit.html.HtmlInput;
import org.htmlunit.javascript.JavaScriptEngine;
import org.htmlunit.javascript.configuration.JsxClass;
import org.htmlunit.javascript.configuration.JsxConstructor;
import org.htmlunit.javascript.configuration.JsxFunction;
import org.htmlunit.javascript.configuration.JsxGetter;
import org.htmlunit.javascript.configuration.JsxSymbol;
import org.htmlunit.javascript.host.dom.AbstractList;
import org.htmlunit.javascript.host.html.HTMLCollection;

@JsxClass
public class HTMLAllCollection
extends AbstractList
implements Callable {
    public HTMLAllCollection() {
    }

    @JsxConstructor
    public void jsConstructor() {
    }

    public HTMLAllCollection(DomNode parentScope) {
        super(parentScope, false, null);
    }

    @JsxFunction
    public Object item(Object index) {
        double numb;
        if (index instanceof String) {
            String name = (String)index;
            Scriptable result = this.namedItem(name);
            if (null != result && !JavaScriptEngine.isUndefined(result)) {
                return result;
            }
            numb = JavaScriptEngine.toNumber(index);
            if (Double.isNaN(numb)) {
                return null;
            }
        } else {
            numb = JavaScriptEngine.toNumber(index);
        }
        if (numb < 0.0) {
            return null;
        }
        if (Double.isInfinite(numb) || numb != Math.floor(numb)) {
            return null;
        }
        Object object = this.get((int)numb, (Scriptable)this);
        if (object == NOT_FOUND) {
            return null;
        }
        return object;
    }

    @JsxFunction
    public final Scriptable namedItem(String name) {
        List<DomNode> elements = this.getElements();
        ArrayList<DomElement> matching = new ArrayList<DomElement>();
        for (DomNode next : elements) {
            DomElement elem;
            if (!(next instanceof DomElement) || !name.equals((elem = (DomElement)next).getAttributeDirect("name")) && !name.equals(elem.getId())) continue;
            matching.add(elem);
        }
        if (matching.size() == 1) {
            return this.getScriptableForElement(matching.get(0));
        }
        if (matching.isEmpty()) {
            return null;
        }
        DomNode domNode = this.getDomNodeOrNull();
        ArrayList<DomNode> nodes = new ArrayList<DomNode>(matching);
        HTMLCollection collection = new HTMLCollection(domNode, nodes);
        collection.setAvoidObjectDetection(true);
        return collection;
    }

    @Override
    public Object call(Context cx, Scriptable scope, Scriptable thisObj, Object[] args) {
        boolean nullIfNotFound = false;
        if (args[0] instanceof Number) {
            double val = ((Number)args[0]).doubleValue();
            if (val != (double)((int)val)) {
                return null;
            }
            if (val >= 0.0) {
                nullIfNotFound = true;
            }
        } else {
            String val = JavaScriptEngine.toString(args[0]);
            try {
                args[0] = Integer.parseInt(val);
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
        if (args.length == 0) {
            throw JavaScriptEngine.reportRuntimeError("Zero arguments; need an index or a key.");
        }
        Object value = this.getIt(args[0]);
        if (value == NOT_FOUND) {
            value = null;
        }
        if (nullIfNotFound && JavaScriptEngine.isUndefined(value)) {
            return null;
        }
        return value;
    }

    @Override
    protected Object equivalentValues(Object value) {
        if (value == null || JavaScriptEngine.isUndefined(value)) {
            return Boolean.TRUE;
        }
        return super.equivalentValues(value);
    }

    @JsxSymbol
    public Scriptable iterator() {
        return JavaScriptEngine.newArrayIteratorTypeValues(this.getParentScope(), this);
    }

    @Override
    @JsxGetter
    public final int getLength() {
        return super.getLength();
    }

    @Override
    protected Object getWithPreemptionByName(String name, List<DomNode> elements) {
        ArrayList<DomNode> matchingElements = new ArrayList<DomNode>();
        boolean searchName = this.isGetWithPreemptionSearchName();
        for (DomNode next : elements) {
            String nodeName;
            if (!(next instanceof DomElement) || !searchName && !(next instanceof HtmlInput) && !(next instanceof HtmlForm) || !name.equals(nodeName = ((DomElement)next).getAttributeDirect("name"))) continue;
            matchingElements.add(next);
        }
        if (matchingElements.isEmpty()) {
            return NOT_FOUND;
        }
        if (matchingElements.size() == 1) {
            return this.getScriptableForElement(matchingElements.get(0));
        }
        DomNode domNode = this.getDomNodeOrNull();
        HTMLCollection collection = new HTMLCollection(domNode, matchingElements);
        collection.setAvoidObjectDetection(true);
        return collection;
    }

    protected boolean isGetWithPreemptionSearchName() {
        return true;
    }

    @Override
    protected HTMLCollection create(DomNode parentScope, List<DomNode> initialElements) {
        return new HTMLCollection(parentScope, initialElements);
    }
}

