/*
 * Decompiled with CFR 0.152.
 */
package org.htmlunit.javascript.host.dom;

import org.htmlunit.corejs.javascript.Context;
import org.htmlunit.corejs.javascript.Function;
import org.htmlunit.corejs.javascript.Scriptable;
import org.htmlunit.html.DomCharacterData;
import org.htmlunit.html.DomElement;
import org.htmlunit.javascript.JavaScriptEngine;
import org.htmlunit.javascript.configuration.JsxClass;
import org.htmlunit.javascript.configuration.JsxConstructor;
import org.htmlunit.javascript.configuration.JsxFunction;
import org.htmlunit.javascript.configuration.JsxGetter;
import org.htmlunit.javascript.configuration.JsxSetter;
import org.htmlunit.javascript.host.Element;
import org.htmlunit.javascript.host.dom.Node;

@JsxClass
public class CharacterData
extends Node {
    @Override
    @JsxConstructor
    public void jsConstructor() {
        super.jsConstructor();
    }

    @JsxGetter
    public String getData() {
        return this.getDomCharacterDataOrDie().getData();
    }

    @JsxSetter
    public void setData(String newValue) {
        this.getDomCharacterDataOrDie().setData(newValue);
    }

    @JsxGetter
    public int getLength() {
        return this.getDomCharacterDataOrDie().getLength();
    }

    @JsxFunction
    public void appendData(String arg) {
        this.getDomCharacterDataOrDie().appendData(arg);
    }

    @JsxFunction
    public void deleteData(int offset, int count) {
        if (offset < 0) {
            throw JavaScriptEngine.asJavaScriptException(this.getWindow(), "Provided offset: " + offset + " is less than zero.", 1);
        }
        DomCharacterData domCharacterData = this.getDomCharacterDataOrDie();
        if (offset > domCharacterData.getLength()) {
            throw JavaScriptEngine.asJavaScriptException(this.getWindow(), "Provided offset: " + offset + " is greater than length.", 1);
        }
        domCharacterData.deleteData(offset, count);
    }

    @JsxFunction
    public void insertData(int offset, String arg) {
        this.getDomCharacterDataOrDie().insertData(offset, arg);
    }

    @JsxFunction
    public void replaceData(int offset, int count, String arg) {
        this.getDomCharacterDataOrDie().replaceData(offset, count, arg);
    }

    @JsxFunction
    public String substringData(int offset, int count) {
        return this.getDomCharacterDataOrDie().substringData(offset, count);
    }

    private DomCharacterData getDomCharacterDataOrDie() {
        return (DomCharacterData)super.getDomNodeOrDie();
    }

    @JsxGetter
    public Element getNextElementSibling() {
        DomElement child = this.getDomNodeOrDie().getNextElementSibling();
        if (child != null) {
            return (Element)child.getScriptableObject();
        }
        return null;
    }

    @JsxGetter
    public Element getPreviousElementSibling() {
        DomElement child = this.getDomNodeOrDie().getPreviousElementSibling();
        if (child != null) {
            return (Element)child.getScriptableObject();
        }
        return null;
    }

    @Override
    @JsxFunction
    public void remove() {
        super.remove();
    }

    @JsxFunction
    public static void before(Context context, Scriptable scope, Scriptable thisObj, Object[] args, Function function) {
        Node.before(context, thisObj, args, function);
    }

    @JsxFunction
    public static void after(Context context, Scriptable scope, Scriptable thisObj, Object[] args, Function function) {
        Node.after(context, thisObj, args, function);
    }

    @JsxFunction
    public static void replaceWith(Context context, Scriptable scope, Scriptable thisObj, Object[] args, Function function) {
        Node.replaceWith(context, thisObj, args, function);
    }
}

