/*
 * Decompiled with CFR 0.152.
 */
package org.htmlunit.javascript.host;

import java.util.ArrayList;
import org.htmlunit.BrowserVersionFeatures;
import org.htmlunit.WebClient;
import org.htmlunit.corejs.javascript.Scriptable;
import org.htmlunit.javascript.HtmlUnitScriptable;
import org.htmlunit.javascript.JavaScriptEngine;
import org.htmlunit.javascript.configuration.JsxClass;
import org.htmlunit.javascript.configuration.JsxConstructor;
import org.htmlunit.javascript.configuration.JsxFunction;
import org.htmlunit.javascript.configuration.JsxGetter;
import org.htmlunit.javascript.configuration.SupportedBrowser;
import org.htmlunit.javascript.host.MimeType;
import org.htmlunit.javascript.host.MimeTypeArray;
import org.htmlunit.javascript.host.Plugin;
import org.htmlunit.javascript.host.PluginArray;
import org.htmlunit.javascript.host.geo.Geolocation;
import org.htmlunit.javascript.host.media.MediaDevices;
import org.htmlunit.javascript.host.network.NetworkInformation;
import org.htmlunit.util.StringUtils;

@JsxClass
public class Navigator
extends HtmlUnitScriptable {
    private PluginArray plugins_;
    private MimeTypeArray mimeTypes_;
    private MediaDevices mediaDevices_;

    @JsxConstructor
    public void jsConstructor() {
    }

    @JsxGetter
    public String getAppCodeName() {
        return this.getBrowserVersion().getApplicationCodeName();
    }

    @JsxGetter
    public String getAppName() {
        return this.getBrowserVersion().getApplicationName();
    }

    @JsxGetter
    public String getAppVersion() {
        return this.getBrowserVersion().getApplicationVersion();
    }

    @JsxGetter
    public String getLanguage() {
        return this.getBrowserVersion().getBrowserLanguage();
    }

    @JsxGetter
    public Scriptable getLanguages() {
        String[] parts;
        String acceptLang = this.getBrowserVersion().getAcceptLanguageHeader();
        if (StringUtils.isEmptyOrNull(acceptLang)) {
            return JavaScriptEngine.newArray((Scriptable)this, 0);
        }
        ArrayList<String> res = new ArrayList<String>();
        for (String part : parts = StringUtils.splitAtComma(acceptLang)) {
            if (StringUtils.isEmptyOrNull(part)) continue;
            String lang = hidden.jth.org.apache.commons.lang3.StringUtils.substringBefore(part, ";").trim();
            if (StringUtils.isEmptyOrNull(part)) continue;
            res.add(lang);
        }
        return JavaScriptEngine.newArray((Scriptable)this, res.toArray());
    }

    @JsxGetter
    public boolean isCookieEnabled() {
        return this.getWindow().getWebWindow().getWebClient().getCookieManager().isCookiesEnabled();
    }

    @JsxGetter
    public boolean isOnLine() {
        return this.getBrowserVersion().isOnLine();
    }

    @JsxGetter
    public String getPlatform() {
        return this.getBrowserVersion().getPlatform();
    }

    @JsxGetter
    public String getProduct() {
        return "Gecko";
    }

    @JsxGetter
    public String getProductSub() {
        return this.getBrowserVersion().getProductSub();
    }

    @JsxGetter
    public String getUserAgent() {
        return this.getBrowserVersion().getUserAgent();
    }

    @JsxGetter
    public PluginArray getPlugins() {
        this.initPluginsAndMimeTypes();
        return this.plugins_;
    }

    private void initPluginsAndMimeTypes() {
        if (this.plugins_ != null) {
            return;
        }
        this.plugins_ = new PluginArray();
        this.plugins_.setParentScope(this);
        this.plugins_.setPrototype(this.getPrototype(PluginArray.class));
        Plugin plugin = new Plugin("PDF Viewer", "Portable Document Format", "internal-pdf-viewer");
        plugin.setParentScope(this);
        plugin.setPrototype(this.getPrototype(Plugin.class));
        this.mimeTypes_ = new MimeTypeArray();
        this.mimeTypes_.setParentScope(this);
        this.mimeTypes_.setPrototype(this.getPrototype(MimeTypeArray.class));
        MimeType mimeTypeAppPdf = new MimeType("application/pdf", "Portable Document Format", "pdf", plugin);
        mimeTypeAppPdf.setParentScope(this);
        mimeTypeAppPdf.setPrototype(this.getPrototype(MimeType.class));
        this.mimeTypes_.add(mimeTypeAppPdf);
        MimeType mimeTypeTxtPdf = new MimeType("text/pdf", "Portable Document Format", "pdf", plugin);
        mimeTypeTxtPdf.setParentScope(this);
        mimeTypeTxtPdf.setPrototype(this.getPrototype(MimeType.class));
        this.mimeTypes_.add(mimeTypeTxtPdf);
        plugin.add(mimeTypeAppPdf);
        plugin.add(mimeTypeTxtPdf);
        this.plugins_.add(plugin);
        plugin = new Plugin("Chrome PDF Viewer", "Portable Document Format", "internal-pdf-viewer");
        plugin.setParentScope(this);
        plugin.setPrototype(this.getPrototype(Plugin.class));
        plugin.add(mimeTypeAppPdf);
        plugin.add(mimeTypeTxtPdf);
        this.plugins_.add(plugin);
        plugin = new Plugin("Chromium PDF Viewer", "Portable Document Format", "internal-pdf-viewer");
        plugin.setParentScope(this);
        plugin.setPrototype(this.getPrototype(Plugin.class));
        plugin.add(mimeTypeAppPdf);
        plugin.add(mimeTypeTxtPdf);
        this.plugins_.add(plugin);
        plugin = new Plugin("Microsoft Edge PDF Viewer", "Portable Document Format", "internal-pdf-viewer");
        plugin.setParentScope(this);
        plugin.setPrototype(this.getPrototype(Plugin.class));
        plugin.add(mimeTypeAppPdf);
        plugin.add(mimeTypeTxtPdf);
        this.plugins_.add(plugin);
        plugin = new Plugin("WebKit built-in PDF", "Portable Document Format", "internal-pdf-viewer");
        plugin.setParentScope(this);
        plugin.setPrototype(this.getPrototype(Plugin.class));
        plugin.add(mimeTypeAppPdf);
        plugin.add(mimeTypeTxtPdf);
        this.plugins_.add(plugin);
    }

    @JsxGetter
    public MimeTypeArray getMimeTypes() {
        this.initPluginsAndMimeTypes();
        return this.mimeTypes_;
    }

    @JsxFunction
    public boolean javaEnabled() {
        return false;
    }

    @JsxFunction(value={SupportedBrowser.FF, SupportedBrowser.FF_ESR})
    public boolean taintEnabled() {
        return false;
    }

    @JsxGetter
    public Geolocation getGeolocation() {
        Geolocation geolocation = new Geolocation();
        geolocation.setPrototype(this.getPrototype(geolocation.getClass()));
        geolocation.setParentScope(this.getParentScope());
        return geolocation;
    }

    @JsxGetter
    public boolean isPdfViewerEnabled() {
        return true;
    }

    @JsxGetter(value={SupportedBrowser.FF, SupportedBrowser.FF_ESR})
    public String getBuildID() {
        return this.getBrowserVersion().getBuildId();
    }

    @JsxGetter
    public String getVendor() {
        return this.getBrowserVersion().getVendor();
    }

    @JsxGetter
    public String getVendorSub() {
        return "";
    }

    @JsxGetter
    public Object getDoNotTrack() {
        WebClient client = this.getWindow().getWebWindow().getWebClient();
        if (client.getOptions().isDoNotTrackEnabled()) {
            return 1;
        }
        if (client.getBrowserVersion().hasFeature(BrowserVersionFeatures.JS_NAVIGATOR_DO_NOT_TRACK_UNSPECIFIED)) {
            return "unspecified";
        }
        return null;
    }

    @JsxGetter(value={SupportedBrowser.FF, SupportedBrowser.FF_ESR})
    public String getOscpu() {
        return "Windows NT 6.1";
    }

    @JsxGetter(value={SupportedBrowser.CHROME, SupportedBrowser.EDGE})
    public NetworkInformation getConnection() {
        NetworkInformation networkInformation = new NetworkInformation();
        networkInformation.setPrototype(this.getPrototype(networkInformation.getClass()));
        networkInformation.setParentScope(this.getParentScope());
        return networkInformation;
    }

    @JsxGetter
    public MediaDevices getMediaDevices() {
        if (this.mediaDevices_ == null) {
            this.mediaDevices_ = new MediaDevices();
            this.mediaDevices_.setPrototype(this.getPrototype(this.mediaDevices_.getClass()));
            this.mediaDevices_.setParentScope(this.getParentScope());
        }
        return this.mediaDevices_;
    }
}

