/*
 * Decompiled with CFR 0.152.
 */
package org.htmlunit.javascript.configuration;

import java.lang.annotation.Annotation;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.htmlunit.BrowserVersion;
import org.htmlunit.corejs.javascript.SymbolKey;
import org.htmlunit.javascript.HtmlUnitScriptable;
import org.htmlunit.javascript.JavaScriptEngine;
import org.htmlunit.javascript.configuration.ClassConfiguration;
import org.htmlunit.javascript.configuration.JsxClass;
import org.htmlunit.javascript.configuration.JsxClasses;
import org.htmlunit.javascript.configuration.JsxConstant;
import org.htmlunit.javascript.configuration.JsxConstructor;
import org.htmlunit.javascript.configuration.JsxConstructorAlias;
import org.htmlunit.javascript.configuration.JsxFunction;
import org.htmlunit.javascript.configuration.JsxGetter;
import org.htmlunit.javascript.configuration.JsxSetter;
import org.htmlunit.javascript.configuration.JsxStaticFunction;
import org.htmlunit.javascript.configuration.JsxStaticGetter;
import org.htmlunit.javascript.configuration.JsxSymbol;
import org.htmlunit.javascript.configuration.JsxSymbolConstant;
import org.htmlunit.javascript.configuration.SupportedBrowser;

public abstract class AbstractJavaScriptConfiguration {
    private static final Log LOG = LogFactory.getLog(AbstractJavaScriptConfiguration.class);
    private Map<Class<?>, Class<? extends HtmlUnitScriptable>> domJavaScriptMap_;
    private final ArrayList<ClassConfiguration> configuration_ = new ArrayList(this.getClasses().length);
    private ClassConfiguration scopeConfiguration_;

    protected AbstractJavaScriptConfiguration(BrowserVersion browser, Class<?> scopeClass) {
        for (Class<? extends HtmlUnitScriptable> klass : this.getClasses()) {
            ClassConfiguration config = AbstractJavaScriptConfiguration.getClassConfiguration(klass, browser);
            if (config == null) continue;
            this.configuration_.add(config);
            if (klass != scopeClass) continue;
            this.scopeConfiguration_ = config;
        }
    }

    protected abstract Class<? extends HtmlUnitScriptable>[] getClasses();

    public Iterable<ClassConfiguration> getAll() {
        return this.configuration_;
    }

    public static ClassConfiguration getClassConfiguration(Class<? extends HtmlUnitScriptable> klass, BrowserVersion browserVersion) {
        if (browserVersion != null) {
            SupportedBrowser expectedBrowser = browserVersion.isChrome() ? SupportedBrowser.CHROME : (browserVersion.isEdge() ? SupportedBrowser.EDGE : (browserVersion.isFirefoxESR() ? SupportedBrowser.FF_ESR : (browserVersion.isFirefox() ? SupportedBrowser.FF : SupportedBrowser.CHROME)));
            String hostClassName = klass.getName();
            JsxClasses jsxClasses = klass.getAnnotation(JsxClasses.class);
            if (jsxClasses != null) {
                if (klass.getAnnotation(JsxClass.class) != null) {
                    throw new RuntimeException("Invalid JsxClasses/JsxClass annotation; class '" + hostClassName + "' has both.");
                }
                JsxClass[] jsxClassValues = jsxClasses.value();
                if (jsxClassValues.length == 1) {
                    throw new RuntimeException("No need to specify JsxClasses with a single JsxClass for " + hostClassName);
                }
                HashSet domClasses = new HashSet();
                boolean isJsObject = false;
                String className = null;
                Class<? extends HtmlUnitScriptable> superClass = klass.getSuperclass();
                String extendedClassName = superClass.getAnnotation(JsxClass.class) == null && superClass.getAnnotation(JsxClasses.class) == null ? "" : superClass.getSimpleName();
                for (JsxClass jsxClass : jsxClassValues) {
                    if (jsxClass == null || !AbstractJavaScriptConfiguration.isSupported(jsxClass.value(), expectedBrowser)) continue;
                    domClasses.add(jsxClass.domClass());
                    if (jsxClass.isJSObject()) {
                        isJsObject = true;
                    }
                    if (jsxClass.className().isEmpty()) continue;
                    className = jsxClass.className();
                }
                ClassConfiguration classConfiguration = new ClassConfiguration(klass, domClasses.toArray(new Class[0]), isJsObject, className, extendedClassName);
                AbstractJavaScriptConfiguration.process(classConfiguration, expectedBrowser);
                return classConfiguration;
            }
            JsxClass jsxClass = klass.getAnnotation(JsxClass.class);
            if (jsxClass != null && AbstractJavaScriptConfiguration.isSupported(jsxClass.value(), expectedBrowser)) {
                Class<? extends HtmlUnitScriptable> superClass;
                String className;
                HashSet domClasses = new HashSet();
                Class<?> domClass = jsxClass.domClass();
                if (domClass != null && domClass != Object.class) {
                    domClasses.add(domClass);
                }
                if ((className = jsxClass.className()).isEmpty()) {
                    className = null;
                }
                String extendedClassName = (superClass = klass.getSuperclass()).getAnnotation(JsxClass.class) == null && superClass.getAnnotation(JsxClasses.class) == null ? "" : superClass.getSimpleName();
                ClassConfiguration classConfiguration = new ClassConfiguration(klass, domClasses.toArray(new Class[0]), jsxClass.isJSObject(), className, extendedClassName);
                AbstractJavaScriptConfiguration.process(classConfiguration, expectedBrowser);
                return classConfiguration;
            }
        }
        return null;
    }

    private static void process(ClassConfiguration classConfiguration, SupportedBrowser expectedBrowser) {
        ConcurrentHashMap<String, Method> allGetters = new ConcurrentHashMap<String, Method>();
        ConcurrentHashMap<String, Method> allSetters = new ConcurrentHashMap<String, Method>();
        try {
            classConfiguration.addSymbolConstant(SymbolKey.TO_STRING_TAG, classConfiguration.getHostClassSimpleName());
            for (Method method : classConfiguration.getHostClass().getDeclaredMethods()) {
                for (Annotation annotation : method.getAnnotations()) {
                    JsxConstructorAlias jsxConstructorAlias;
                    String name;
                    JsxSetter jsxSetter;
                    if (annotation instanceof JsxGetter) {
                        JsxGetter jsxGetter = (JsxGetter)annotation;
                        if (AbstractJavaScriptConfiguration.isSupported(jsxGetter.value(), expectedBrowser)) {
                            String property;
                            if (jsxGetter.propertyName().isEmpty()) {
                                int prefix = method.getName().startsWith("is") ? 2 : 3;
                                property = method.getName().substring(prefix);
                                property = Character.toLowerCase(property.charAt(0)) + property.substring(1);
                            } else {
                                property = jsxGetter.propertyName();
                            }
                            allGetters.put(property, method);
                        }
                    } else if (annotation instanceof JsxSetter && AbstractJavaScriptConfiguration.isSupported((jsxSetter = (JsxSetter)annotation).value(), expectedBrowser)) {
                        String property;
                        if (jsxSetter.propertyName().isEmpty()) {
                            property = method.getName().substring(3);
                            property = Character.toLowerCase(property.charAt(0)) + property.substring(1);
                        } else {
                            property = jsxSetter.propertyName();
                        }
                        allSetters.put(property, method);
                    }
                    if (annotation instanceof JsxSymbol) {
                        JsxSymbol jsxSymbol = (JsxSymbol)annotation;
                        if (!AbstractJavaScriptConfiguration.isSupported(jsxSymbol.value(), expectedBrowser)) continue;
                        String symbolKeyName = jsxSymbol.symbolName().isEmpty() ? method.getName() : jsxSymbol.symbolName();
                        if (!"iterator".equalsIgnoreCase(symbolKeyName)) {
                            throw new RuntimeException("Invalid JsxSymbol annotation; unsupported '" + symbolKeyName + "' symbol name.");
                        }
                        SymbolKey symbolKey = SymbolKey.ITERATOR;
                        classConfiguration.addSymbol(symbolKey, method);
                        continue;
                    }
                    if (annotation instanceof JsxFunction) {
                        JsxFunction jsxFunction = (JsxFunction)annotation;
                        if (!AbstractJavaScriptConfiguration.isSupported(jsxFunction.value(), expectedBrowser)) continue;
                        name = jsxFunction.functionName().isEmpty() ? method.getName() : jsxFunction.functionName();
                        classConfiguration.addFunction(name, method);
                        continue;
                    }
                    if (annotation instanceof JsxStaticGetter) {
                        JsxStaticGetter jsxStaticGetter = (JsxStaticGetter)annotation;
                        if (!AbstractJavaScriptConfiguration.isSupported(jsxStaticGetter.value(), expectedBrowser)) continue;
                        int prefix = method.getName().startsWith("is") ? 2 : 3;
                        String property = method.getName().substring(prefix);
                        property = Character.toLowerCase(property.charAt(0)) + property.substring(1);
                        classConfiguration.addStaticProperty(property, method, null);
                        continue;
                    }
                    if (annotation instanceof JsxStaticFunction) {
                        JsxStaticFunction jsxStaticFunction = (JsxStaticFunction)annotation;
                        if (!AbstractJavaScriptConfiguration.isSupported(jsxStaticFunction.value(), expectedBrowser)) continue;
                        name = jsxStaticFunction.functionName().isEmpty() ? method.getName() : jsxStaticFunction.functionName();
                        classConfiguration.addStaticFunction(name, method);
                        continue;
                    }
                    if (annotation instanceof JsxConstructor) {
                        JsxConstructor jsxConstructor = (JsxConstructor)annotation;
                        if (!AbstractJavaScriptConfiguration.isSupported(jsxConstructor.value(), expectedBrowser)) continue;
                        name = jsxConstructor.functionName().isEmpty() ? classConfiguration.getClassName() : jsxConstructor.functionName();
                        classConfiguration.setJSConstructor(name, method);
                        continue;
                    }
                    if (!(annotation instanceof JsxConstructorAlias) || !AbstractJavaScriptConfiguration.isSupported((jsxConstructorAlias = (JsxConstructorAlias)annotation).value(), expectedBrowser)) continue;
                    classConfiguration.setJSConstructorAlias(jsxConstructorAlias.alias());
                }
            }
            for (Map.Entry entry : allGetters.entrySet()) {
                String property = (String)entry.getKey();
                classConfiguration.addProperty(property, (Method)entry.getValue(), (Method)allSetters.get(property));
            }
            for (Field field : classConfiguration.getHostClass().getDeclaredFields()) {
                for (Annotation annotation : field.getAnnotations()) {
                    JsxSymbolConstant jsxSymbolConstant;
                    JsxConstant jsxConstant;
                    if (annotation instanceof JsxConstant && AbstractJavaScriptConfiguration.isSupported((jsxConstant = (JsxConstant)annotation).value(), expectedBrowser)) {
                        try {
                            classConfiguration.addConstant(field.getName(), field.get(null));
                        }
                        catch (IllegalAccessException e) {
                            throw JavaScriptEngine.reportRuntimeError("Cannot get field '" + field.getName() + "' for type: " + classConfiguration.getHostClass().getName() + "reason: " + e.getMessage());
                        }
                    }
                    if (!(annotation instanceof JsxSymbolConstant) || !AbstractJavaScriptConfiguration.isSupported((jsxSymbolConstant = (JsxSymbolConstant)annotation).value(), expectedBrowser)) continue;
                    if (!"TO_STRING_TAG".equalsIgnoreCase(field.getName())) {
                        throw new RuntimeException("Invalid JsxSymbol annotation; unsupported '" + field.getName() + "' symbol name.");
                    }
                    SymbolKey symbolKey = SymbolKey.TO_STRING_TAG;
                    classConfiguration.addSymbolConstant(symbolKey, field.get(null).toString());
                }
            }
        }
        catch (Throwable e) {
            throw new RuntimeException("Processing classConfiguration for class " + classConfiguration.getHostClassSimpleName() + "failed. Reason: " + e, e);
        }
    }

    private static boolean isSupported(SupportedBrowser[] browsers, SupportedBrowser expectedBrowser) {
        for (SupportedBrowser browser : browsers) {
            if (browser != expectedBrowser) continue;
            return true;
        }
        return false;
    }

    public Class<? extends HtmlUnitScriptable> getDomJavaScriptMappingFor(Class<?> clazz) {
        if (this.domJavaScriptMap_ == null) {
            ConcurrentHashMap map = new ConcurrentHashMap(this.configuration_.size());
            boolean debug = LOG.isDebugEnabled();
            for (ClassConfiguration classConfig : this.configuration_) {
                for (Class<?> domClass : classConfig.getDomClasses()) {
                    if (debug) {
                        LOG.debug((Object)("Mapping " + domClass.getName() + " to " + classConfig.getClassName()));
                    }
                    map.put(domClass, classConfig.getHostClass());
                }
            }
            this.domJavaScriptMap_ = map;
        }
        return this.domJavaScriptMap_.get(clazz);
    }

    protected ClassConfiguration getScopeConfiguration() {
        return this.scopeConfiguration_;
    }
}

